/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.storedfieldloader;

import io.skylite.common.util.set.Sets;
import io.skylite.core.ParseField;
import io.skylite.core.common.bytes.BytesArray;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.mapper.Uid;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.util.BytesRef;

public class StoredFieldsLoader
extends StoredFieldVisitor {
    private static final Set<String> BASE_REQUIRED_FIELDS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{ParseField.CommonMetaFields.ID_FIELD.getPreferredName(), ParseField.CommonMetaFields.ROUTING_FIELD.getPreferredName()}));
    private final boolean loadSource;
    private final String sourceFieldName;
    private final Set<String> requiredFields;
    protected BytesReference source;
    protected String id;
    protected Map<String, List<Object>> fieldsValues;

    public StoredFieldsLoader(boolean loadSource) {
        this(loadSource, ParseField.CommonMetaFields.SOURCE_FIELD.getPreferredName());
    }

    public StoredFieldsLoader(boolean loadSource, String sourceFieldName) {
        this.loadSource = loadSource;
        this.sourceFieldName = sourceFieldName;
        this.requiredFields = new HashSet<String>();
        this.reset();
    }

    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) {
        if (this.requiredFields.remove(fieldInfo.name)) {
            return StoredFieldVisitor.Status.YES;
        }
        if (fieldInfo.name.equals(ParseField.CommonMetaFields.IGNORED_FIELD.getPreferredName())) {
            return StoredFieldVisitor.Status.YES;
        }
        return this.requiredFields.isEmpty() ? StoredFieldVisitor.Status.STOP : StoredFieldVisitor.Status.NO;
    }

    public Set<String> getFieldNames() {
        return this.requiredFields;
    }

    public void binaryField(FieldInfo fieldInfo, byte[] value) {
        this.binaryField(fieldInfo, new BytesRef(value));
    }

    public void binaryField(FieldInfo fieldInfo, BytesRef value) {
        if (fieldInfo.name.equals(this.sourceFieldName)) {
            this.source = new BytesArray(value);
        } else if (ParseField.CommonMetaFields.ID_FIELD.getPreferredName().equals(fieldInfo.name)) {
            this.id = Uid.decodeId(value.bytes, value.offset, value.length);
        } else {
            this.addValue(fieldInfo.name, value);
        }
    }

    public void stringField(FieldInfo fieldInfo, String value) {
        assert (!ParseField.CommonMetaFields.ID_FIELD.getPreferredName().equals(fieldInfo.name)) : "_id field must go through binaryField";
        assert (!this.sourceFieldName.equals(fieldInfo.name)) : "source field must go through binaryField";
        this.addValue(fieldInfo.name, value);
    }

    public void intField(FieldInfo fieldInfo, int value) {
        this.addValue(fieldInfo.name, value);
    }

    public void longField(FieldInfo fieldInfo, long value) {
        this.addValue(fieldInfo.name, value);
    }

    public void floatField(FieldInfo fieldInfo, float value) {
        this.addValue(fieldInfo.name, Float.valueOf(value));
    }

    public void doubleField(FieldInfo fieldInfo, double value) {
        this.addValue(fieldInfo.name, value);
    }

    public void objectField(FieldInfo fieldInfo, Object object) {
        assert (!ParseField.CommonMetaFields.ID_FIELD.getPreferredName().equals(fieldInfo.name)) : "_id field must go through binaryField";
        assert (!this.sourceFieldName.equals(fieldInfo.name)) : "source field must go through binaryField";
        this.addValue(fieldInfo.name, object);
    }

    public BytesReference source() {
        return this.source;
    }

    public String id() {
        return this.id;
    }

    public String routing() {
        if (this.fieldsValues == null) {
            return null;
        }
        List<Object> values = this.fieldsValues.get(ParseField.CommonMetaFields.ROUTING_FIELD.getPreferredName());
        if (values == null || values.isEmpty()) {
            return null;
        }
        assert (values.size() == 1);
        return values.get(0).toString();
    }

    public Map<String, List<Object>> fields() {
        return this.fieldsValues != null ? this.fieldsValues : Collections.emptyMap();
    }

    public void reset() {
        if (this.fieldsValues != null) {
            this.fieldsValues.clear();
        }
        this.source = null;
        this.id = null;
        this.requiredFields.addAll(BASE_REQUIRED_FIELDS);
        if (this.loadSource) {
            this.requiredFields.add(this.sourceFieldName);
        }
    }

    private void addValue(String name, Object value) {
        List<Object> values;
        if (this.fieldsValues == null) {
            this.fieldsValues = new HashMap<String, List<Object>>();
        }
        if ((values = this.fieldsValues.get(name)) == null) {
            values = new ArrayList<Object>(2);
            this.fieldsValues.put(name, values);
        }
        values.add(value);
    }
}

