/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.translog;

import io.skylite.common.concurrent.ReleasableLock;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class TranslogChecksumContainer {
    private final Checksum checksum;
    private final AtomicLong contentLength;
    private final ReleasableLock updateLock = new ReleasableLock((Lock)new ReentrantLock());

    public TranslogChecksumContainer(byte[] bytes) {
        this.checksum = new CRC32();
        this.contentLength = new AtomicLong();
        this.updateFromBytes(bytes, 0, bytes.length);
    }

    public void updateFromBytes(byte[] bytes, int offset, int len) {
        try (ReleasableLock ignored = this.updateLock.acquire();){
            this.checksum.update(bytes, offset, len);
            this.updateContentLength(len);
        }
    }

    private void updateContentLength(long delta) {
        assert (this.updateLock.isHeldByCurrentThread());
        this.contentLength.addAndGet(delta);
    }

    public long getChecksum() {
        return this.checksum.getValue();
    }

    public long getContentLength() {
        return this.contentLength.get();
    }
}

