/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.translog;

import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionProvider;
import io.skylite.Version;
import io.skylite.common.CheckedFunction;
import io.skylite.core.common.io.stream.StreamInput;
import java.io.IOException;

public class TranslogCorruptedException
extends SkyliteException {
    public TranslogCorruptedException(String source, String details) {
        super(TranslogCorruptedException.corruptedMessage(source, details), new Object[0]);
    }

    public TranslogCorruptedException(String source, Throwable cause) {
        this(source, null, cause);
    }

    public TranslogCorruptedException(String source, String details, Throwable cause) {
        super(TranslogCorruptedException.corruptedMessage(source, details), cause, new Object[0]);
    }

    private static String corruptedMessage(String source, String details) {
        String msg = "translog from source [" + source + "] is corrupted";
        if (details != null) {
            msg = msg + ", " + details;
        }
        return msg;
    }

    public TranslogCorruptedException(StreamInput in) throws IOException {
        super(in);
    }

    public static class Registration
    implements SkyliteExceptionProvider<TranslogCorruptedException> {
        @Override
        public Class<TranslogCorruptedException> getExceptionClass() {
            return TranslogCorruptedException.class;
        }

        @Override
        public CheckedFunction<StreamInput, TranslogCorruptedException, IOException> getConstructor() {
            return TranslogCorruptedException::new;
        }

        @Override
        public Version<?> getVersionAdded() {
            return SkyliteException.UNKNOWN_VERSION_ADDED;
        }

        @Override
        public int getLegacyId() {
            return 48;
        }
    }
}

