/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.translog;

import io.skylite.common.Nullable;
import io.skylite.common.io.Channels;
import io.skylite.common.io.FileChannelFactory;
import io.skylite.common.util.io.IOUtils;
import io.skylite.core.index.translog.BaseTranslogReader;
import io.skylite.core.index.translog.Checkpoint;
import io.skylite.core.index.translog.Translog;
import io.skylite.core.index.translog.TranslogChecksumContainer;
import io.skylite.core.index.translog.TranslogHeader;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.store.AlreadyClosedException;

public class TranslogReader
extends BaseTranslogReader
implements Closeable {
    protected final long length;
    private final int totalOperations;
    private final Checkpoint checkpoint;
    protected final AtomicBoolean closed = new AtomicBoolean(false);
    @Nullable
    private final Long translogChecksum;
    @Nullable
    private final Long checkpointChecksum;

    TranslogReader(Checkpoint checkpoint, FileChannel channel, Path path, TranslogHeader header, Long translogChecksum) throws IOException {
        super(checkpoint.generation, channel, path, header);
        this.length = checkpoint.offset;
        this.totalOperations = checkpoint.numOps;
        this.checkpoint = checkpoint;
        this.translogChecksum = translogChecksum;
        this.checkpointChecksum = translogChecksum != null ? TranslogReader.calculateCheckpointChecksum(checkpoint, path) : null;
    }

    private static Long calculateCheckpointChecksum(Checkpoint checkpoint, Path path) throws IOException {
        TranslogChecksumContainer checkpointCheckedContainer = new TranslogChecksumContainer(Checkpoint.createCheckpointBytes(path.getParent().resolve("translog.ckp"), checkpoint));
        return checkpointCheckedContainer.getChecksum();
    }

    public Long getTranslogChecksum() {
        return this.translogChecksum;
    }

    public Long getCheckpointChecksum() {
        return this.checkpointChecksum;
    }

    public static TranslogReader open(FileChannel channel, Path path, Checkpoint checkpoint, String translogUUID) throws IOException {
        TranslogHeader header = TranslogHeader.read(translogUUID, path, channel);
        return new TranslogReader(checkpoint, channel, path, header, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TranslogReader closeIntoTrimmedReader(long aboveSeqNo, FileChannelFactory fileChannelFactory) throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            FileChannel toCloseOnFailure = this.channel;
            try {
                TranslogReader newReader;
                if (aboveSeqNo < this.checkpoint.trimmedAboveSeqNo || aboveSeqNo < this.checkpoint.maxSeqNo && this.checkpoint.trimmedAboveSeqNo == -2L) {
                    Path checkpointFile = this.path.getParent().resolve(Translog.getCommitCheckpointFileName(this.checkpoint.generation));
                    Checkpoint newCheckpoint = this.checkpoint.toBuilder().trimmedAboveSeqNo(aboveSeqNo).build();
                    Checkpoint.write(fileChannelFactory, checkpointFile, newCheckpoint, StandardOpenOption.WRITE);
                    IOUtils.fsync((Path)checkpointFile.getParent(), (boolean)true);
                    newReader = new TranslogReader(newCheckpoint, this.channel, this.path, this.header, this.translogChecksum);
                } else {
                    newReader = new TranslogReader(this.checkpoint, this.channel, this.path, this.header, this.translogChecksum);
                }
                toCloseOnFailure = null;
                TranslogReader translogReader = newReader;
                return translogReader;
            }
            finally {
                IOUtils.close((Closeable)toCloseOnFailure);
            }
        }
        throw new AlreadyClosedException(this.toString() + " is already closed");
    }

    @Override
    public long sizeInBytes() {
        return this.length;
    }

    @Override
    public int totalOperations() {
        return this.totalOperations;
    }

    @Override
    public final Checkpoint getCheckpoint() {
        return this.checkpoint;
    }

    @Override
    protected void readBytes(ByteBuffer buffer, long position) throws IOException {
        if (position >= this.length) {
            throw new EOFException("read requested past EOF. pos [" + position + "] end: [" + this.length + "]");
        }
        if (position < this.getFirstOperationOffset()) {
            throw new IOException("read requested before position of first ops. pos [" + position + "] first op on: [" + this.getFirstOperationOffset() + "]");
        }
        Channels.readFromFileChannelWithEofException((FileChannel)this.channel, (long)position, (ByteBuffer)buffer);
    }

    @Override
    public final void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.channel.close();
        }
    }

    protected final boolean isClosed() {
        return this.closed.get();
    }

    protected void ensureOpen() {
        if (this.isClosed()) {
            throw new AlreadyClosedException(this.toString() + " is already closed");
        }
    }

    public long getMinSeqNo() {
        return this.checkpoint.minSeqNo;
    }

    public long getMaxSeqNo() {
        return this.checkpoint.maxSeqNo;
    }
}

