/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.translog;

import io.skylite.common.UUIDs;
import io.skylite.core.common.unit.ByteSizeUnit;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.index.translog.TranslogStatelessHelper;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public final class TranslogSettings {
    public static final Setting<Durability> INDEX_TRANSLOG_DURABILITY_SETTING = new Setting<Durability>("index.translog.durability", Durability.REQUEST.name(), value -> Durability.valueOf(value.toUpperCase(Locale.ROOT)), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final int DEFAULT_HEADER_SIZE_IN_BYTES = TranslogStatelessHelper.headerSizeInBytes(UUIDs.randomBase64UUID());
    public static final Setting<ByteSizeValue> INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING = Setting.byteSizeSetting("index.translog.flush_threshold_size", new ByteSizeValue(512L, ByteSizeUnit.MB), new ByteSizeValue(DEFAULT_HEADER_SIZE_IN_BYTES + 1, ByteSizeUnit.BYTES), new ByteSizeValue(Long.MAX_VALUE, ByteSizeUnit.BYTES), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<ByteSizeValue> INDEX_TRANSLOG_GENERATION_THRESHOLD_SIZE_SETTING = Setting.byteSizeSetting("index.translog.generation_threshold_size", new ByteSizeValue(64L, ByteSizeUnit.MB), new ByteSizeValue(DEFAULT_HEADER_SIZE_IN_BYTES + 1, ByteSizeUnit.BYTES), new ByteSizeValue(Long.MAX_VALUE, ByteSizeUnit.BYTES), Setting.Property.Dynamic, Setting.Property.IndexScope);

    public static enum Durability {
        ASYNC,
        REQUEST;

    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(INDEX_TRANSLOG_DURABILITY_SETTING, INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING, INDEX_TRANSLOG_GENERATION_THRESHOLD_SIZE_SETTING);
        }
    }
}

