/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.translog;

import io.skylite.core.index.translog.Checkpoint;
import io.skylite.core.index.translog.TranslogCorruptedException;
import io.skylite.core.index.translog.TranslogHeader;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.util.BytesRef;

public class TranslogStatelessHelper {
    public static final String TRANSLOG_UUID_KEY = "translog_uuid";
    public static final String TRANSLOG_FILE_PREFIX = "translog-";
    public static final String TRANSLOG_FILE_SUFFIX = ".tlog";
    public static final String CHECKPOINT_SUFFIX = ".ckp";
    public static final String CHECKPOINT_FILE_NAME = "translog.ckp";

    private TranslogStatelessHelper() {
    }

    public static String getFilename(long generation) {
        return TRANSLOG_FILE_PREFIX + generation + TRANSLOG_FILE_SUFFIX;
    }

    public static Checkpoint readCheckpoint(Path location) throws IOException {
        return Checkpoint.read(location.resolve(CHECKPOINT_FILE_NAME));
    }

    public static long readGlobalCheckpoint(Path location, String expectedTranslogUUID) throws IOException {
        Checkpoint checkpoint = TranslogStatelessHelper.readCheckpoint(location, expectedTranslogUUID);
        return checkpoint.globalCheckpoint;
    }

    private static Checkpoint readCheckpoint(Path location, String expectedTranslogUUID) throws IOException {
        Checkpoint checkpoint = TranslogStatelessHelper.readCheckpoint(location);
        Path translogFile = location.resolve(TranslogStatelessHelper.getFilename(checkpoint.generation));
        try (FileChannel channel = FileChannel.open(translogFile, StandardOpenOption.READ);){
            TranslogHeader.read(expectedTranslogUUID, translogFile, channel);
        }
        catch (TranslogCorruptedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TranslogCorruptedException(location.toString(), ex);
        }
        return checkpoint;
    }

    public static long readMinTranslogGeneration(Path location, String expectedTranslogUUID) throws IOException {
        Checkpoint checkpoint = TranslogStatelessHelper.readCheckpoint(location, expectedTranslogUUID);
        return checkpoint.minTranslogGeneration;
    }

    public static Checkpoint emptyCheckpoint(long initialOffset, long initialGeneration, long initialGlobalCheckpoint, long initialMinTranslogGeneration) {
        return Checkpoint.builder().offset(initialOffset).generation(initialGeneration).globalCheckpoint(initialGlobalCheckpoint).minTranslogGeneration(initialMinTranslogGeneration).build();
    }

    public static int headerSizeInBytes(String translogUUID) {
        return TranslogStatelessHelper.headerSizeInBytes(3, new BytesRef((CharSequence)translogUUID).length);
    }

    public static int headerSizeInBytes(int version, int uuidLength) {
        int size = CodecUtil.headerLength((String)"translog");
        size += 4 + uuidLength;
        if (version >= 3) {
            size += 8;
            size += 4;
        }
        return size;
    }
}

