/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.translog;

import io.skylite.OpenSearchVersion;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.index.translog.RemoteTranslogStats;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;

public class TranslogStats
implements Writeable,
ToXContentFragment {
    private static final String TRANSLOG = "translog";
    private long translogSizeInBytes;
    private int numberOfOperations;
    private long uncommittedSizeInBytes;
    private int uncommittedOperations;
    private long earliestLastModifiedAge;
    private final RemoteTranslogStats remoteTranslogStats;

    public TranslogStats() {
        this.remoteTranslogStats = new RemoteTranslogStats();
    }

    public TranslogStats(StreamInput in) throws IOException {
        this.numberOfOperations = in.readVInt();
        this.translogSizeInBytes = in.readVLong();
        this.uncommittedOperations = in.readVInt();
        this.uncommittedSizeInBytes = in.readVLong();
        this.earliestLastModifiedAge = in.readVLong();
        this.remoteTranslogStats = in.getVersion().onOrAfter(OpenSearchVersion.V_2_10_0) ? in.readOptionalWriteable(RemoteTranslogStats::new) : new RemoteTranslogStats();
    }

    public TranslogStats(int numberOfOperations, long translogSizeInBytes, int uncommittedOperations, long uncommittedSizeInBytes, long earliestLastModifiedAge) {
        if (numberOfOperations < 0) {
            throw new IllegalArgumentException("numberOfOperations must be >= 0");
        }
        if (translogSizeInBytes < 0L) {
            throw new IllegalArgumentException("translogSizeInBytes must be >= 0");
        }
        if (uncommittedOperations < 0) {
            throw new IllegalArgumentException("uncommittedOperations must be >= 0");
        }
        if (uncommittedSizeInBytes < 0L) {
            throw new IllegalArgumentException("uncommittedSizeInBytes must be >= 0");
        }
        if (earliestLastModifiedAge < 0L) {
            throw new IllegalArgumentException("earliestLastModifiedAge must be >= 0");
        }
        this.numberOfOperations = numberOfOperations;
        this.translogSizeInBytes = translogSizeInBytes;
        this.uncommittedSizeInBytes = uncommittedSizeInBytes;
        this.uncommittedOperations = uncommittedOperations;
        this.earliestLastModifiedAge = earliestLastModifiedAge;
        this.remoteTranslogStats = new RemoteTranslogStats();
    }

    public void addRemoteTranslogStats(RemoteTranslogStats remoteTranslogStats) {
        if (this.remoteTranslogStats != null) {
            this.remoteTranslogStats.add(remoteTranslogStats);
        }
    }

    public void add(TranslogStats other) {
        if (other == null) {
            return;
        }
        this.numberOfOperations += other.numberOfOperations;
        this.translogSizeInBytes += other.translogSizeInBytes;
        this.uncommittedOperations += other.uncommittedOperations;
        this.uncommittedSizeInBytes += other.uncommittedSizeInBytes;
        this.earliestLastModifiedAge = this.earliestLastModifiedAge == 0L ? other.earliestLastModifiedAge : Math.min(this.earliestLastModifiedAge, other.earliestLastModifiedAge);
        this.addRemoteTranslogStats(other.remoteTranslogStats);
    }

    public long getTranslogSizeInBytes() {
        return this.translogSizeInBytes;
    }

    public int estimatedNumberOfOperations() {
        return this.numberOfOperations;
    }

    public long getUncommittedSizeInBytes() {
        return this.uncommittedSizeInBytes;
    }

    public int getUncommittedOperations() {
        return this.uncommittedOperations;
    }

    public long getEarliestLastModifiedAge() {
        return this.earliestLastModifiedAge;
    }

    public RemoteTranslogStats getRemoteTranslogStats() {
        return this.remoteTranslogStats;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(TRANSLOG);
        this.addLocalTranslogStatsXContent(builder);
        if (this.remoteTranslogStats != null) {
            builder = this.remoteTranslogStats.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this, true, true);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.numberOfOperations);
        out.writeVLong(this.translogSizeInBytes);
        out.writeVInt(this.uncommittedOperations);
        out.writeVLong(this.uncommittedSizeInBytes);
        out.writeVLong(this.earliestLastModifiedAge);
        if (out.getVersion().onOrAfter(OpenSearchVersion.V_2_10_0)) {
            out.writeOptionalWriteable(this.remoteTranslogStats);
        }
    }

    private void addLocalTranslogStatsXContent(XContentBuilder builder) throws IOException {
        builder.field("operations", this.numberOfOperations);
        builder.humanReadableField("size_in_bytes", "size", new ByteSizeValue(this.translogSizeInBytes));
        builder.field("uncommitted_operations", this.uncommittedOperations);
        builder.humanReadableField("uncommitted_size_in_bytes", "uncommitted_size", new ByteSizeValue(this.uncommittedSizeInBytes));
        builder.field("earliest_last_modified_age", this.earliestLastModifiedAge);
    }
}

