/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.warmer;

import io.skylite.common.metrics.CounterMetric;
import io.skylite.common.metrics.MeanMetric;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.shard.AbstractIndexShardComponent;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.warmer.WarmerStats;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;

public class ShardIndexWarmerService
extends AbstractIndexShardComponent {
    private final CounterMetric current = new CounterMetric();
    private final MeanMetric warmerMetric = new MeanMetric();

    public ShardIndexWarmerService(ShardId shardId, IndexSettings indexSettings) {
        super(shardId, indexSettings);
    }

    public Logger logger() {
        return this.logger;
    }

    public void onPreWarm() {
        this.current.inc();
    }

    public void onPostWarm(long tookInNanos) {
        this.current.dec();
        this.warmerMetric.inc(tookInNanos);
    }

    public WarmerStats stats() {
        return new WarmerStats(this.current.count(), this.warmerMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.warmerMetric.sum()));
    }
}

