/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.indices;

import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.AbstractRunnable;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.index.engine.EngineOperation;
import io.skylite.core.index.engine.EngineResult;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.IndexShardState;
import io.skylite.core.index.shard.IndexingOperationListener;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.indices.IndicesMemorySettings;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.Scheduler;
import io.skylite.core.threadpool.ThreadPool;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.AlreadyClosedException;

public class IndexingMemoryController
implements IndexingOperationListener,
Closeable {
    private static final Logger logger = LogManager.getLogger(IndexingMemoryController.class);
    private final ThreadPool threadPool;
    private final Iterable<BaseIndexShard> indexShards;
    private final ByteSizeValue indexingBuffer;
    private final TimeValue inactiveTime;
    private final TimeValue interval;
    private final Set<BaseIndexShard> throttled = new HashSet<BaseIndexShard>();
    private final Scheduler.Cancellable scheduler;
    private static final EnumSet<IndexShardState> CAN_WRITE_INDEX_BUFFER_STATES = EnumSet.of(IndexShardState.RECOVERING, IndexShardState.POST_RECOVERY, IndexShardState.STARTED);
    private final ShardsIndicesStatusChecker statusChecker;

    public IndexingMemoryController(Settings settings, ThreadPool threadPool, Iterable<BaseIndexShard> indexServices) {
        this.indexShards = indexServices;
        ByteSizeValue indexingBuffer = IndicesMemorySettings.INDEX_BUFFER_SIZE_SETTING.get(settings);
        String indexingBufferSetting = settings.get(IndicesMemorySettings.INDEX_BUFFER_SIZE_SETTING.getKey());
        if (indexingBufferSetting == null || indexingBufferSetting.endsWith("%")) {
            ByteSizeValue minIndexingBuffer = IndicesMemorySettings.MIN_INDEX_BUFFER_SIZE_SETTING.get(settings);
            ByteSizeValue maxIndexingBuffer = IndicesMemorySettings.MAX_INDEX_BUFFER_SIZE_SETTING.get(settings);
            if (indexingBuffer.getBytes() < minIndexingBuffer.getBytes()) {
                indexingBuffer = minIndexingBuffer;
            }
            if (maxIndexingBuffer.getBytes() != -1L && indexingBuffer.getBytes() > maxIndexingBuffer.getBytes()) {
                indexingBuffer = maxIndexingBuffer;
            }
        }
        this.indexingBuffer = indexingBuffer;
        this.inactiveTime = IndicesMemorySettings.SHARD_INACTIVE_TIME_SETTING.get(settings);
        this.interval = IndicesMemorySettings.SHARD_MEMORY_INTERVAL_TIME_SETTING.get(settings);
        this.statusChecker = new ShardsIndicesStatusChecker();
        logger.debug("using indexing buffer size [{}] with {} [{}], {} [{}]", (Object)this.indexingBuffer, (Object)IndicesMemorySettings.SHARD_INACTIVE_TIME_SETTING.getKey(), (Object)this.inactiveTime, (Object)IndicesMemorySettings.SHARD_MEMORY_INTERVAL_TIME_SETTING.getKey(), (Object)this.interval);
        this.scheduler = this.scheduleTask(threadPool);
        this.threadPool = threadPool;
    }

    protected Scheduler.Cancellable scheduleTask(ThreadPool threadPool) {
        return threadPool.scheduleWithFixedDelay(this.statusChecker, this.interval, "same");
    }

    @Override
    public void close() {
        this.scheduler.cancel();
    }

    public ByteSizeValue indexingBufferSize() {
        return this.indexingBuffer;
    }

    protected List<BaseIndexShard> availableShards() {
        ArrayList<BaseIndexShard> availableShards = new ArrayList<BaseIndexShard>();
        for (BaseIndexShard shard : this.indexShards) {
            if (!CAN_WRITE_INDEX_BUFFER_STATES.contains((Object)shard.state())) continue;
            availableShards.add(shard);
        }
        return availableShards;
    }

    protected long getIndexBufferRAMBytesUsed(BaseIndexShard shard) {
        return shard.getIndexBufferRAMBytesUsed();
    }

    protected long getShardWritingBytes(BaseIndexShard shard) {
        return shard.getWritingBytes();
    }

    protected void writeIndexingBufferAsync(final BaseIndexShard shard) {
        this.threadPool.executor("refresh").execute((Runnable)new AbstractRunnable(this){

            public void doRun() {
                shard.writeIndexingBuffer();
            }

            public void onFailure(Exception e) {
                logger.warn(() -> new ParameterizedMessage("failed to write indexing buffer for shard [{}]; ignoring", (Object)shard.shardId()), (Throwable)e);
            }
        });
    }

    void forceCheck() {
        this.statusChecker.run();
    }

    protected void activateThrottling(BaseIndexShard shard) {
        shard.activateThrottling();
    }

    protected void deactivateThrottling(BaseIndexShard shard) {
        shard.deactivateThrottling();
    }

    @Override
    public void postIndex(ShardId shardId, EngineOperation.Index index, EngineResult.IndexResult result) {
        this.recordOperationBytes(index, result);
    }

    @Override
    public void postDelete(ShardId shardId, EngineOperation.Delete delete, EngineResult.DeleteResult result) {
        this.recordOperationBytes(delete, result);
    }

    private void recordOperationBytes(EngineOperation operation, EngineResult result) {
        if (result.getResultType() == EngineResult.Type.SUCCESS) {
            this.statusChecker.bytesWritten(operation.estimatedSizeInBytes());
        }
    }

    protected void checkIdle(BaseIndexShard shard, long inactiveTimeNS) {
        try {
            shard.flushOnIdle(inactiveTimeNS);
        }
        catch (AlreadyClosedException e) {
            logger.trace(() -> new ParameterizedMessage("ignore exception while checking if shard {} is inactive", (Object)shard.shardId()), (Throwable)e);
        }
    }

    final class ShardsIndicesStatusChecker
    implements Runnable {
        final AtomicLong bytesWrittenSinceCheck = new AtomicLong();
        final ReentrantLock runLock = new ReentrantLock();

        ShardsIndicesStatusChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bytesWritten(int bytes) {
            long totalBytes = this.bytesWrittenSinceCheck.addAndGet(bytes);
            assert (totalBytes >= 0L);
            while (totalBytes > IndexingMemoryController.this.indexingBuffer.getBytes() / 30L && this.runLock.tryLock()) {
                try {
                    totalBytes = this.bytesWrittenSinceCheck.get();
                    if (totalBytes > IndexingMemoryController.this.indexingBuffer.getBytes() / 30L) {
                        this.bytesWrittenSinceCheck.addAndGet(-totalBytes);
                        this.runUnlocked();
                    }
                }
                finally {
                    this.runLock.unlock();
                }
                totalBytes = this.bytesWrittenSinceCheck.get();
            }
        }

        @Override
        public void run() {
            this.runLock.lock();
            try {
                this.runUnlocked();
            }
            finally {
                this.runLock.unlock();
            }
        }

        private void runUnlocked() {
            boolean doThrottle;
            long totalBytesUsed = 0L;
            long totalBytesWriting = 0L;
            for (BaseIndexShard shard : IndexingMemoryController.this.availableShards()) {
                IndexingMemoryController.this.checkIdle(shard, IndexingMemoryController.this.inactiveTime.nanos());
                long shardWritingBytes = IndexingMemoryController.this.getShardWritingBytes(shard);
                long shardBytesUsed = IndexingMemoryController.this.getIndexBufferRAMBytesUsed(shard);
                totalBytesWriting += shardWritingBytes;
                if ((shardBytesUsed -= shardWritingBytes) < 0L) continue;
                totalBytesUsed += shardBytesUsed;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("total indexing heap bytes used [{}] vs {} [{}], currently writing bytes [{}]", (Object)new ByteSizeValue(totalBytesUsed), (Object)IndicesMemorySettings.INDEX_BUFFER_SIZE_SETTING.getKey(), (Object)IndexingMemoryController.this.indexingBuffer, (Object)new ByteSizeValue(totalBytesWriting));
            }
            boolean bl = doThrottle = (double)(totalBytesWriting + totalBytesUsed) > 1.5 * (double)IndexingMemoryController.this.indexingBuffer.getBytes();
            if (totalBytesUsed > IndexingMemoryController.this.indexingBuffer.getBytes()) {
                PriorityQueue<ShardAndBytesUsed> queue = new PriorityQueue<ShardAndBytesUsed>();
                for (BaseIndexShard shard : IndexingMemoryController.this.availableShards()) {
                    long shardWritingBytes = IndexingMemoryController.this.getShardWritingBytes(shard);
                    long shardBytesUsed = IndexingMemoryController.this.getIndexBufferRAMBytesUsed(shard);
                    if ((shardBytesUsed -= shardWritingBytes) < 0L || shardBytesUsed <= 0L) continue;
                    if (logger.isTraceEnabled()) {
                        if (shardWritingBytes != 0L) {
                            logger.trace("shard [{}] is using [{}] heap, writing [{}] heap", (Object)shard.shardId(), (Object)shardBytesUsed, (Object)shardWritingBytes);
                        } else {
                            logger.trace("shard [{}] is using [{}] heap, not writing any bytes", (Object)shard.shardId(), (Object)shardBytesUsed);
                        }
                    }
                    queue.add(new ShardAndBytesUsed(shardBytesUsed, shard));
                }
                logger.debug("now write some indexing buffers: total indexing heap bytes used [{}] vs {} [{}], currently writing bytes [{}], [{}] shards with non-zero indexing buffer", (Object)new ByteSizeValue(totalBytesUsed), (Object)IndicesMemorySettings.INDEX_BUFFER_SIZE_SETTING.getKey(), (Object)IndexingMemoryController.this.indexingBuffer, (Object)new ByteSizeValue(totalBytesWriting), (Object)queue.size());
                while (totalBytesUsed > IndexingMemoryController.this.indexingBuffer.getBytes() && !queue.isEmpty()) {
                    ShardAndBytesUsed largest = (ShardAndBytesUsed)queue.poll();
                    logger.debug("write indexing buffer to disk for shard [{}] to free up its [{}] indexing buffer", (Object)largest.shard.shardId(), (Object)new ByteSizeValue(largest.bytesUsed));
                    IndexingMemoryController.this.writeIndexingBufferAsync(largest.shard);
                    totalBytesUsed -= largest.bytesUsed;
                    if (!doThrottle || IndexingMemoryController.this.throttled.contains(largest.shard)) continue;
                    logger.info("now throttling indexing for shard [{}]: segment writing can't keep up", (Object)largest.shard.shardId());
                    IndexingMemoryController.this.throttled.add(largest.shard);
                    IndexingMemoryController.this.activateThrottling(largest.shard);
                }
            }
            if (!doThrottle) {
                for (BaseIndexShard shard : IndexingMemoryController.this.throttled) {
                    logger.info("stop throttling indexing for shard [{}]", (Object)shard.shardId());
                    IndexingMemoryController.this.deactivateThrottling(shard);
                }
                IndexingMemoryController.this.throttled.clear();
            }
        }
    }

    private static final class ShardAndBytesUsed
    implements Comparable<ShardAndBytesUsed> {
        final long bytesUsed;
        final BaseIndexShard shard;

        ShardAndBytesUsed(long bytesUsed, BaseIndexShard shard) {
            this.bytesUsed = bytesUsed;
            this.shard = shard;
        }

        @Override
        public int compareTo(ShardAndBytesUsed other) {
            return Long.compare(other.bytesUsed, this.bytesUsed);
        }
    }
}

