/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.indices.recovery;

import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.indices.cluster.BaseIndicesClusterStateService;
import io.skylite.core.indices.replication.common.ReplicationFailedException;
import io.skylite.core.indices.replication.common.ReplicationListener;
import io.skylite.core.indices.replication.common.ReplicationState;

public class RecoveryListener
implements ReplicationListener {
    private final ShardRouting shardRouting;
    private final long primaryTerm;
    private final BaseIndicesClusterStateService indicesClusterStateService;

    public RecoveryListener(ShardRouting shardRouting, long primaryTerm, BaseIndicesClusterStateService indicesClusterStateService) {
        this.shardRouting = shardRouting;
        this.primaryTerm = primaryTerm;
        this.indicesClusterStateService = indicesClusterStateService;
    }

    @Override
    public void onDone(ReplicationState state) {
        this.indicesClusterStateService.handleRecoveryDone(state, this.shardRouting, this.primaryTerm);
    }

    @Override
    public void onFailure(ReplicationState state, ReplicationFailedException e, boolean sendShardFailure) {
        this.indicesClusterStateService.handleRecoveryFailure(this.shardRouting, sendShardFailure, e);
    }
}

