/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.ingest;

import io.skylite.common.action.ActionListener;
import io.skylite.common.processor.AbstractProcessor;
import io.skylite.core.action.DocWriteRequest;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.ingest.PutPipelineRequest;
import io.skylite.core.cluster.metadata.IndexAbstraction;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.IndexTemplateMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.metadata.MetadataIndexTemplateUtility;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.ingest.IngestInfo;
import io.skylite.core.ingest.Pipeline;
import io.skylite.core.script.ScriptService;
import io.skylite.core.settings.Settings;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.IntConsumer;

public abstract class BaseIngestService {
    protected final ScriptService scriptService;

    public BaseIngestService(ScriptService scriptService) {
        this.scriptService = scriptService;
    }

    public static boolean resolvePipelines(DocWriteRequest<?> originalRequest, IndexRequest indexRequest, Metadata metadata) {
        if (!indexRequest.isPipelineResolved()) {
            IndexAbstraction indexAbstraction;
            String requestPipeline = indexRequest.getPipeline();
            indexRequest.setPipeline("_none");
            indexRequest.setFinalPipeline("_none");
            String defaultPipeline = null;
            String finalPipeline = null;
            IndexMetadata indexMetadata = null;
            if (originalRequest != null) {
                indexMetadata = metadata.indices().get(originalRequest.index());
            }
            if (indexMetadata == null && indexRequest.index() != null && (indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(indexRequest.index())) != null) {
                indexMetadata = indexAbstraction.getWriteIndex();
            }
            if (indexMetadata == null && originalRequest != null && originalRequest.index() != null && (indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(originalRequest.index())) != null) {
                indexMetadata = indexAbstraction.getWriteIndex();
            }
            if (indexMetadata != null) {
                Settings indexSettings = indexMetadata.getSettings();
                if (IndexSettings.DEFAULT_PIPELINE.exists(indexSettings)) {
                    defaultPipeline = IndexSettings.DEFAULT_PIPELINE.get(indexSettings);
                    indexRequest.setPipeline(defaultPipeline);
                }
                if (IndexSettings.FINAL_PIPELINE.exists(indexSettings)) {
                    finalPipeline = IndexSettings.FINAL_PIPELINE.get(indexSettings);
                    indexRequest.setFinalPipeline(finalPipeline);
                }
            } else if (indexRequest.index() != null) {
                String v2Template = MetadataIndexTemplateUtility.findV2Template(metadata, indexRequest.index(), false);
                if (v2Template != null) {
                    Settings settings = MetadataIndexTemplateUtility.resolveSettings(metadata, v2Template);
                    if (IndexSettings.DEFAULT_PIPELINE.exists(settings)) {
                        defaultPipeline = IndexSettings.DEFAULT_PIPELINE.get(settings);
                    }
                    if (IndexSettings.FINAL_PIPELINE.exists(settings)) {
                        finalPipeline = IndexSettings.FINAL_PIPELINE.get(settings);
                    }
                    indexRequest.setPipeline(defaultPipeline != null ? defaultPipeline : "_none");
                    indexRequest.setFinalPipeline(finalPipeline != null ? finalPipeline : "_none");
                } else {
                    List<IndexTemplateMetadata> templates = MetadataIndexTemplateUtility.findV1Templates(metadata, indexRequest.index(), null);
                    for (IndexTemplateMetadata template : templates) {
                        Settings settings = template.settings();
                        if (defaultPipeline == null && IndexSettings.DEFAULT_PIPELINE.exists(settings)) {
                            defaultPipeline = IndexSettings.DEFAULT_PIPELINE.get(settings);
                        }
                        if (finalPipeline == null && IndexSettings.FINAL_PIPELINE.exists(settings)) {
                            finalPipeline = IndexSettings.FINAL_PIPELINE.get(settings);
                        }
                        if (defaultPipeline == null || finalPipeline == null) continue;
                        break;
                    }
                    indexRequest.setPipeline(defaultPipeline != null ? defaultPipeline : "_none");
                    indexRequest.setFinalPipeline(finalPipeline != null ? finalPipeline : "_none");
                }
            }
            if (requestPipeline != null) {
                indexRequest.setPipeline(requestPipeline);
            }
            indexRequest.isPipelineResolved(true);
        }
        return !"_none".equals(indexRequest.getPipeline()) || !"_none".equals(indexRequest.getFinalPipeline());
    }

    public abstract void executeBulkRequest(int var1, Iterable<DocWriteRequest<?>> var2, BiConsumer<Integer, Exception> var3, BiConsumer<Thread, Exception> var4, IntConsumer var5, String var6);

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    public abstract void putPipeline(Map<DiscoveryNode, IngestInfo> var1, PutPipelineRequest var2, ActionListener<AcknowledgedResponse> var3) throws Exception;

    public abstract Pipeline getPipeline(String var1);

    public abstract Map<String, AbstractProcessor.Factory<?>> getProcessorFactories();
}

