/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.ingest;

import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteParseException;
import io.skylite.common.ExceptionsHelper;
import io.skylite.common.Nullable;
import io.skylite.common.processor.AbstractProcessor;
import io.skylite.core.ingest.CompoundProcessor;
import io.skylite.core.ingest.ConditionalProcessor;
import io.skylite.core.ingest.IngestProcessor;
import io.skylite.core.script.Script;
import io.skylite.core.script.ScriptService;
import io.skylite.core.script.ScriptType;
import io.skylite.core.script.TemplateScript;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ConfigurationUtils {
    public static final String TAG_KEY = "tag";
    public static final String DESCRIPTION_KEY = "description";
    public static final String IGNORE_FAILURE_KEY = "ignore_failure";

    private ConfigurationUtils() {
    }

    public static String readOptionalStringProperty(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        Object value = configuration.remove(propertyName);
        return ConfigurationUtils.readString(processorType, processorTag, propertyName, value);
    }

    public static String readStringProperty(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        return ConfigurationUtils.readStringProperty(processorType, processorTag, configuration, propertyName, null);
    }

    public static String readStringProperty(String processorType, String processorTag, Map<String, Object> configuration, String propertyName, String defaultValue) {
        Object value = configuration.remove(propertyName);
        if (value == null && defaultValue != null) {
            return defaultValue;
        }
        if (value == null) {
            throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "required property is missing");
        }
        return ConfigurationUtils.readString(processorType, processorTag, propertyName, value);
    }

    private static String readString(String processorType, String processorTag, String propertyName, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "property isn't a string, but of type [" + value.getClass().getName() + "]");
    }

    public static String readStringOrIntProperty(String processorType, String processorTag, Map<String, Object> configuration, String propertyName, String defaultValue) {
        Object value = configuration.remove(propertyName);
        if (value == null && defaultValue != null) {
            return defaultValue;
        }
        if (value == null) {
            throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "required property is missing");
        }
        return ConfigurationUtils.readStringOrInt(processorType, processorTag, propertyName, value);
    }

    private static String readStringOrInt(String processorType, String processorTag, String propertyName, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Integer) {
            return String.valueOf(value);
        }
        throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "property isn't a string or int, but of type [" + value.getClass().getName() + "]");
    }

    public static String readOptionalStringOrIntProperty(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            return null;
        }
        return ConfigurationUtils.readStringOrInt(processorType, processorTag, propertyName, value);
    }

    public static boolean readBooleanProperty(String processorType, String processorTag, Map<String, Object> configuration, String propertyName, boolean defaultValue) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            return defaultValue;
        }
        return ConfigurationUtils.readBoolean(processorType, processorTag, propertyName, value);
    }

    private static Boolean readBoolean(String processorType, String processorTag, String propertyName, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (boolean)((Boolean)value);
        }
        throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "property isn't a boolean, but of type [" + value.getClass().getName() + "]");
    }

    public static Integer readIntProperty(String processorType, String processorTag, Map<String, Object> configuration, String propertyName, Integer defaultValue) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (Exception e) {
            throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "property cannot be converted to an int [" + value.toString() + "]");
        }
    }

    public static Double readDoubleProperty(String processorType, String processorTag, Map<String, Object> configuration, String propertyName, double defaultValue) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value.toString());
        }
        catch (Exception e) {
            throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "property cannot be converted to a double [" + value.toString() + "]");
        }
    }

    public static Double readDoubleProperty(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "required property is missing");
        }
        try {
            return Double.parseDouble(value.toString());
        }
        catch (Exception e) {
            throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "property cannot be converted to a double [" + value.toString() + "]");
        }
    }

    public static <T> List<T> readOptionalList(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            return null;
        }
        return ConfigurationUtils.readList(processorType, processorTag, propertyName, value);
    }

    public static <T> List<T> readList(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "required property is missing");
        }
        return ConfigurationUtils.readList(processorType, processorTag, propertyName, value);
    }

    private static <T> List<T> readList(String processorType, String processorTag, String propertyName, Object value) {
        if (value instanceof List) {
            List stringList = (List)value;
            return stringList;
        }
        throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "property isn't a list, but of type [" + value.getClass().getName() + "]");
    }

    public static <T> Map<String, T> readMap(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "required property is missing");
        }
        return ConfigurationUtils.readMap(processorType, processorTag, propertyName, value);
    }

    public static <T> Map<String, T> readOptionalMap(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            return null;
        }
        return ConfigurationUtils.readMap(processorType, processorTag, propertyName, value);
    }

    private static <T> Map<String, T> readMap(String processorType, String processorTag, String propertyName, Object value) {
        if (value instanceof Map) {
            Map map = (Map)value;
            return map;
        }
        throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "property isn't a map, but of type [" + value.getClass().getName() + "]");
    }

    public static Object readObject(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "required property is missing");
        }
        return value;
    }

    public static SkyliteException newConfigurationException(String processorType, String processorTag, String propertyName, String reason) {
        Object msg = propertyName == null ? reason : "[" + propertyName + "] " + reason;
        SkyliteParseException exception = new SkyliteParseException((String)msg, new Object[0]);
        ConfigurationUtils.addMetadataToException(exception, processorType, processorTag, propertyName);
        return exception;
    }

    public static SkyliteException newConfigurationException(String processorType, String processorTag, String propertyName, Exception cause) {
        SkyliteException exception = SkyliteExceptionsHelper.convertToOpenSearchException(cause);
        ConfigurationUtils.addMetadataToException(exception, processorType, processorTag, propertyName);
        return exception;
    }

    public static List<IngestProcessor> readProcessorConfigs(List<Map<String, Object>> processorConfigs, ScriptService scriptService, Map<String, AbstractProcessor.Factory<?>> processorFactories) throws Exception {
        Exception exception = null;
        ArrayList<IngestProcessor> processors = new ArrayList<IngestProcessor>();
        if (processorConfigs != null) {
            for (Map<String, Object> processorConfigWithKey : processorConfigs) {
                for (Map.Entry<String, Object> entry : processorConfigWithKey.entrySet()) {
                    try {
                        processors.add(ConfigurationUtils.readProcessor(processorFactories, scriptService, entry.getKey(), entry.getValue()));
                    }
                    catch (Exception e) {
                        exception = (Exception)ExceptionsHelper.useOrSuppress(exception, (Throwable)e);
                    }
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        return processors;
    }

    public static TemplateScript.Factory readTemplateProperty(String processorType, String processorTag, Map<String, Object> configuration, String propertyName, ScriptService scriptService) {
        String value = ConfigurationUtils.readStringProperty(processorType, processorTag, configuration, propertyName, null);
        return ConfigurationUtils.compileTemplate(processorType, processorTag, propertyName, value, scriptService);
    }

    public static TemplateScript.Factory compileTemplate(String processorType, String processorTag, String propertyName, final String propertyValue, ScriptService scriptService) {
        try {
            if (scriptService.isLangSupported("mustache") && propertyValue.contains("{{")) {
                Script script = new Script(ScriptType.INLINE, "mustache", propertyValue, Collections.emptyMap());
                return scriptService.compile(script, TemplateScript.CONTEXT);
            }
            return params -> new TemplateScript(params){

                @Override
                public String execute() {
                    return propertyValue;
                }
            };
        }
        catch (Exception e) {
            throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, e);
        }
    }

    private static void addMetadataToException(SkyliteException exception, String processorType, String processorTag, String propertyName) {
        if (processorType != null) {
            exception.addMetadata("skylite.processor_type", processorType);
        }
        if (processorTag != null) {
            exception.addMetadata("skylite.processor_tag", processorTag);
        }
        if (propertyName != null) {
            exception.addMetadata("skylite.property_name", propertyName);
        }
    }

    public static IngestProcessor readProcessor(Map<String, AbstractProcessor.Factory<?>> processorFactories, ScriptService scriptService, String type, @Nullable Object config) throws Exception {
        if (config == null) {
            throw ConfigurationUtils.newConfigurationException(type, null, null, "the config of processor [" + type + "] cannot be null");
        }
        if (config instanceof Map) {
            return ConfigurationUtils.readProcessor(processorFactories, scriptService, type, (Map)config);
        }
        if (config instanceof String && "script".equals(type)) {
            HashMap<String, Object> normalizedScript = new HashMap<String, Object>(1);
            normalizedScript.put(ScriptType.INLINE.getParseField().getPreferredName(), config);
            return ConfigurationUtils.readProcessor(processorFactories, scriptService, type, normalizedScript);
        }
        throw ConfigurationUtils.newConfigurationException(type, null, null, "property isn't a map, but of type [" + config.getClass().getName() + "]");
    }

    public static IngestProcessor readProcessor(Map<String, AbstractProcessor.Factory<?>> processorFactories, ScriptService scriptService, String type, @Nullable Map<String, Object> config) throws Exception {
        if (config == null) {
            throw ConfigurationUtils.newConfigurationException(type, null, null, "expect the config of processor [" + type + "] to be map, but is null");
        }
        String tag = ConfigurationUtils.readOptionalStringProperty(null, null, config, TAG_KEY);
        String description = ConfigurationUtils.readOptionalStringProperty(null, tag, config, DESCRIPTION_KEY);
        boolean ignoreFailure = ConfigurationUtils.readBooleanProperty(null, null, config, IGNORE_FAILURE_KEY, false);
        Script conditionalScript = ConfigurationUtils.extractConditional(config);
        AbstractProcessor.Factory<?> factory = processorFactories.get(type);
        if (factory != null) {
            List<Map<String, Object>> onFailureProcessorConfigs = ConfigurationUtils.readOptionalList(null, null, config, "on_failure");
            List<IngestProcessor> onFailureProcessors = ConfigurationUtils.readProcessorConfigs(onFailureProcessorConfigs, scriptService, processorFactories);
            if (onFailureProcessorConfigs != null && onFailureProcessors.isEmpty()) {
                throw ConfigurationUtils.newConfigurationException(type, tag, "on_failure", "processors list cannot be empty");
            }
            try {
                IngestProcessor processor = (IngestProcessor)factory.create(processorFactories, tag, description, config);
                if (!config.isEmpty()) {
                    throw new SkyliteParseException("processor [{}] doesn't support one or more provided configuration parameters {}", type, Arrays.toString(config.keySet().toArray()));
                }
                if (onFailureProcessors.size() > 0 || ignoreFailure) {
                    processor = new CompoundProcessor(ignoreFailure, Collections.singletonList(processor), onFailureProcessors);
                }
                if (conditionalScript != null) {
                    processor = new ConditionalProcessor(tag, description, conditionalScript, scriptService, processor);
                }
                return processor;
            }
            catch (Exception e) {
                throw ConfigurationUtils.newConfigurationException(type, tag, null, e);
            }
        }
        throw ConfigurationUtils.newConfigurationException(type, tag, null, "No processor type exists with name [" + type + "]");
    }

    /*
     * Exception decompiling
     */
    private static Script extractConditional(Map<String, Object> config) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Map<String, Object> normalizeScript(Object scriptConfig) {
        if (scriptConfig instanceof Map) {
            return (Map)scriptConfig;
        }
        if (scriptConfig instanceof String) {
            return Collections.singletonMap("source", scriptConfig);
        }
        throw ConfigurationUtils.newConfigurationException("conditional", null, "script", "property isn't a map or string, but of type [" + scriptConfig.getClass().getName() + "]");
    }
}

