/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.ingest;

import io.skylite.core.analysis.AnalysisRegistry;
import io.skylite.core.client.ReleasableSkyliteClient;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.env.Environment;
import io.skylite.core.ingest.BaseIngestService;
import io.skylite.core.ingest.IngestDocument;
import io.skylite.core.script.ScriptService;
import io.skylite.core.threadpool.Scheduler;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.LongSupplier;

public interface IngestProcessor {
    public String getType();

    public String getTag();

    public String getDescription();

    default public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        IngestDocument result;
        try {
            result = this.execute(ingestDocument);
        }
        catch (Exception e) {
            handler.accept(null, e);
            return;
        }
        handler.accept(result, null);
    }

    public IngestDocument execute(IngestDocument var1) throws Exception;

    public static class Parameters {
        public final Environment env;
        public final ScriptService scriptService;
        public final AnalysisRegistry analysisRegistry;
        public final ThreadContext threadContext;
        public final LongSupplier relativeTimeSupplier;
        public final BaseIngestService ingestService;
        public final Consumer<Runnable> genericExecutor;
        public final BiFunction<Long, Runnable, Scheduler.ScheduledCancellable> scheduler;
        public final ReleasableSkyliteClient client;

        public Parameters(Environment env, ScriptService scriptService, AnalysisRegistry analysisRegistry, ThreadContext threadContext, LongSupplier relativeTimeSupplier, BiFunction<Long, Runnable, Scheduler.ScheduledCancellable> scheduler, BaseIngestService ingestService, ReleasableSkyliteClient client, Consumer<Runnable> genericExecutor) {
            this.env = env;
            this.scriptService = scriptService;
            this.threadContext = threadContext;
            this.analysisRegistry = analysisRegistry;
            this.relativeTimeSupplier = relativeTimeSupplier;
            this.scheduler = scheduler;
            this.ingestService = ingestService;
            this.client = client;
            this.genericExecutor = genericExecutor;
        }
    }
}

