/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.ingest;

import io.skylite.SkyliteException;
import io.skylite.common.collect.Tuple;
import io.skylite.common.processor.AbstractProcessor;
import io.skylite.core.action.ingest.SimulateProcessorResult;
import io.skylite.core.ingest.CompoundProcessor;
import io.skylite.core.ingest.ConditionalProcessor;
import io.skylite.core.ingest.IngestDocument;
import io.skylite.core.ingest.IngestProcessor;
import io.skylite.core.ingest.Pipeline;
import io.skylite.core.ingest.PipelineProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;

public final class TrackingResultProcessor
extends AbstractProcessor
implements IngestProcessor {
    private final IngestProcessor actualProcessor;
    private final ConditionalProcessor conditionalProcessor;
    private final List<SimulateProcessorResult> processorResultList;

    public TrackingResultProcessor(boolean ignoreFailure, IngestProcessor actualProcessor, ConditionalProcessor conditionalProcessor, List<SimulateProcessorResult> processorResultList) {
        super(actualProcessor.getTag(), actualProcessor.getDescription(), ignoreFailure);
        this.processorResultList = processorResultList;
        this.actualProcessor = actualProcessor;
        this.conditionalProcessor = conditionalProcessor;
    }

    @Override
    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        Tuple conditionalWithResult;
        if (this.conditionalProcessor != null) {
            if (!this.conditionalProcessor.evaluate(ingestDocument)) {
                Tuple conditionalWithResult2 = new Tuple((Object)this.conditionalProcessor.getCondition(), (Object)Boolean.FALSE);
                this.processorResultList.add(new SimulateProcessorResult(this.actualProcessor.getType(), this.actualProcessor.getTag(), this.actualProcessor.getDescription(), (Tuple<String, Boolean>)conditionalWithResult2));
                handler.accept(ingestDocument, null);
                return;
            }
            conditionalWithResult = new Tuple((Object)this.conditionalProcessor.getCondition(), (Object)Boolean.TRUE);
        } else {
            conditionalWithResult = null;
        }
        if (this.actualProcessor instanceof PipelineProcessor) {
            PipelineProcessor pipelineProcessor = (PipelineProcessor)this.actualProcessor;
            Pipeline pipeline = pipelineProcessor.getPipeline(ingestDocument);
            IngestDocument ingestDocumentCopy = new IngestDocument(ingestDocument);
            Pipeline pipelineToCall = pipelineProcessor.getPipeline(ingestDocument);
            if (pipelineToCall == null) {
                throw new IllegalArgumentException("Pipeline processor configured for non-existent pipeline [" + pipelineProcessor.getPipelineToCallName(ingestDocument) + "]");
            }
            ingestDocumentCopy.executePipeline(pipelineToCall, (result, e) -> {
                if (e instanceof SkyliteException && e.getCause() instanceof IllegalStateException && e.getCause().getMessage().startsWith("Cycle detected for pipeline: ")) {
                    if (this.ignoreFailure) {
                        this.processorResultList.add(new SimulateProcessorResult(pipelineProcessor.getType(), pipelineProcessor.getTag(), pipelineProcessor.getDescription(), new IngestDocument(ingestDocument), (Exception)e, (Tuple<String, Boolean>)conditionalWithResult));
                    } else {
                        this.processorResultList.add(new SimulateProcessorResult(pipelineProcessor.getType(), pipelineProcessor.getTag(), pipelineProcessor.getDescription(), (Exception)e, (Tuple<String, Boolean>)conditionalWithResult));
                    }
                    handler.accept((IngestDocument)null, (Exception)e);
                } else {
                    CompoundProcessor verbosePipelineProcessor = TrackingResultProcessor.decorate(pipeline.getCompoundProcessor(), null, this.processorResultList);
                    this.processorResultList.add(new SimulateProcessorResult(this.actualProcessor.getType(), this.actualProcessor.getTag(), this.actualProcessor.getDescription(), (Tuple<String, Boolean>)conditionalWithResult));
                    Pipeline verbosePipeline = new Pipeline(pipeline.getId(), pipeline.getDescription(), pipeline.getVersion(), verbosePipelineProcessor);
                    ingestDocument.executePipeline(verbosePipeline, handler);
                }
            });
            return;
        }
        this.actualProcessor.execute(ingestDocument, (result, e) -> {
            if (e != null) {
                if (this.ignoreFailure) {
                    this.processorResultList.add(new SimulateProcessorResult(this.actualProcessor.getType(), this.actualProcessor.getTag(), this.actualProcessor.getDescription(), new IngestDocument(ingestDocument), (Exception)e, (Tuple<String, Boolean>)conditionalWithResult));
                } else {
                    this.processorResultList.add(new SimulateProcessorResult(this.actualProcessor.getType(), this.actualProcessor.getTag(), this.actualProcessor.getDescription(), (Exception)e, (Tuple<String, Boolean>)conditionalWithResult));
                }
                handler.accept((IngestDocument)null, (Exception)e);
            } else if (result != null) {
                this.processorResultList.add(new SimulateProcessorResult(this.actualProcessor.getType(), this.actualProcessor.getTag(), this.actualProcessor.getDescription(), new IngestDocument(ingestDocument), (Tuple<String, Boolean>)conditionalWithResult));
                handler.accept((IngestDocument)result, (Exception)null);
            } else {
                this.processorResultList.add(new SimulateProcessorResult(this.actualProcessor.getType(), this.actualProcessor.getTag(), this.actualProcessor.getDescription(), (Tuple<String, Boolean>)conditionalWithResult));
                handler.accept(null, null);
            }
        });
    }

    @Override
    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getType() {
        return this.actualProcessor.getType();
    }

    public static CompoundProcessor decorate(CompoundProcessor compoundProcessor, ConditionalProcessor parentCondition, List<SimulateProcessorResult> processorResultList) {
        ArrayList<IngestProcessor> processors = new ArrayList<IngestProcessor>();
        for (IngestProcessor processor : compoundProcessor.getProcessors()) {
            ConditionalProcessor conditionalProcessor = parentCondition;
            if (processor instanceof ConditionalProcessor) {
                conditionalProcessor = (ConditionalProcessor)processor;
                processor = conditionalProcessor.getInnerProcessor();
            }
            if (processor instanceof CompoundProcessor) {
                processors.add(TrackingResultProcessor.decorate((CompoundProcessor)processor, conditionalProcessor, processorResultList));
                continue;
            }
            processors.add(new TrackingResultProcessor(compoundProcessor.isIgnoreFailure(), processor, conditionalProcessor, processorResultList));
        }
        ArrayList<IngestProcessor> onFailureProcessors = new ArrayList<IngestProcessor>(compoundProcessor.getProcessors().size());
        for (IngestProcessor processor : compoundProcessor.getOnFailureProcessors()) {
            ConditionalProcessor conditionalProcessor = null;
            if (processor instanceof ConditionalProcessor) {
                conditionalProcessor = (ConditionalProcessor)processor;
                processor = conditionalProcessor.getInnerProcessor();
            }
            if (processor instanceof CompoundProcessor) {
                onFailureProcessors.add(TrackingResultProcessor.decorate((CompoundProcessor)processor, conditionalProcessor, processorResultList));
                continue;
            }
            onFailureProcessors.add(new TrackingResultProcessor(compoundProcessor.isIgnoreFailure(), processor, conditionalProcessor, processorResultList));
        }
        return new CompoundProcessor(compoundProcessor.isIgnoreFailure(), processors, onFailureProcessors);
    }
}

