/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.jobs;

import io.skylite.ResourceAlreadyExistsException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.DocWriteResponse;
import io.skylite.core.action.admin.indices.create.CreateIndexRequest;
import io.skylite.core.action.delete.DeleteRequest;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.update.UpdateRequest;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.engine.DocumentMissingException;
import io.skylite.core.index.engine.VersionConflictEngineException;
import io.skylite.core.jobs.JobExecutionContext;
import io.skylite.core.jobs.LockModel;
import io.skylite.core.jobs.LockServiceInterface;
import io.skylite.core.jobs.ScheduledJobParameter;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LockService
implements LockServiceInterface {
    private static final Logger logger = LogManager.getLogger(LockService.class);
    public static final String LOCK_INDEX_NAME = ".opendistro-job-scheduler-lock";
    private final Client client;
    private final ClusterService clusterService;
    private Instant testInstant = null;

    public LockService(Client client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
    }

    private String lockMapping() {
        try {
            String line;
            InputStream in = LockService.class.getResourceAsStream("/mappings/lucenia_job_scheduler_lock.json");
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
            return stringBuilder.toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Lock Mapping cannot be read correctly.");
        }
    }

    public boolean lockIndexExist() {
        return this.clusterService.state().routingTable().hasIndex(LOCK_INDEX_NAME);
    }

    void createLockIndex(ActionListener<Boolean> listener) {
        try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashContext();){
            if (this.lockIndexExist()) {
                listener.onResponse((Object)true);
            } else {
                CreateIndexRequest request = new CreateIndexRequest(LOCK_INDEX_NAME).mapping(this.lockMapping(), MediaTypeRegistry.JSON);
                this.client.admin().indices().create(request, ActionListenerHelper.wrap(response -> listener.onResponse((Object)response.isAcknowledged()), exception -> {
                    if (exception instanceof ResourceAlreadyExistsException || exception.getCause() instanceof ResourceAlreadyExistsException) {
                        listener.onResponse((Object)true);
                    } else {
                        listener.onFailure(exception);
                    }
                }));
            }
        }
        catch (Exception e) {
            logger.error("exception in LockService#createLockIndex: ", (Throwable)e);
            listener.onFailure(e);
        }
    }

    @Override
    public void acquireLock(ScheduledJobParameter jobParameter, JobExecutionContext context, ActionListener<LockModel> listener) {
        String jobIndexName = context.getJobIndexName();
        String jobId = context.getJobId();
        long lockDurationSeconds = jobParameter.getLockDurationSeconds();
        this.acquireLockWithId(jobIndexName, lockDurationSeconds, jobId, listener);
    }

    @Override
    public void acquireLockWithId(String jobIndexName, Long lockDurationSeconds, String lockId, ActionListener<LockModel> listener) {
        if (lockDurationSeconds == null) {
            listener.onFailure((Exception)new IllegalArgumentException("Job LockDuration should not be null"));
        } else if (jobIndexName == null) {
            listener.onFailure((Exception)new IllegalArgumentException("Job index name should not be null"));
        } else if (lockId == null) {
            listener.onFailure((Exception)new IllegalArgumentException("Lock ID should not be null"));
        } else {
            this.createLockIndex(ActionListenerHelper.wrap(created -> {
                if (created.booleanValue()) {
                    try {
                        this.findLock(LockModel.generateLockId(jobIndexName, lockId), ActionListenerHelper.wrap(existingLock -> {
                            if (existingLock != null) {
                                if (this.isLockReleasedOrExpired((LockModel)existingLock)) {
                                    logger.debug("lock is released or expired: " + String.valueOf(existingLock));
                                    LockModel updateLock = new LockModel((LockModel)existingLock, this.getNow(), lockDurationSeconds, false);
                                    this.updateLock(updateLock, listener);
                                } else {
                                    logger.debug("Lock is NOT released or expired. " + String.valueOf(existingLock));
                                    listener.onResponse(null);
                                }
                            } else {
                                LockModel tempLock = new LockModel(jobIndexName, lockId, this.getNow(), lockDurationSeconds, false);
                                logger.debug("Lock does not exist. Creating new lock" + String.valueOf(tempLock));
                                this.createLock(tempLock, listener);
                            }
                        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
                    }
                    catch (VersionConflictEngineException e) {
                        logger.debug("could not acquire lock {}", (Object)e.getMessage());
                        listener.onResponse(null);
                    }
                } else {
                    listener.onResponse(null);
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private boolean isLockReleasedOrExpired(LockModel lock) {
        return lock.isReleased() || lock.isExpired();
    }

    private void updateLock(LockModel updateLock, ActionListener<LockModel> listener) {
        try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashContext();){
            UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(LOCK_INDEX_NAME)).id(updateLock.getLockId()).setIfSeqNo(updateLock.getSeqNo()).setIfPrimaryTerm(updateLock.getPrimaryTerm()).doc(updateLock.toXContent(MediaTypeRegistry.JSON.contentBuilder(), ToXContent.EMPTY_PARAMS)).fetchSource(true);
            this.client.update(updateRequest, ActionListenerHelper.wrap(response -> listener.onResponse((Object)new LockModel(updateLock, response.getSeqNo(), response.getPrimaryTerm())), exception -> {
                if (exception instanceof VersionConflictEngineException) {
                    logger.debug("could not acquire lock {}", (Object)exception.getMessage());
                }
                if (exception instanceof DocumentMissingException) {
                    logger.debug("Document is deleted. This happens if the job is already removed and this is the last run.{}", (Object)exception.getMessage());
                }
                if (exception instanceof IOException) {
                    logger.error("IOException occurred updating lock.", (Throwable)exception);
                }
                listener.onResponse(null);
            }));
        }
        catch (IOException e) {
            logger.error("IOException occurred updating lock.", (Throwable)e);
            listener.onResponse(null);
        }
        catch (Exception e) {
            logger.error("Exception occurred updating lock: ", (Throwable)e);
            listener.onFailure(e);
        }
    }

    private void createLock(LockModel tempLock, ActionListener<LockModel> listener) {
        try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashContext();){
            IndexRequest request = new IndexRequest(LOCK_INDEX_NAME).id(tempLock.getLockId()).source(tempLock.toXContent(MediaTypeRegistry.JSON.contentBuilder(), ToXContent.EMPTY_PARAMS)).setIfSeqNo(-2L).setIfPrimaryTerm(0L).create(true);
            this.client.index(request, ActionListenerHelper.wrap(response -> listener.onResponse((Object)new LockModel(tempLock, response.getSeqNo(), response.getPrimaryTerm())), exception -> {
                if (exception instanceof VersionConflictEngineException) {
                    logger.debug("Lock is already created. {}", (Object)exception.getMessage());
                    listener.onResponse(null);
                    return;
                }
                listener.onFailure(exception);
            }));
        }
        catch (IOException e) {
            logger.error("IOException occurred creating lock", (Throwable)e);
            listener.onFailure((Exception)e);
        }
    }

    public void findLock(String lockId, ActionListener<LockModel> listener) {
        try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashContext();){
            GetRequest getRequest = new GetRequest(LOCK_INDEX_NAME).id(lockId);
            this.client.get(getRequest, ActionListenerHelper.wrap(response -> {
                if (!response.isExists()) {
                    listener.onResponse(null);
                } else {
                    try {
                        XContentParser parser = MediaTypeRegistry.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, response.getSourceAsString());
                        parser.nextToken();
                        listener.onResponse((Object)LockModel.parse(parser, response.getSeqNo(), response.getPrimaryTerm()));
                    }
                    catch (IOException e) {
                        logger.error("IOException occurred finding lock", (Throwable)e);
                        listener.onResponse(null);
                    }
                }
            }, exception -> {
                logger.error("Exception occurred finding lock", (Throwable)exception);
                listener.onFailure(exception);
            }));
        }
        catch (Exception e) {
            logger.error("Exception occurred finding lock: ", (Throwable)e);
            listener.onFailure(e);
        }
    }

    @Override
    public void release(LockModel lock, ActionListener<Boolean> listener) {
        if (lock == null) {
            logger.debug("Lock is null. Nothing to release.");
            listener.onResponse((Object)false);
        } else {
            logger.debug("Releasing lock: " + String.valueOf(lock));
            LockModel lockToRelease = new LockModel(lock, true);
            this.updateLock(lockToRelease, ActionListenerHelper.wrap(releasedLock -> listener.onResponse((Object)(releasedLock != null ? 1 : 0)), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    @Override
    public void deleteLock(String lockId, ActionListener<Boolean> listener) {
        try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashContext();){
            DeleteRequest deleteRequest = new DeleteRequest(LOCK_INDEX_NAME).id(lockId);
            this.client.delete(deleteRequest, ActionListenerHelper.wrap(response -> listener.onResponse((Object)(response.getResult() == DocWriteResponse.Result.DELETED || response.getResult() == DocWriteResponse.Result.NOT_FOUND ? 1 : 0)), exception -> {
                if (exception instanceof IndexNotFoundException || exception.getCause() instanceof IndexNotFoundException) {
                    logger.debug("Index is not found to delete lock. {}", (Object)exception.getMessage());
                    listener.onResponse((Object)true);
                } else {
                    listener.onFailure(exception);
                }
            }));
        }
        catch (Exception e) {
            logger.error("Exception in deleting lock: ", (Throwable)e);
            listener.onFailure(e);
        }
    }

    @Override
    public void renewLock(LockModel lock, ActionListener<LockModel> listener) {
        if (lock == null) {
            logger.debug("Lock is null. Nothing to renew.");
            listener.onResponse(null);
        } else {
            logger.debug("Renewing lock: {}. The lock was acquired or renewed on: {}, and the duration was {} sec.", (Object)lock, (Object)lock.getLockTime(), (Object)lock.getLockDurationSeconds());
            LockModel lockToRenew = new LockModel(lock, this.getNow(), lock.getLockDurationSeconds(), false);
            this.updateLock(lockToRenew, ActionListenerHelper.wrap(renewedLock -> {
                logger.debug("Renewed lock: {}. It is supposed to be valid for another {} sec from {}.", renewedLock, (Object)renewedLock.getLockDurationSeconds(), (Object)renewedLock.getLockTime());
                listener.onResponse(renewedLock);
            }, exception -> {
                logger.debug("Failed to renew lock: {}.", (Object)lock);
                listener.onFailure(exception);
            }));
        }
    }

    private Instant getNow() {
        return this.testInstant != null ? this.testInstant : Instant.now();
    }

    void setTime(Instant testInstant) {
        this.testInstant = testInstant;
    }
}

