/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.lucene;

import io.skylite.Version;
import io.skylite.common.Iterables;
import io.skylite.core.lucene.Lucene;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.util.Bits;

public class XLucene {
    private XLucene() {
    }

    public static SegmentInfos readSegmentInfos(Directory directory) throws IOException {
        return SegmentInfos.readLatestCommit((Directory)directory);
    }

    public static SegmentInfos readSegmentInfos(Directory directory, Version minimumVersion) throws IOException {
        int minSupportedLuceneMajor = ((Version)minimumVersion.minimumIndexCompatibilityVersion()).luceneVersion.major;
        return SegmentInfos.readLatestCommit((Directory)directory, (int)minSupportedLuceneMajor);
    }

    public static Iterable<String> files(SegmentInfos infos) throws IOException {
        ArrayList<Collection> list = new ArrayList<Collection>();
        list.add(Collections.singleton(infos.getSegmentsFileName()));
        for (SegmentCommitInfo info : infos) {
            list.add(info.files());
        }
        return Iterables.flatten(list);
    }

    public static SegmentInfos readSegmentInfos(IndexCommit commit) throws IOException {
        String filename = IndexFileNames.fileNameFromGeneration((String)"segments", (String)"", (long)commit.getGeneration());
        return SegmentInfos.readCommit((Directory)commit.getDirectory(), (String)filename);
    }

    private static SegmentInfos readSegmentInfos(String segmentsFileName, Directory directory) throws IOException {
        return SegmentInfos.readCommit((Directory)directory, (String)segmentsFileName);
    }

    public static SegmentInfos pruneUnreferencedFiles(String segmentsFileName, Directory directory) throws IOException {
        SegmentInfos si = XLucene.readSegmentInfos(segmentsFileName, directory);
        try (Lock writeLock = directory.obtainLock("write.lock");){
            int foundSegmentFiles = 0;
            for (String file : directory.listAll()) {
                if (!file.startsWith("segments")) continue;
                ++foundSegmentFiles;
                if (file.equals(si.getSegmentsFileName())) continue;
                directory.deleteFile(file);
            }
            assert (SegmentInfos.getLastCommitSegmentsFileName((Directory)directory).equals(segmentsFileName));
            if (foundSegmentFiles == 0) {
                throw new IllegalStateException("no commit found in the directory");
            }
        }
        IndexCommit cp = XLucene.getIndexCommit(si, directory);
        IndexWriter writer = new IndexWriter(directory, new IndexWriterConfig((Analyzer)Lucene.STANDARD_ANALYZER).setSoftDeletesField("__soft_deletes").setIndexCommit(cp).setCommitOnClose(false).setMergePolicy(NoMergePolicy.INSTANCE).setOpenMode(IndexWriterConfig.OpenMode.APPEND));
        writer.close();
        return si;
    }

    public static IndexCommit getIndexCommit(SegmentInfos si, Directory directory) throws IOException {
        return new CommitPoint(si, directory);
    }

    public static void checkSegmentInfoIntegrity(final Directory directory) throws IOException {
        new SegmentInfos.FindSegmentsFile(directory){

            protected Object doBody(String segmentFileName) throws IOException {
                try (IndexInput input = directory.openInput(segmentFileName, IOContext.READONCE);){
                    CodecUtil.checksumEntireFile((IndexInput)input);
                }
                return null;
            }
        }.run();
    }

    public static boolean exists(IndexSearcher searcher, Query query) throws IOException {
        Weight weight = searcher.createWeight(searcher.rewrite(query), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        for (LeafReaderContext context : searcher.getIndexReader().leaves()) {
            Scorer scorer = weight.scorer(context);
            if (scorer == null) continue;
            Bits liveDocs = context.reader().getLiveDocs();
            DocIdSetIterator iterator = scorer.iterator();
            int doc = iterator.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (liveDocs == null || liveDocs.get(doc)) {
                    return true;
                }
                doc = iterator.nextDoc();
            }
        }
        return false;
    }

    public static boolean indexExists(Directory directory) throws IOException {
        return DirectoryReader.indexExists((Directory)directory);
    }

    public static DirectoryReader wrapAllDocsLive(DirectoryReader in) throws IOException {
        return new DirectoryReaderWithAllLiveDocs(in);
    }

    private static int popCount(Bits bits) {
        assert (bits != null);
        int onBits = 0;
        for (int i = 0; i < bits.length(); ++i) {
            if (!bits.get(i)) continue;
            ++onBits;
        }
        return onBits;
    }

    public static NumericDocValuesField newSoftDeletesField() {
        return new NumericDocValuesField("__soft_deletes", 1L);
    }

    private static final class CommitPoint
    extends IndexCommit {
        private String segmentsFileName;
        private final Collection<String> files;
        private final Directory dir;
        private final long generation;
        private final Map<String, String> userData;
        private final int segmentCount;

        private CommitPoint(SegmentInfos infos, Directory dir) throws IOException {
            this.segmentsFileName = infos.getSegmentsFileName();
            this.dir = dir;
            this.userData = infos.getUserData();
            this.files = Collections.unmodifiableCollection(infos.files(true));
            this.generation = infos.getGeneration();
            this.segmentCount = infos.size();
        }

        public String toString() {
            return "DirectoryReader.ReaderCommit(" + this.segmentsFileName + ")";
        }

        public int getSegmentCount() {
            return this.segmentCount;
        }

        public String getSegmentsFileName() {
            return this.segmentsFileName;
        }

        public Collection<String> getFileNames() {
            return this.files;
        }

        public Directory getDirectory() {
            return this.dir;
        }

        public long getGeneration() {
            return this.generation;
        }

        public boolean isDeleted() {
            return false;
        }

        public Map<String, String> getUserData() {
            return this.userData;
        }

        public void delete() {
            throw new UnsupportedOperationException("This IndexCommit does not support deletions");
        }
    }

    private static final class DirectoryReaderWithAllLiveDocs
    extends FilterDirectoryReader {
        DirectoryReaderWithAllLiveDocs(DirectoryReader in) throws IOException {
            super(in, new FilterDirectoryReader.SubReaderWrapper(){

                public LeafReader wrap(LeafReader leaf) {
                    SegmentReader segmentReader = Lucene.segmentReader(leaf);
                    Bits hardLiveDocs = segmentReader.getHardLiveDocs();
                    if (hardLiveDocs == null) {
                        return new LeafReaderWithLiveDocs(leaf, null, leaf.maxDoc());
                    }
                    int numDocs = segmentReader.maxDoc() - segmentReader.getSegmentInfo().getDelCount();
                    assert (numDocs == XLucene.popCount(hardLiveDocs)) : numDocs + " != " + XLucene.popCount(hardLiveDocs);
                    return new LeafReaderWithLiveDocs((LeafReader)segmentReader, hardLiveDocs, numDocs);
                }
            });
        }

        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
            return XLucene.wrapAllDocsLive(in);
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return null;
        }

        static final class LeafReaderWithLiveDocs
        extends FilterLeafReader {
            final Bits liveDocs;
            final int numDocs;

            LeafReaderWithLiveDocs(LeafReader in, Bits liveDocs, int numDocs) {
                super(in);
                this.liveDocs = liveDocs;
                this.numDocs = numDocs;
            }

            public Bits getLiveDocs() {
                return this.liveDocs;
            }

            public int numDocs() {
                return this.numDocs;
            }

            public IndexReader.CacheHelper getCoreCacheHelper() {
                return this.in.getCoreCacheHelper();
            }

            public IndexReader.CacheHelper getReaderCacheHelper() {
                return null;
            }
        }
    }
}

