/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.lucene.index;

import io.skylite.common.SuppressForbidden;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.lucene.index.SkyliteLeafReader;
import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;

public final class SkyliteDirectoryReader
extends FilterDirectoryReader {
    private final ShardId shardId;
    private final FilterDirectoryReader.SubReaderWrapper wrapper;

    private SkyliteDirectoryReader(DirectoryReader in, FilterDirectoryReader.SubReaderWrapper wrapper, ShardId shardId) throws IOException {
        super(in, wrapper);
        this.wrapper = wrapper;
        this.shardId = shardId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
        return new SkyliteDirectoryReader(in, this.wrapper, this.shardId);
    }

    public static SkyliteDirectoryReader wrap(DirectoryReader reader, ShardId shardId) throws IOException {
        return new SkyliteDirectoryReader(reader, new SubReaderWrapper(shardId), shardId);
    }

    @SuppressForbidden(reason="This is the only sane way to add a ReaderClosedListener")
    public static void addReaderCloseListener(DirectoryReader reader, IndexReader.ClosedListener listener) {
        SkyliteDirectoryReader skyliteDirectoryReader = SkyliteDirectoryReader.getOpenSearchDirectoryReader(reader);
        if (skyliteDirectoryReader == null) {
            throw new IllegalArgumentException("Can't install close listener reader is not an OpenSearchDirectoryReader/OpenSearchLeafReader");
        }
        IndexReader.CacheHelper cacheHelper = skyliteDirectoryReader.getReaderCacheHelper();
        if (cacheHelper == null) {
            throw new IllegalArgumentException("Reader " + String.valueOf((Object)skyliteDirectoryReader) + " does not support caching");
        }
        assert (cacheHelper.getKey() == reader.getReaderCacheHelper().getKey());
        cacheHelper.addClosedListener(listener);
    }

    public static SkyliteDirectoryReader getOpenSearchDirectoryReader(DirectoryReader reader) {
        if (reader instanceof FilterDirectoryReader) {
            if (reader instanceof SkyliteDirectoryReader) {
                return (SkyliteDirectoryReader)reader;
            }
            return SkyliteDirectoryReader.getOpenSearchDirectoryReader(((FilterDirectoryReader)reader).getDelegate());
        }
        return null;
    }

    private static final class SubReaderWrapper
    extends FilterDirectoryReader.SubReaderWrapper {
        private final ShardId shardId;

        SubReaderWrapper(ShardId shardId) {
            this.shardId = shardId;
        }

        public LeafReader wrap(LeafReader reader) {
            return new SkyliteLeafReader(reader, this.shardId);
        }
    }
}

