/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.lucene.search.function;

import io.skylite.core.ParseField;
import io.skylite.core.common.Strings;
import org.apache.lucene.search.Explanation;

public final class Functions {
    private Functions() {
    }

    public static String nameOrEmptyFunc(String functionName) {
        if (!Strings.isNullOrEmpty(functionName)) {
            return "(" + ParseField.CommonMetaFields.NAME_FIELD.getPreferredName() + ": " + functionName + ")";
        }
        return "";
    }

    public static String nameOrEmptyArg(String functionName) {
        if (!Strings.isNullOrEmpty(functionName)) {
            return ", " + ParseField.CommonMetaFields.NAME_FIELD.getPreferredName() + ": " + functionName;
        }
        return "";
    }

    public static Explanation explainWithName(Explanation explanation, String queryName) {
        if (Strings.isNullOrEmpty(queryName)) {
            return explanation;
        }
        String description = explanation.getDescription() + " " + Functions.nameOrEmptyFunc(queryName);
        if (explanation.isMatch()) {
            return Explanation.match((Number)explanation.getValue(), (String)description, (Explanation[])explanation.getDetails());
        }
        return Explanation.noMatch((String)description, (Explanation[])explanation.getDetails());
    }
}

