/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.common.Nullable;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.mapper.ValueFetcher;
import io.skylite.core.search.lookup.SourceLookup;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class ArraySourceValueFetcher
implements ValueFetcher {
    private final Set<String> sourcePaths;
    @Nullable
    private final Object nullValue;

    public ArraySourceValueFetcher(String fieldName, QueryShardContext context) {
        this(fieldName, context, null);
    }

    public ArraySourceValueFetcher(String fieldName, QueryShardContext context, Object nullValue) {
        this.sourcePaths = context.sourcePath(fieldName);
        this.nullValue = nullValue;
    }

    @Override
    public List<Object> fetchValues(SourceLookup lookup) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String path : this.sourcePaths) {
            Object sourceValue = lookup.extractValue(path, this.nullValue);
            if (sourceValue == null) {
                return List.of();
            }
            values.addAll((List)this.parseSourceValue(sourceValue));
        }
        return values;
    }

    protected abstract Object parseSourceValue(Object var1);
}

