/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.common.Booleans;
import io.skylite.common.Nullable;
import io.skylite.core.ParseField;
import io.skylite.core.index.fielddata.BaseIndexFieldData;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.IndexNumericFieldData;
import io.skylite.core.index.fielddata.plain.SortedNumericIndexFieldData;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.lucene.Lucene;
import io.skylite.core.mapper.ContentPath;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.ParseContext;
import io.skylite.core.mapper.SourceValueFetcher;
import io.skylite.core.mapper.TermBasedFieldType;
import io.skylite.core.mapper.TextSearchInfo;
import io.skylite.core.mapper.ValueFetcher;
import io.skylite.core.search.lookup.SearchLookup;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.util.XContentMapValuesUtil;
import java.io.IOException;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;

public class BooleanFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = ParseField.CoreTypes.BOOLEAN_FIELD.getPreferredName();
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n));
    private final Boolean nullValue;
    private final boolean indexed;
    private final boolean hasDocValues;
    private final boolean stored;

    private static BooleanFieldMapper toType(FieldMapper in) {
        return (BooleanFieldMapper)in;
    }

    protected BooleanFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, Lucene.KEYWORD_ANALYZER, multiFields, copyTo);
        this.nullValue = builder.nullValue.getValue();
        this.stored = builder.stored.getValue();
        this.indexed = builder.indexed.getValue();
        this.hasDocValues = builder.docValues.getValue();
    }

    @Override
    public BooleanFieldType fieldType() {
        return (BooleanFieldType)super.fieldType();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        if (!(this.indexed || this.stored || this.hasDocValues)) {
            return;
        }
        Boolean value = context.parseExternalValue(Boolean.class);
        if (value == null) {
            XContentParser.Token token = context.parser().currentToken();
            if (token == XContentParser.Token.VALUE_NULL) {
                if (this.nullValue != null) {
                    value = this.nullValue;
                }
            } else {
                value = context.parser().booleanValue();
            }
        }
        if (value == null) {
            return;
        }
        if (this.indexed) {
            context.doc().add((IndexableField)new Field(this.fieldType().name(), (CharSequence)(value != false ? "T" : "F"), (IndexableFieldType)Defaults.FIELD_TYPE));
        }
        if (this.stored) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), value != false ? "T" : "F"));
        }
        if (this.hasDocValues) {
            context.doc().add((IndexableField)new SortedNumericDocValuesField(this.fieldType().name(), value != false ? 1L : 0L));
        } else {
            context.addFieldToFieldNamesField(this.fieldType().name());
        }
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init(this);
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> docValues = FieldMapper.Parameter.docValuesParam(m -> BooleanFieldMapper.toType((FieldMapper)m).hasDocValues, true);
        private final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> BooleanFieldMapper.toType((FieldMapper)m).indexed, true);
        private final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> BooleanFieldMapper.toType((FieldMapper)m).stored, false);
        private final FieldMapper.Parameter<Boolean> nullValue = new FieldMapper.Parameter<Boolean>(ParseField.CommonFields.NULL_VALUE.getPreferredName(), false, () -> null, (n, c, o) -> o == null ? null : Boolean.valueOf(XContentMapValuesUtil.nodeBooleanValue(o)), m -> BooleanFieldMapper.toType((FieldMapper)m).nullValue).acceptsNull();
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name) {
            super(name);
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return List.of(this.meta, this.docValues, this.indexed, this.nullValue, this.stored);
        }

        @Override
        public BooleanFieldMapper build(ContentPath contentPath) {
            BooleanFieldType ft = new BooleanFieldType(this.buildFullName(contentPath), (boolean)this.indexed.getValue(), (boolean)this.stored.getValue(), (boolean)this.docValues.getValue(), this.nullValue.getValue(), this.meta.getValue());
            return new BooleanFieldMapper(this.name, (MappedFieldType)ft, this.multiFieldsBuilder.build(this, contentPath), this.copyTo.build(), this);
        }
    }

    public static final class BooleanFieldType
    extends TermBasedFieldType {
        private final Boolean nullValue;

        public BooleanFieldType(String name, boolean isSearchable, boolean isStored, boolean hasDocValues, Boolean nullValue, Map<String, String> meta) {
            super(name, isSearchable, isStored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.nullValue = nullValue;
        }

        public BooleanFieldType(String name) {
            this(name, true, false, true, false, Collections.emptyMap());
        }

        public BooleanFieldType(String name, boolean searchable) {
            this(name, searchable, false, true, false, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return CONTENT_TYPE;
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this, this.name(), context, this.nullValue){

                @Override
                protected Boolean parseSourceValue(Object value) {
                    if (value instanceof Boolean) {
                        return (Boolean)value;
                    }
                    String textValue = value.toString();
                    return Booleans.parseBoolean((char[])textValue.toCharArray(), (int)0, (int)textValue.length(), (boolean)false);
                }
            };
        }

        @Override
        public BytesRef indexedValueForSearch(Object value) {
            if (value == null) {
                return Values.FALSE;
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? Values.TRUE : Values.FALSE;
            }
            String sValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
            switch (sValue) {
                case "true": {
                    return Values.TRUE;
                }
                case "false": {
                    return Values.FALSE;
                }
            }
            throw new IllegalArgumentException("Can't parse boolean value [" + sValue + "], expected [true] or [false]");
        }

        @Override
        public Boolean valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            switch (value.toString()) {
                case "F": {
                    return false;
                }
                case "T": {
                    return true;
                }
            }
            throw new IllegalArgumentException("Expected [T] or [F] but got [" + String.valueOf(value) + "]");
        }

        @Override
        public BaseIndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedNumericIndexFieldData.Builder(this.name(), IndexNumericFieldData.NumericType.BOOLEAN);
        }

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom formats");
            }
            if (timeZone != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
            }
            return DocValueFormat.BOOLEAN;
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            this.failIfNotIndexed();
            return new TermRangeQuery(this.name(), lowerTerm == null ? null : this.indexedValueForSearch(lowerTerm), upperTerm == null ? null : this.indexedValueForSearch(upperTerm), includeLower, includeUpper);
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.freeze();
        }
    }

    public static class Values {
        public static final BytesRef TRUE = new BytesRef((CharSequence)"T");
        public static final BytesRef FALSE = new BytesRef((CharSequence)"F");
    }
}

