/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.SkyliteParseException;
import io.skylite.Version;
import io.skylite.common.Nullable;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.LocaleUtils;
import io.skylite.core.ParseField;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.common.time.DateFormatter;
import io.skylite.core.common.time.DateFormatters;
import io.skylite.core.common.time.DateMathParser;
import io.skylite.core.common.time.DateResolution;
import io.skylite.core.geo.ShapeRelation;
import io.skylite.core.index.fielddata.BaseIndexFieldData;
import io.skylite.core.index.fielddata.DocValueDateFormatters;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.IndexNumericFieldData;
import io.skylite.core.index.fielddata.plain.SortedNumericIndexFieldData;
import io.skylite.core.index.query.DateRangeIncludingNowQuery;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.lucene.BytesRefs;
import io.skylite.core.mapper.BaseMappedFieldType;
import io.skylite.core.mapper.ContentPath;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.ParseContext;
import io.skylite.core.mapper.SourceValueFetcher;
import io.skylite.core.mapper.TextSearchInfo;
import io.skylite.core.mapper.ValueFetcher;
import io.skylite.core.search.lookup.SearchLookup;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.IndexSortSortedNumericDocValuesRangeQuery;
import org.apache.lucene.search.Query;

public final class DateFieldMapper
extends FieldMapper {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(DateFieldMapper.class);
    public static final FieldMapper.TypeParser MILLIS_PARSER = new FieldMapper.TypeParser((n, c) -> {
        boolean ignoreMalformedByDefault = (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings());
        return new Builder((String)n, DateResolution.MILLISECONDS, c.getDateFormatter(), ignoreMalformedByDefault, c.indexVersionCreated());
    });
    public static final FieldMapper.TypeParser NANOS_PARSER = new FieldMapper.TypeParser((n, c) -> {
        boolean ignoreMalformedByDefault = (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings());
        return new Builder((String)n, DateResolution.NANOSECONDS, c.getDateFormatter(), ignoreMalformedByDefault, c.indexVersionCreated());
    });
    private final boolean store;
    private final boolean indexed;
    private final boolean hasDocValues;
    private final Locale locale;
    private final String format;
    private final String printFormat;
    private final boolean ignoreMalformed;
    private final Long nullValue;
    private final String nullValueAsString;
    private final DateResolution resolution;
    private final boolean ignoreMalformedByDefault;
    private final Version indexCreatedVersion;

    private static DateFieldMapper toType(FieldMapper in) {
        return (DateFieldMapper)in;
    }

    private DateFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Long nullValue, DateResolution resolution, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.store = builder.store.getValue();
        this.indexed = builder.index.getValue();
        this.hasDocValues = builder.docValues.getValue();
        this.locale = builder.locale.getValue();
        this.format = builder.format.getValue();
        this.printFormat = builder.printFormat.getValue();
        this.ignoreMalformed = builder.ignoreMalformed.getValue();
        this.nullValueAsString = builder.nullValue.getValue();
        this.nullValue = nullValue;
        this.resolution = resolution;
        this.ignoreMalformedByDefault = builder.ignoreMalformed.getDefaultValue();
        this.indexCreatedVersion = builder.indexCreatedVersion;
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.resolution, null, this.ignoreMalformedByDefault, this.indexCreatedVersion).init(this);
    }

    @Override
    public DateFieldType fieldType() {
        return (DateFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType().resolution.type();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        long timestamp;
        Object dateAsObject;
        Object dateAsString = context.externalValueSet() ? ((dateAsObject = context.externalValue()) == null ? null : dateAsObject.toString()) : context.parser().textOrNull();
        if (dateAsString == null) {
            if (this.nullValue == null) {
                return;
            }
            timestamp = this.nullValue;
        } else {
            try {
                timestamp = this.fieldType().parse((String)dateAsString);
            }
            catch (SkyliteParseException | ArithmeticException | IllegalArgumentException | DateTimeException e) {
                if (this.ignoreMalformed) {
                    context.addIgnoredField(this.mappedFieldType.name());
                    return;
                }
                throw e;
            }
        }
        if (this.indexed && this.hasDocValues) {
            context.doc().add((IndexableField)new LongField(this.fieldType().name(), timestamp, Field.Store.NO));
        } else if (this.hasDocValues) {
            context.doc().add((IndexableField)new SortedNumericDocValuesField(this.fieldType().name(), timestamp));
        } else if (this.indexed) {
            context.doc().add((IndexableField)new LongPoint(this.fieldType().name(), new long[]{timestamp}));
        }
        if (this.store) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), timestamp));
        }
        if (!this.hasDocValues && (this.store || this.indexed)) {
            context.addFieldToFieldNamesField(this.fieldType().name());
        }
    }

    public boolean getIgnoreMalformed() {
        return this.ignoreMalformed;
    }

    public Long getNullValue() {
        return this.nullValue;
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> index = FieldMapper.Parameter.indexParam(m -> DateFieldMapper.toType((FieldMapper)m).indexed, true);
        private final FieldMapper.Parameter<Boolean> docValues = FieldMapper.Parameter.docValuesParam(m -> DateFieldMapper.toType((FieldMapper)m).hasDocValues, true);
        private final FieldMapper.Parameter<Boolean> store = FieldMapper.Parameter.storeParam(m -> DateFieldMapper.toType((FieldMapper)m).store, false);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final FieldMapper.Parameter<String> format = FieldMapper.Parameter.stringParam("format", false, m -> DateFieldMapper.toType((FieldMapper)m).format, DateFormatter.getDefaultDateTimeFormatter().pattern());
        private final FieldMapper.Parameter<String> printFormat = FieldMapper.Parameter.stringParam("print_format", false, m -> DateFieldMapper.toType((FieldMapper)m).printFormat, DateFormatter.getDefaultDateTimeFormatter().printPattern()).acceptsNull();
        private final FieldMapper.Parameter<Locale> locale = new FieldMapper.Parameter<Locale>("locale", false, () -> Locale.ROOT, (n, c, o) -> LocaleUtils.parse((String)o.toString()), m -> DateFieldMapper.toType((FieldMapper)m).locale);
        private final FieldMapper.Parameter<String> nullValue = FieldMapper.Parameter.stringParam(ParseField.CommonFields.NULL_VALUE.getPreferredName(), false, m -> DateFieldMapper.toType((FieldMapper)m).nullValueAsString, null).acceptsNull();
        private final FieldMapper.Parameter<Boolean> ignoreMalformed;
        private final DateResolution resolution;
        private final Version indexCreatedVersion;

        public Builder(String name, DateResolution resolution, DateFormatter dateFormatter, boolean ignoreMalformedByDefault, Version indexCreatedVersion) {
            super(name);
            this.resolution = resolution;
            this.indexCreatedVersion = indexCreatedVersion;
            this.ignoreMalformed = FieldMapper.Parameter.boolParam("ignore_malformed", true, m -> DateFieldMapper.toType((FieldMapper)m).ignoreMalformed, ignoreMalformedByDefault);
            if (dateFormatter != null) {
                this.format.setValue(dateFormatter.pattern());
                this.printFormat.setValue(dateFormatter.printPattern());
                this.locale.setValue(dateFormatter.locale());
            }
        }

        private DateFormatter buildFormatter() {
            try {
                if (this.format.isConfigured() && !this.printFormat.isConfigured()) {
                    return DateFormatter.forPattern(this.format.getValue(), null, !this.format.isConfigured(), this.indexCreatedVersion).withLocale(this.locale.getValue());
                }
                return DateFormatter.forPattern(this.format.getValue(), this.printFormat.getValue(), !this.format.isConfigured(), this.indexCreatedVersion).withLocale(this.locale.getValue());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Error parsing [format] on field [" + this.name() + "]: " + e.getMessage(), e);
            }
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return List.of(this.index, this.docValues, this.store, this.format, this.printFormat, this.locale, this.nullValue, this.ignoreMalformed, this.meta);
        }

        private Long parseNullValue(DateFieldType fieldType) {
            if (this.nullValue.getValue() == null) {
                return null;
            }
            try {
                return fieldType.parse(this.nullValue.getValue());
            }
            catch (Exception e) {
                DEPRECATION_LOGGER.deprecate("date_mapper_null_field", "Error parsing [" + this.nullValue.getValue() + "] as date in [null_value] on field [" + this.name() + "]); [null_value] will be ignored", new Object[0]);
                return null;
            }
        }

        @Override
        public DateFieldMapper build(ContentPath contentPath) {
            DateFieldType ft = new DateFieldType(this.buildFullName(contentPath), this.index.getValue(), this.store.getValue(), this.docValues.getValue(), this.buildFormatter(), this.resolution, this.nullValue.getValue(), this.meta.getValue());
            Long nullTimestamp = this.parseNullValue(ft);
            return new DateFieldMapper(this.name, ft, this.multiFieldsBuilder.build(this, contentPath), this.copyTo.build(), nullTimestamp, this.resolution, this);
        }
    }

    public static final class DateFieldType
    extends MappedFieldType {
        protected final DateFormatter dateTimeFormatter;
        protected final DateMathParser dateMathParser;
        protected final DateResolution resolution;
        protected final String nullValue;

        public DateFieldType(String name, boolean isSearchable, boolean isStored, boolean hasDocValues, DateFormatter dateTimeFormatter, DateResolution resolution, String nullValue, Map<String, String> meta) {
            super(name, isSearchable, isStored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, meta);
            this.dateTimeFormatter = dateTimeFormatter;
            this.dateMathParser = dateTimeFormatter.toDateMathParser();
            this.resolution = resolution;
            this.nullValue = nullValue;
        }

        public DateFieldType(String name) {
            this(name, true, false, true, DateFormatter.getDefaultDateTimeFormatter(), DateResolution.MILLISECONDS, null, Collections.emptyMap());
        }

        public DateFieldType(String name, DateFormatter dateFormatter) {
            this(name, true, false, true, dateFormatter, DateResolution.MILLISECONDS, null, Collections.emptyMap());
        }

        public DateFieldType(String name, DateResolution resolution) {
            this(name, true, false, true, DateFormatter.getDefaultDateTimeFormatter(), resolution, null, Collections.emptyMap());
        }

        public DateFieldType(String name, DateResolution resolution, DateFormatter dateFormatter) {
            this(name, true, false, true, dateFormatter, resolution, null, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return this.resolution.type();
        }

        public DateFormatter dateTimeFormatter() {
            return this.dateTimeFormatter;
        }

        public DateResolution resolution() {
            return this.resolution;
        }

        protected DateMathParser dateMathParser() {
            return this.dateMathParser;
        }

        public long parse(String value) {
            return this.resolution.convert(DateFormatters.from(this.dateTimeFormatter().parse(value), this.dateTimeFormatter().locale()).toInstant());
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            DateFormatter defaultFormatter = this.dateTimeFormatter();
            final DateFormatter formatter = format != null ? DateFormatter.forPattern(format).withLocale(defaultFormatter.locale()) : defaultFormatter;
            return new SourceValueFetcher(this.name(), context, this.nullValue){

                @Override
                public String parseSourceValue(Object value) {
                    String date = value.toString();
                    long timestamp = this.parse(date);
                    ZonedDateTime dateTime = this.resolution().toInstant(timestamp).atZone(ZoneOffset.UTC);
                    return formatter.format(dateTime);
                }
            };
        }

        @Override
        public Query termQuery(Object value, @Nullable QueryShardContext context) {
            return this.rangeQuery(value, value, true, true, ShapeRelation.INTERSECTS, null, null, context);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, @Nullable ZoneId timeZone, @Nullable DateMathParser forcedDateParser, QueryShardContext context) {
            this.failIfNotIndexed();
            if (relation == ShapeRelation.DISJOINT) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support DISJOINT ranges");
            }
            DateMathParser parser = forcedDateParser == null ? this.dateMathParser : forcedDateParser;
            return DateFieldType.dateRangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, timeZone, parser, context, this.resolution, (l, u) -> {
                Query query = LongPoint.newRangeQuery((String)this.name(), (long)l, (long)u);
                if (this.hasDocValues()) {
                    Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery((String)this.name(), (long)l, (long)u);
                    query = new IndexOrDocValuesQuery(query, dvQuery);
                    if (context.indexSortedOnField(this.name())) {
                        query = new IndexSortSortedNumericDocValuesRangeQuery(this.name(), l.longValue(), u.longValue(), query);
                    }
                }
                return query;
            });
        }

        public static Query dateRangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable ZoneId timeZone, DateMathParser parser, QueryShardContext context, DateResolution resolution, BiFunction<Long, Long, Query> builder) {
            return DateFieldType.handleNow(context, nowSupplier -> {
                long u;
                long l;
                if (lowerTerm == null) {
                    l = Long.MIN_VALUE;
                } else {
                    l = DateFieldType.parseToLong(lowerTerm, !includeLower, timeZone, parser, nowSupplier, resolution);
                    if (!includeLower) {
                        ++l;
                    }
                }
                if (upperTerm == null) {
                    u = Long.MAX_VALUE;
                } else {
                    u = DateFieldType.parseToLong(upperTerm, includeUpper, timeZone, parser, nowSupplier, resolution);
                    if (!includeUpper) {
                        --u;
                    }
                }
                return (Query)builder.apply(l, u);
            });
        }

        public static Query handleNow(QueryShardContext context, Function<LongSupplier, Query> builder) {
            boolean[] nowUsed = new boolean[1];
            LongSupplier nowSupplier = () -> {
                nowUsed[0] = true;
                return context.nowInMillis();
            };
            Query query = builder.apply(nowSupplier);
            return nowUsed[0] ? new DateRangeIncludingNowQuery(query) : query;
        }

        public long parseToLong(Object value, boolean roundUp, @Nullable ZoneId zone, DateMathParser dateParser, LongSupplier now) {
            dateParser = dateParser == null ? this.dateMathParser() : dateParser;
            return DateFieldType.parseToLong(value, roundUp, zone, dateParser, now, this.resolution);
        }

        public static long parseToLong(Object value, boolean roundUp, @Nullable ZoneId zone, DateMathParser dateParser, LongSupplier now, DateResolution resolution) {
            return resolution.convert(dateParser.parse(BytesRefs.toString(value), now, roundUp, zone));
        }

        @Override
        public Query distanceFeatureQuery(Object origin, String pivot, float boost, QueryShardContext context) {
            long originLong = this.parseToLong(origin, true, null, null, context::nowInMillis);
            TimeValue pivotTime = TimeValue.parseTimeValue((String)pivot, (String)"distance_feature.pivot");
            return LongField.newDistanceFeatureQuery((String)this.name(), (float)boost, (long)originLong, (long)this.resolution.convert(pivotTime));
        }

        @Override
        public BaseMappedFieldType.Relation isFieldWithinQuery(IndexReader reader, Object from, Object to, boolean includeLower, boolean includeUpper, ZoneId timeZone, DateMathParser dateParser, QueryRewriteContext context) throws IOException {
            if (dateParser == null) {
                dateParser = this.dateMathParser;
            }
            long fromInclusive = Long.MIN_VALUE;
            if (from != null) {
                fromInclusive = DateFieldType.parseToLong(from, !includeLower, timeZone, dateParser, context::nowInMillis, this.resolution);
                if (!includeLower) {
                    if (fromInclusive == Long.MAX_VALUE) {
                        return BaseMappedFieldType.Relation.DISJOINT;
                    }
                    ++fromInclusive;
                }
            }
            long toInclusive = Long.MAX_VALUE;
            if (to != null) {
                toInclusive = DateFieldType.parseToLong(to, includeUpper, timeZone, dateParser, context::nowInMillis, this.resolution);
                if (!includeUpper) {
                    if (toInclusive == Long.MIN_VALUE) {
                        return BaseMappedFieldType.Relation.DISJOINT;
                    }
                    --toInclusive;
                }
            }
            if (PointValues.size((IndexReader)reader, (String)this.name()) == 0L) {
                return BaseMappedFieldType.Relation.DISJOINT;
            }
            long minValue = LongPoint.decodeDimension((byte[])PointValues.getMinPackedValue((IndexReader)reader, (String)this.name()), (int)0);
            long maxValue = LongPoint.decodeDimension((byte[])PointValues.getMaxPackedValue((IndexReader)reader, (String)this.name()), (int)0);
            if (minValue >= fromInclusive && maxValue <= toInclusive) {
                return BaseMappedFieldType.Relation.WITHIN;
            }
            if (maxValue < fromInclusive || minValue > toInclusive) {
                return BaseMappedFieldType.Relation.DISJOINT;
            }
            return BaseMappedFieldType.Relation.INTERSECTS;
        }

        @Override
        public Function<byte[], Number> pointReaderIfPossible() {
            if (this.isSearchable()) {
                return this.resolution()::parsePointAsMillis;
            }
            return null;
        }

        @Override
        public BaseIndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedNumericIndexFieldData.Builder(this.name(), this.numericTypeFromResolution());
        }

        private IndexNumericFieldData.NumericType numericTypeFromResolution() {
            if (this.resolution == DateResolution.MILLISECONDS) {
                return IndexNumericFieldData.NumericType.DATE;
            }
            if (this.resolution == DateResolution.NANOSECONDS) {
                return IndexNumericFieldData.NumericType.DATE_NANOSECONDS;
            }
            throw new RuntimeException("unable to return fielddata type; unknown date resolution [" + String.valueOf((Object)this.resolution) + "]");
        }

        @Override
        public Object valueForDisplay(Object value) {
            Long val = (Long)value;
            if (val == null) {
                return null;
            }
            return this.dateTimeFormatter().format(this.resolution.toInstant(val).atZone(ZoneOffset.UTC));
        }

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
            DateFormatter dateTimeFormatter = this.dateTimeFormatter;
            if (format != null) {
                dateTimeFormatter = DateFormatter.forPattern(format).withLocale(dateTimeFormatter.locale());
            }
            if (timeZone == null) {
                timeZone = ZoneOffset.UTC;
            }
            return new DocValueDateFormatters.DateTime(dateTimeFormatter, timeZone, DateResolution.MILLISECONDS);
        }
    }
}

