/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.SkyliteParseException;
import io.skylite.Version;
import io.skylite.common.Explicit;
import io.skylite.common.collect.Tuple;
import io.skylite.core.ParseField;
import io.skylite.core.common.Strings;
import io.skylite.core.common.time.DateFormatter;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.analysis.IndexAnalyzers;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.mapper.ContentPath;
import io.skylite.core.mapper.DynamicRuntimeFieldsBuilder;
import io.skylite.core.mapper.FieldAliasMapper;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.IdFieldMapper;
import io.skylite.core.mapper.LuceneDocument;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.MappedParsedDocument;
import io.skylite.core.mapper.Mapper;
import io.skylite.core.mapper.MapperParsingException;
import io.skylite.core.mapper.Mapping;
import io.skylite.core.mapper.MappingLookup;
import io.skylite.core.mapper.MappingParserContext;
import io.skylite.core.mapper.MetadataFieldMapper;
import io.skylite.core.mapper.NestedObjectMapper;
import io.skylite.core.mapper.NestedPathFieldMapper;
import io.skylite.core.mapper.ObjectMapper;
import io.skylite.core.mapper.ParseContext;
import io.skylite.core.mapper.RootObjectMapper;
import io.skylite.core.mapper.RuntimeFieldType;
import io.skylite.core.mapper.SourceToParse;
import io.skylite.core.mapper.StrictDynamicMappingException;
import io.skylite.core.mapper.TextSearchInfo;
import io.skylite.core.mapper.ValueFetcher;
import io.skylite.core.search.lookup.SearchLookup;
import io.skylite.core.settings.MapperSettings;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.Query;

public final class DocumentParser {
    private final NamedXContentRegistry xContentRegistry;
    private final Function<DateFormatter, MappingParserContext> dateParserContext;
    private final DynamicRuntimeFieldsBuilder dynamicRuntimeFieldsBuilder;
    private final IndexSettings indexSettings;
    private final IndexAnalyzers indexAnalyzers;

    DocumentParser(NamedXContentRegistry xContentRegistry, Function<DateFormatter, MappingParserContext> dateParserContext, DynamicRuntimeFieldsBuilder dynamicRuntimeFieldsBuilder, IndexSettings indexSettings, IndexAnalyzers indexAnalyzers) {
        this.xContentRegistry = xContentRegistry;
        this.dateParserContext = dateParserContext;
        this.dynamicRuntimeFieldsBuilder = dynamicRuntimeFieldsBuilder;
        this.indexSettings = indexSettings;
        this.indexAnalyzers = indexAnalyzers;
    }

    public MappedParsedDocument parseDocument(SourceToParse source, MappingLookup mappingLookup) throws MapperParsingException {
        InternalParseContext context;
        MetadataFieldMapper[] metadataFieldsMappers = mappingLookup.getMapping().getSortedMetadataMappers();
        MediaType mediaType = source.getMediaType();
        try (XContentParser parser = XContentHelper.createParser(this.xContentRegistry, LoggingDeprecationHandler.INSTANCE, source.source(), mediaType);){
            context = new InternalParseContext(mappingLookup, this.indexSettings, this.indexAnalyzers, this.dateParserContext, this.dynamicRuntimeFieldsBuilder, source, parser);
            DocumentParser.validateStart(parser);
            DocumentParser.internalParseDocument(mappingLookup.getMapping().getRoot(), metadataFieldsMappers, context, parser);
            DocumentParser.validateEnd(parser);
        }
        catch (Exception e) {
            throw DocumentParser.wrapInMapperParsingException(source, e);
        }
        String remainingPath = context.path().pathAsText("");
        if (!remainingPath.isEmpty()) {
            throw new IllegalStateException("found leftover path elements: " + remainingPath);
        }
        return new MappedParsedDocument(context.version(), context.seqID(), context.sourceToParse().id(), source.routing(), context.reorderParentAndGetDocs(), context.sourceToParse().source(), context.sourceToParse().getMediaType(), DocumentParser.createDynamicUpdate(mappingLookup, context.getDynamicMappers(), context.getDynamicRuntimeFields()));
    }

    private static boolean containsDisabledObjectMapper(ObjectMapper objectMapper, String[] subfields) {
        Mapper mapper;
        for (int i = 0; i < subfields.length - 1 && (mapper = objectMapper.getMapper(subfields[i])) instanceof ObjectMapper; ++i) {
            objectMapper = (ObjectMapper)mapper;
            if (objectMapper.isEnabled()) continue;
            return true;
        }
        return false;
    }

    private static void internalParseDocument(RootObjectMapper root, MetadataFieldMapper[] metadataFieldsMappers, ParseContext context, XContentParser parser) throws IOException {
        boolean emptyDoc = DocumentParser.isEmptyDoc(root, parser);
        for (MetadataFieldMapper metadataMapper : metadataFieldsMappers) {
            metadataMapper.preParse(context);
        }
        if (!root.isEnabled()) {
            parser.skipChildren();
        } else if (!emptyDoc) {
            DocumentParser.parseObjectOrNested(context, root);
        }
        for (MetadataFieldMapper metadataMapper : metadataFieldsMappers) {
            metadataMapper.postParse(context);
        }
    }

    private static void validateStart(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new MapperParsingException("Malformed content, must start with an object");
        }
    }

    private static void validateEnd(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        if (token != null) {
            throw new IllegalArgumentException("Malformed content, found extra data after parsing: " + String.valueOf((Object)token));
        }
    }

    private static boolean isEmptyDoc(RootObjectMapper root, XContentParser parser) throws IOException {
        if (root.isEnabled()) {
            XContentParser.Token token = parser.nextToken();
            if (token == XContentParser.Token.END_OBJECT) {
                return true;
            }
            if (token != XContentParser.Token.FIELD_NAME) {
                throw new MapperParsingException("Malformed content, after first object, either the type field or the actual properties should exist");
            }
        }
        return false;
    }

    private static MapperParsingException wrapInMapperParsingException(SourceToParse source, Exception e) {
        if (e instanceof MapperParsingException) {
            return (MapperParsingException)e;
        }
        if (source.source() != null && source.source().length() == 0) {
            return new MapperParsingException("failed to parse, document is empty");
        }
        return new MapperParsingException("failed to parse", e);
    }

    private static String[] splitAndValidatePath(String fullFieldPath) {
        if (fullFieldPath.contains(".")) {
            String[] parts;
            for (String part : parts = fullFieldPath.split("\\.")) {
                if (Strings.hasText(part)) continue;
                if (!Strings.isEmpty(part)) {
                    throw new IllegalArgumentException("object field cannot contain only whitespace: ['" + fullFieldPath + "']");
                }
                throw new IllegalArgumentException("object field starting or ending with a [.] makes object resolution ambiguous: [" + fullFieldPath + "]");
            }
            return parts;
        }
        if (Strings.isEmpty(fullFieldPath)) {
            throw new IllegalArgumentException("field name cannot be an empty string");
        }
        return new String[]{fullFieldPath};
    }

    static Mapping createDynamicUpdate(MappingLookup mappingLookup, List<Mapper> dynamicMappers, List<RuntimeFieldType> dynamicRuntimeFields) {
        if (dynamicMappers.isEmpty() && dynamicRuntimeFields.isEmpty()) {
            return null;
        }
        RootObjectMapper root = !dynamicMappers.isEmpty() ? DocumentParser.createDynamicUpdate(mappingLookup.getMapping().getRoot(), mappingLookup, dynamicMappers) : mappingLookup.getMapping().getRoot().copyAndReset();
        root.addRuntimeFields(dynamicRuntimeFields);
        return mappingLookup.getMapping().mappingUpdate(root);
    }

    private static RootObjectMapper createDynamicUpdate(RootObjectMapper root, MappingLookup mappingLookup, List<Mapper> dynamicMappers) {
        dynamicMappers.sort(Comparator.comparing(Mapper::name));
        Iterator<Mapper> dynamicMapperItr = dynamicMappers.iterator();
        ArrayList<ObjectMapper> parentMappers = new ArrayList<ObjectMapper>();
        Mapper firstUpdate = dynamicMapperItr.next();
        parentMappers.add(DocumentParser.createUpdate(root, DocumentParser.splitAndValidatePath(firstUpdate.name()), 0, firstUpdate));
        Mapper previousMapper = null;
        while (dynamicMapperItr.hasNext()) {
            Mapper newMapper = dynamicMapperItr.next();
            if (previousMapper != null && newMapper.name().equals(previousMapper.name())) {
                newMapper.merge(previousMapper);
                continue;
            }
            previousMapper = newMapper;
            String[] nameParts = DocumentParser.splitAndValidatePath(newMapper.name());
            int i = DocumentParser.removeUncommonMappers(parentMappers, nameParts);
            if ((i = DocumentParser.expandCommonMappers(parentMappers, nameParts, i)) < nameParts.length - 1) {
                newMapper = DocumentParser.createExistingMapperUpdate(parentMappers, nameParts, i, mappingLookup, newMapper);
            }
            if (newMapper instanceof ObjectMapper) {
                parentMappers.add((ObjectMapper)newMapper);
                continue;
            }
            DocumentParser.addToLastMapper(parentMappers, newMapper, true);
        }
        DocumentParser.popMappers(parentMappers, 1, true);
        assert (parentMappers.size() == 1);
        return (RootObjectMapper)parentMappers.get(0);
    }

    private static void popMappers(List<ObjectMapper> parentMappers, int keepBefore, boolean merge) {
        assert (keepBefore >= 1);
        for (int i = parentMappers.size() - 1; i >= keepBefore; --i) {
            DocumentParser.addToLastMapper(parentMappers, parentMappers.remove(i), merge);
        }
    }

    private static void addToLastMapper(List<ObjectMapper> parentMappers, Mapper mapper, boolean merge) {
        assert (parentMappers.size() >= 1);
        int lastIndex = parentMappers.size() - 1;
        ObjectMapper withNewMapper = parentMappers.get(lastIndex).mappingUpdate(mapper);
        if (merge) {
            withNewMapper = parentMappers.get(lastIndex).merge(withNewMapper);
        }
        parentMappers.set(lastIndex, withNewMapper);
    }

    private static int removeUncommonMappers(List<ObjectMapper> parentMappers, String[] nameParts) {
        int keepBefore;
        for (keepBefore = 1; keepBefore < parentMappers.size() && parentMappers.get(keepBefore).simpleName().equals(nameParts[keepBefore - 1]); ++keepBefore) {
        }
        DocumentParser.popMappers(parentMappers, keepBefore, true);
        return keepBefore - 1;
    }

    private static int expandCommonMappers(List<ObjectMapper> parentMappers, String[] nameParts, int i) {
        ObjectMapper last = parentMappers.get(parentMappers.size() - 1);
        while (i < nameParts.length - 1 && last.getMapper(nameParts[i]) != null) {
            Mapper newLast = last.getMapper(nameParts[i]);
            assert (newLast instanceof ObjectMapper);
            last = (ObjectMapper)newLast;
            parentMappers.add(last);
            ++i;
        }
        return i;
    }

    private static ObjectMapper createExistingMapperUpdate(List<ObjectMapper> parentMappers, String[] nameParts, int i, MappingLookup mappingLookup, Mapper newMapper) {
        Object updateParentName = nameParts[i];
        ObjectMapper lastParent = parentMappers.get(parentMappers.size() - 1);
        if (parentMappers.size() > 1) {
            updateParentName = lastParent.name() + "." + nameParts[i];
        }
        ObjectMapper updateParent = mappingLookup.objectMappers().get(updateParentName);
        assert (updateParent != null) : (String)updateParentName + " doesn't exist";
        return DocumentParser.createUpdate(updateParent, nameParts, i + 1, newMapper);
    }

    private static ObjectMapper createUpdate(ObjectMapper parent, String[] nameParts, int i, Mapper mapper) {
        ArrayList<ObjectMapper> parentMappers = new ArrayList<ObjectMapper>();
        ObjectMapper previousIntermediate = parent;
        while (i < nameParts.length - 1) {
            Mapper intermediate = previousIntermediate.getMapper(nameParts[i]);
            assert (intermediate != null) : "Field " + previousIntermediate.name() + " does not have a subfield " + nameParts[i];
            assert (intermediate instanceof ObjectMapper);
            parentMappers.add((ObjectMapper)intermediate);
            previousIntermediate = (ObjectMapper)intermediate;
            ++i;
        }
        if (!parentMappers.isEmpty()) {
            DocumentParser.addToLastMapper(parentMappers, mapper, false);
            DocumentParser.popMappers(parentMappers, 1, false);
            mapper = (Mapper)parentMappers.get(0);
        }
        return parent.mappingUpdate(mapper);
    }

    static void parseObjectOrNested(ParseContext context, ObjectMapper mapper) throws IOException {
        if (!mapper.isEnabled()) {
            context.parser().skipChildren();
            return;
        }
        XContentParser parser = context.parser();
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_NULL) {
            return;
        }
        String currentFieldName = parser.currentName();
        if (token.isValue()) {
            throw new MapperParsingException("object mapping for [" + mapper.name() + "] tried to parse field [" + currentFieldName + "] as object, but found a concrete value");
        }
        if (mapper.isNested()) {
            context = DocumentParser.nestedContext(context, (NestedObjectMapper)mapper);
        }
        if (token == XContentParser.Token.END_OBJECT) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.START_OBJECT) {
            token = parser.nextToken();
        }
        DocumentParser.innerParseObject(context, mapper, parser, currentFieldName, token);
        if (mapper.isNested()) {
            context.getMetadataMapper(ParseField.CommonMetaFields.FIELD_NAMES_FIELD.getPreferredName()).postParse(context);
            DocumentParser.nested(context, (NestedObjectMapper)mapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void innerParseObject(ParseContext context, ObjectMapper mapper, XContentParser parser, String currentFieldName, XContentParser.Token token) throws IOException {
        try {
            assert (token == XContentParser.Token.FIELD_NAME || token == XContentParser.Token.END_OBJECT);
            String[] paths = null;
            context.incrementFieldCurrentDepth();
            context.checkFieldDepthLimit();
            while (token != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    paths = DocumentParser.splitAndValidatePath(currentFieldName);
                    if (DocumentParser.containsDisabledObjectMapper(mapper, paths)) {
                        parser.nextToken();
                        parser.skipChildren();
                    }
                } else if (token == XContentParser.Token.START_OBJECT) {
                    DocumentParser.parseObject(context, mapper, currentFieldName, paths);
                } else if (token == XContentParser.Token.START_ARRAY) {
                    DocumentParser.parseArray(context, mapper, currentFieldName, paths);
                } else if (token == XContentParser.Token.VALUE_NULL) {
                    DocumentParser.parseNullValue(context, mapper, currentFieldName, paths);
                } else {
                    if (token == null) {
                        throw new MapperParsingException("object mapping for [" + mapper.name() + "] tried to parse field [" + currentFieldName + "] as object, but got EOF, has a concrete value been provided to it?");
                    }
                    if (token.isValue()) {
                        DocumentParser.parseValue(context, mapper, currentFieldName, token, paths);
                    }
                }
                token = parser.nextToken();
            }
        }
        finally {
            context.decrementFieldCurrentDepth();
        }
    }

    private static void nested(ParseContext context, NestedObjectMapper nested) {
        LuceneDocument nestedDoc = context.doc();
        LuceneDocument parentDoc = nestedDoc.getParent();
        Version indexVersion = context.indexSettings().getIndexVersionCreated();
        if (nested.isIncludeInParent()) {
            DocumentParser.addFields(indexVersion, nestedDoc, parentDoc);
        }
        if (nested.isIncludeInRoot()) {
            LuceneDocument rootDoc = context.rootDoc();
            if (!nested.isIncludeInParent() || parentDoc != rootDoc) {
                DocumentParser.addFields(indexVersion, nestedDoc, rootDoc);
            }
        }
    }

    private static void addFields(Version indexVersion, LuceneDocument nestedDoc, LuceneDocument rootDoc) {
        String nestedPathFieldName = NestedPathFieldMapper.name(indexVersion);
        for (IndexableField field : nestedDoc.getFields()) {
            if (field.name().equals(nestedPathFieldName)) continue;
            rootDoc.add(field);
        }
    }

    private static ParseContext nestedContext(ParseContext context, NestedObjectMapper mapper) {
        LuceneDocument nestedDoc = (context = context.createNestedContext(mapper.fullPath())).doc();
        LuceneDocument parentDoc = nestedDoc.getParent();
        IndexableField idField = parentDoc.getField(ParseField.CommonMetaFields.ID_FIELD.getPreferredName());
        if (idField == null) {
            throw new IllegalStateException("The root document of a nested document should have an _id field");
        }
        nestedDoc.add((IndexableField)new Field(ParseField.CommonMetaFields.ID_FIELD.getPreferredName(), idField.binaryValue(), (IndexableFieldType)IdFieldMapper.Defaults.NESTED_FIELD_TYPE));
        nestedDoc.add((IndexableField)NestedPathFieldMapper.field(context.indexSettings().getIndexVersionCreated(), mapper.nestedTypePath()));
        return context;
    }

    static void parseObjectOrField(ParseContext context, Mapper mapper) throws IOException {
        if (mapper instanceof ObjectMapper) {
            DocumentParser.parseObjectOrNested(context, (ObjectMapper)mapper);
        } else if (mapper instanceof FieldMapper) {
            FieldMapper fieldMapper = (FieldMapper)mapper;
            fieldMapper.parse(context);
            DocumentParser.parseCopyFields(context, fieldMapper.copyTo().copyToFields());
        } else {
            if (mapper instanceof FieldAliasMapper) {
                throw new IllegalArgumentException("Cannot write to a field alias [" + mapper.name() + "].");
            }
            throw new IllegalStateException("The provided mapper [" + mapper.name() + "] has an unrecognized type [" + mapper.getClass().getSimpleName() + "].");
        }
    }

    private static void parseObject(ParseContext context, ObjectMapper mapper, String currentFieldName, String[] paths) throws IOException {
        assert (currentFieldName != null);
        Mapper objectMapper = DocumentParser.getMapper(context, mapper, currentFieldName, paths);
        if (objectMapper != null) {
            context.path().add(currentFieldName);
            DocumentParser.parseObjectOrField(context, objectMapper);
            context.path().remove();
        } else {
            currentFieldName = paths[paths.length - 1];
            Tuple<Integer, ObjectMapper> parentMapperTuple = DocumentParser.getDynamicParentMapper(context, paths, mapper);
            ObjectMapper parentMapper = (ObjectMapper)parentMapperTuple.v2();
            ObjectMapper.Dynamic dynamic = DocumentParser.dynamicOrDefault(parentMapper, context);
            if (dynamic == ObjectMapper.Dynamic.STRICT) {
                throw new StrictDynamicMappingException(mapper.fullPath(), currentFieldName);
            }
            if (dynamic == ObjectMapper.Dynamic.FALSE) {
                context.parser().skipChildren();
            } else {
                Mapper dynamicObjectMapper;
                if (dynamic == ObjectMapper.Dynamic.RUNTIME) {
                    dynamicObjectMapper = new NoOpObjectMapper(currentFieldName, context.path().pathAsText(currentFieldName));
                } else {
                    dynamicObjectMapper = dynamic.getDynamicFieldsBuilder().createDynamicObjectMapper(context, currentFieldName);
                    context.addDynamicMapper(dynamicObjectMapper);
                }
                context.path().add(currentFieldName);
                DocumentParser.parseObjectOrField(context, dynamicObjectMapper);
                context.path().remove();
            }
            for (int i = 0; i < (Integer)parentMapperTuple.v1(); ++i) {
                context.path().remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseArray(ParseContext context, ObjectMapper parentMapper, String lastFieldName, String[] paths) throws IOException {
        try {
            String arrayFieldName = lastFieldName;
            context.incrementFieldArrayDepth();
            context.checkFieldArrayDepthLimit();
            Mapper mapper = DocumentParser.getMapper(context, parentMapper, lastFieldName, paths);
            if (mapper != null) {
                if (DocumentParser.parsesArrayValue(mapper)) {
                    DocumentParser.parseObjectOrField(context, mapper);
                } else {
                    DocumentParser.parseNonDynamicArray(context, parentMapper, lastFieldName, arrayFieldName);
                }
            } else {
                lastFieldName = arrayFieldName = paths[paths.length - 1];
                Tuple<Integer, ObjectMapper> parentMapperTuple = DocumentParser.getDynamicParentMapper(context, paths, parentMapper);
                ObjectMapper.Dynamic dynamic = DocumentParser.dynamicOrDefault(parentMapper = (ObjectMapper)parentMapperTuple.v2(), context);
                if (dynamic == ObjectMapper.Dynamic.STRICT) {
                    throw new StrictDynamicMappingException(parentMapper.fullPath(), arrayFieldName);
                }
                if (dynamic == ObjectMapper.Dynamic.FALSE) {
                    DocumentParser.parseNonDynamicArray(context, parentMapper, lastFieldName, arrayFieldName);
                } else {
                    Mapper objectMapperFromTemplate = dynamic.getDynamicFieldsBuilder().createObjectMapperFromTemplate(context, arrayFieldName);
                    if (objectMapperFromTemplate == null) {
                        DocumentParser.parseNonDynamicArray(context, parentMapper, lastFieldName, arrayFieldName);
                    } else if (DocumentParser.parsesArrayValue(objectMapperFromTemplate)) {
                        context.addDynamicMapper(objectMapperFromTemplate);
                        context.path().add(arrayFieldName);
                        DocumentParser.parseObjectOrField(context, objectMapperFromTemplate);
                        context.path().remove();
                    } else {
                        DocumentParser.parseNonDynamicArray(context, parentMapper, lastFieldName, arrayFieldName);
                    }
                }
                for (int i = 0; i < (Integer)parentMapperTuple.v1(); ++i) {
                    context.path().remove();
                }
            }
        }
        finally {
            context.decrementFieldArrayDepth();
        }
    }

    private static boolean parsesArrayValue(Mapper mapper) {
        return mapper instanceof FieldMapper && ((FieldMapper)mapper).parsesArrayValue();
    }

    private static void parseNonDynamicArray(ParseContext context, ObjectMapper mapper, String lastFieldName, String arrayFieldName) throws IOException {
        XContentParser.Token token;
        XContentParser parser = context.parser();
        String[] paths = DocumentParser.splitAndValidatePath(lastFieldName);
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (token == XContentParser.Token.START_OBJECT) {
                DocumentParser.parseObject(context, mapper, lastFieldName, paths);
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                DocumentParser.parseArray(context, mapper, lastFieldName, paths);
                continue;
            }
            if (token == XContentParser.Token.VALUE_NULL) {
                DocumentParser.parseNullValue(context, mapper, lastFieldName, paths);
                continue;
            }
            if (token == null) {
                throw new MapperParsingException("object mapping for [" + mapper.name() + "] with array for [" + arrayFieldName + "] tried to parse as array, but got EOF, is there a mismatch in types for the same field?");
            }
            assert (token.isValue());
            DocumentParser.parseValue(context, mapper, lastFieldName, token, paths);
        }
    }

    private static void parseValue(ParseContext context, ObjectMapper parentMapper, String currentFieldName, XContentParser.Token token, String[] paths) throws IOException {
        if (currentFieldName == null) {
            throw new MapperParsingException("object mapping [" + parentMapper.name() + "] trying to serialize a value with no field associated with it, current value [" + context.parser().textOrNull() + "]");
        }
        Mapper mapper = DocumentParser.getMapper(context, parentMapper, currentFieldName, paths);
        if (mapper != null) {
            DocumentParser.parseObjectOrField(context, mapper);
        } else {
            currentFieldName = paths[paths.length - 1];
            Tuple<Integer, ObjectMapper> parentMapperTuple = DocumentParser.getDynamicParentMapper(context, paths, parentMapper);
            parentMapper = (ObjectMapper)parentMapperTuple.v2();
            DocumentParser.parseDynamicValue(context, parentMapper, currentFieldName, token);
            for (int i = 0; i < (Integer)parentMapperTuple.v1(); ++i) {
                context.path().remove();
            }
        }
    }

    private static void parseNullValue(ParseContext context, ObjectMapper parentMapper, String lastFieldName, String[] paths) throws IOException {
        Mapper mapper = DocumentParser.getMapper(context, parentMapper, lastFieldName, paths);
        if (mapper != null) {
            DocumentParser.parseObjectOrField(context, mapper);
        } else if (parentMapper.dynamic() == ObjectMapper.Dynamic.STRICT) {
            throw new StrictDynamicMappingException(parentMapper.fullPath(), lastFieldName);
        }
    }

    private static void parseDynamicValue(ParseContext context, ObjectMapper parentMapper, String currentFieldName, XContentParser.Token token) throws IOException {
        ObjectMapper.Dynamic dynamic = DocumentParser.dynamicOrDefault(parentMapper, context);
        if (dynamic == ObjectMapper.Dynamic.STRICT) {
            throw new StrictDynamicMappingException(parentMapper.fullPath(), currentFieldName);
        }
        if (dynamic == ObjectMapper.Dynamic.FALSE) {
            return;
        }
        dynamic.getDynamicFieldsBuilder().createDynamicFieldFromValue(context, token, currentFieldName);
    }

    private static void parseCopyFields(ParseContext context, List<String> copyToFields) throws IOException {
        if (!context.isWithinCopyTo() && !copyToFields.isEmpty()) {
            context = context.createCopyToContext();
            for (String field : copyToFields) {
                LuceneDocument targetDoc = null;
                for (LuceneDocument doc = context.doc(); doc != null; doc = doc.getParent()) {
                    if (!field.startsWith(doc.getPrefix())) continue;
                    targetDoc = doc;
                    break;
                }
                assert (targetDoc != null);
                ParseContext copyToContext = targetDoc == context.doc() ? context : context.switchDoc(targetDoc);
                DocumentParser.parseCopy(field, copyToContext);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseCopy(String field, ParseContext context) throws IOException {
        Mapper mapper = context.mappingLookup().getMapper(field);
        if (mapper != null) {
            if (mapper instanceof FieldMapper) {
                ((FieldMapper)mapper).parse(context);
                return;
            }
            if (!(mapper instanceof FieldAliasMapper)) throw new IllegalStateException("The provided mapper [" + mapper.name() + "] has an unrecognized type [" + mapper.getClass().getSimpleName() + "].");
            throw new IllegalArgumentException("Cannot copy to a field alias [" + mapper.name() + "].");
        }
        context = context.overridePath(new ContentPath(0));
        String[] paths = DocumentParser.splitAndValidatePath(field);
        String fieldName = paths[paths.length - 1];
        Tuple<Integer, ObjectMapper> parentMapperTuple = DocumentParser.getDynamicParentMapper(context, paths, null);
        ObjectMapper objectMapper = (ObjectMapper)parentMapperTuple.v2();
        DocumentParser.parseDynamicValue(context, objectMapper, fieldName, context.parser().currentToken());
        int i = 0;
        while (i < (Integer)parentMapperTuple.v1()) {
            context.path().remove();
            ++i;
        }
    }

    private static Tuple<Integer, ObjectMapper> getDynamicParentMapper(ParseContext context, String[] paths, ObjectMapper currentParent) {
        ObjectMapper mapper = currentParent == null ? context.root() : currentParent;
        int pathsAdded = 0;
        ObjectMapper parent = mapper;
        for (int i = 0; i < paths.length - 1; ++i) {
            String name = paths[i];
            String currentPath = context.path().pathAsText(name);
            Mapper existingFieldMapper = context.mappingLookup().getMapper(currentPath);
            if (existingFieldMapper != null) {
                throw new MapperParsingException("Could not dynamically add mapping for field [{}]. Existing mapping for [{}] must be of type object but found [{}].", null, String.join((CharSequence)".", paths), currentPath, existingFieldMapper.typeName());
            }
            mapper = context.mappingLookup().objectMappers().get(currentPath);
            if (mapper == null) {
                ObjectMapper.Dynamic dynamic = DocumentParser.dynamicOrDefault(parent, context);
                if (dynamic == ObjectMapper.Dynamic.STRICT) {
                    throw new StrictDynamicMappingException(parent.fullPath(), name);
                }
                if (dynamic == ObjectMapper.Dynamic.FALSE) {
                    return new Tuple((Object)pathsAdded, (Object)parent);
                }
                if (dynamic == ObjectMapper.Dynamic.RUNTIME) {
                    mapper = new NoOpObjectMapper(name, currentPath);
                } else {
                    mapper = (ObjectMapper)dynamic.getDynamicFieldsBuilder().createDynamicObjectMapper(context, name);
                    if (mapper.isNested()) {
                        throw new MapperParsingException("It is forbidden to create dynamic nested objects ([" + context.path().pathAsText(paths[i]) + "]) through `copy_to` or dots in field names");
                    }
                    context.addDynamicMapper(mapper);
                }
            }
            context.path().add(paths[i]);
            ++pathsAdded;
            parent = mapper;
        }
        return new Tuple((Object)pathsAdded, (Object)mapper);
    }

    private static ObjectMapper.Dynamic dynamicOrDefault(ObjectMapper parentMapper, ParseContext context) {
        int lastDotNdx;
        ObjectMapper.Dynamic dynamic = parentMapper.dynamic();
        while (dynamic == null && (lastDotNdx = parentMapper.name().lastIndexOf(46)) != -1) {
            String parentName = parentMapper.name().substring(0, lastDotNdx);
            parentMapper = context.mappingLookup().objectMappers().get(parentName);
            if (parentMapper == null && (parentMapper = context.getObjectMapper(parentName)) == null) break;
            dynamic = parentMapper.dynamic();
        }
        if (dynamic == null) {
            return context.root().dynamic() == null ? ObjectMapper.Dynamic.TRUE : context.root().dynamic();
        }
        return dynamic;
    }

    private static Mapper getMapper(ParseContext context, ObjectMapper objectMapper, String fieldName, String[] subfields) {
        String fieldPath = context.path().pathAsText(fieldName);
        Mapper mapper = context.getMetadataMapper(fieldPath);
        if (mapper != null) {
            return mapper;
        }
        for (int i = 0; i < subfields.length - 1; ++i) {
            mapper = objectMapper.getMapper(subfields[i]);
            if (!(mapper instanceof ObjectMapper)) {
                return null;
            }
            objectMapper = (ObjectMapper)mapper;
            if (!objectMapper.isNested()) continue;
            throw new MapperParsingException("Cannot add a value for field [" + fieldName + "] since one of the intermediate objects is mapped as a nested object: [" + mapper.name() + "]");
        }
        String leafName = subfields[subfields.length - 1];
        mapper = objectMapper.getMapper(leafName);
        if (mapper != null) {
            return mapper;
        }
        RuntimeFieldType runtimeFieldType = context.mappingLookup().getMapping().getRoot().getRuntimeFieldType(fieldPath);
        if (runtimeFieldType != null) {
            return new NoOpFieldMapper(leafName, runtimeFieldType);
        }
        return null;
    }

    public static class InternalParseContext
    extends ParseContext {
        private final ContentPath path = new ContentPath(0);
        private final XContentParser parser;
        private final LuceneDocument document;
        private final List<LuceneDocument> documents = new ArrayList<LuceneDocument>();
        private final long maxAllowedNumNestedDocs;
        private long numNestedDocs;
        private boolean docsReversed = false;
        private long currentFieldDepth;
        private final long maxAllowedFieldDepth;
        private long currentArrayDepth;
        private final long maxAllowedArrayDepth;

        public InternalParseContext(MappingLookup mappingLookup, IndexSettings indexSettings, IndexAnalyzers indexAnalyzers, Function<DateFormatter, MappingParserContext> parserContextFunction, DynamicRuntimeFieldsBuilder dynamicRuntimeFieldsBuilder, SourceToParse source, XContentParser parser) {
            super(mappingLookup, indexSettings, indexAnalyzers, parserContextFunction, source, dynamicRuntimeFieldsBuilder);
            this.parser = parser;
            this.document = new LuceneDocument();
            this.documents.add(this.document);
            this.maxAllowedNumNestedDocs = this.indexSettings().getMappingNestedDocsLimit();
            this.numNestedDocs = 0L;
            this.currentFieldDepth = 0L;
            this.currentArrayDepth = 0L;
            this.maxAllowedFieldDepth = this.indexSettings().getMappingDepthLimit();
            this.maxAllowedArrayDepth = this.indexSettings().getMappingDepthLimit();
        }

        @Override
        public ContentPath path() {
            return this.path;
        }

        @Override
        public XContentParser parser() {
            return this.parser;
        }

        @Override
        public LuceneDocument rootDoc() {
            return this.documents.get(0);
        }

        @Override
        public LuceneDocument doc() {
            return this.document;
        }

        @Override
        protected void addDoc(LuceneDocument doc) {
            ++this.numNestedDocs;
            if (this.numNestedDocs > this.maxAllowedNumNestedDocs) {
                throw new MapperParsingException("The number of nested documents has exceeded the allowed limit of [" + this.maxAllowedNumNestedDocs + "]. This limit can be set by changing the [" + MapperSettings.INDEX_MAPPING_NESTED_DOCS_LIMIT_SETTING.getKey() + "] index level setting.");
            }
            this.documents.add(doc);
        }

        @Override
        public DynamicRuntimeFieldsBuilder getDynamicRuntimeFieldsBuilder() {
            return this.dynamicRuntimeFieldsBuilder;
        }

        @Override
        public Iterable<LuceneDocument> nonRootDocuments() {
            if (this.docsReversed) {
                throw new IllegalStateException("documents are already reversed");
            }
            return this.documents.subList(1, this.documents.size());
        }

        @Override
        public void incrementFieldCurrentDepth() {
            ++this.currentFieldDepth;
        }

        @Override
        public void decrementFieldCurrentDepth() {
            if (this.currentFieldDepth > 0L) {
                --this.currentFieldDepth;
            }
        }

        @Override
        public void checkFieldDepthLimit() {
            if (this.currentFieldDepth > this.maxAllowedFieldDepth) {
                this.currentFieldDepth = 0L;
                throw new SkyliteParseException("The depth of the field has exceeded the allowed limit of [" + this.maxAllowedFieldDepth + "]. This limit can be set by changing the [" + MapperSettings.INDEX_MAPPING_DEPTH_LIMIT_SETTING.getKey() + "] index level setting.", new Object[0]);
            }
        }

        @Override
        public void incrementFieldArrayDepth() {
            ++this.currentArrayDepth;
        }

        @Override
        public void decrementFieldArrayDepth() {
            if (this.currentArrayDepth > 0L) {
                --this.currentArrayDepth;
            }
        }

        @Override
        public void checkFieldArrayDepthLimit() {
            if (this.currentArrayDepth > this.maxAllowedArrayDepth) {
                this.currentArrayDepth = 0L;
                throw new SkyliteParseException("The depth of the nested array field has exceeded the allowed limit of [" + this.maxAllowedArrayDepth + "]. This limit can be set by changing the [" + MapperSettings.INDEX_MAPPING_DEPTH_LIMIT_SETTING.getKey() + "] index level setting.", new Object[0]);
            }
        }

        private List<LuceneDocument> reorderParentAndGetDocs() {
            if (this.documents.size() > 1 && !this.docsReversed) {
                this.docsReversed = true;
                ArrayList<LuceneDocument> newDocs = new ArrayList<LuceneDocument>(this.documents.size());
                LinkedList<LuceneDocument> parents = new LinkedList<LuceneDocument>();
                for (LuceneDocument doc : this.documents) {
                    while (parents.peek() != doc.getParent()) {
                        newDocs.add((LuceneDocument)parents.poll());
                    }
                    parents.add(0, doc);
                }
                newDocs.addAll(parents);
                this.documents.clear();
                this.documents.addAll(newDocs);
            }
            return this.documents;
        }
    }

    private static class NoOpObjectMapper
    extends ObjectMapper {
        NoOpObjectMapper(String name, String fullPath) {
            super(name, fullPath, (Explicit<Boolean>)new Explicit((Object)true, false), ObjectMapper.Dynamic.RUNTIME, Collections.emptyMap());
        }
    }

    private static class NoOpFieldMapper
    extends FieldMapper {
        NoOpFieldMapper(String simpleName, RuntimeFieldType runtimeField) {
            super(simpleName, new MappedFieldType(runtimeField.name(), false, false, false, TextSearchInfo.NONE, Collections.emptyMap()){

                @Override
                public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public String typeName() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Query termQuery(Object value, QueryShardContext context) {
                    throw new UnsupportedOperationException();
                }
            }, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
        }

        @Override
        protected void parseCreateField(ParseContext context) throws IOException {
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String typeName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MappedFieldType fieldType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FieldMapper.MultiFields multiFields() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Mapper> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void doValidate(MappingLookup mappers) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void checkIncomingMergeType(FieldMapper mergeWith) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FieldMapper.Builder getMergeBuilder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected String contentType() {
            throw new UnsupportedOperationException();
        }
    }
}

