/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.common.CheckedBiConsumer;
import io.skylite.common.CheckedRunnable;
import io.skylite.core.common.time.DateFormatter;
import io.skylite.core.common.time.DateResolution;
import io.skylite.core.mapper.BinaryFieldMapper;
import io.skylite.core.mapper.BooleanFieldMapper;
import io.skylite.core.mapper.DateFieldMapper;
import io.skylite.core.mapper.DocumentParser;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.KeywordFieldMapper;
import io.skylite.core.mapper.Mapper;
import io.skylite.core.mapper.MapperParsingException;
import io.skylite.core.mapper.MappingParserContext;
import io.skylite.core.mapper.NumberFieldMapper;
import io.skylite.core.mapper.ObjectMapper;
import io.skylite.core.mapper.ParseContext;
import io.skylite.core.mapper.RuntimeFieldType;
import io.skylite.core.mapper.TextFieldMapper;
import io.skylite.core.mapper.dynamic.DynamicTemplate;
import io.skylite.core.mapper.dynamic.XContentFieldType;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;

public class DynamicFieldsBuilder {
    private static final Concrete CONCRETE = new Concrete((CheckedBiConsumer<ParseContext, Mapper, IOException>)((CheckedBiConsumer)DocumentParser::parseObjectOrField));
    static final DynamicFieldsBuilder DYNAMIC_TRUE = new DynamicFieldsBuilder(CONCRETE);
    static final DynamicFieldsBuilder DYNAMIC_RUNTIME = new DynamicFieldsBuilder(new Runtime());
    private final Strategy strategy;

    DynamicFieldsBuilder(Strategy strategy) {
        this.strategy = strategy;
    }

    void createDynamicFieldFromValue(ParseContext context, XContentParser.Token token, String name) throws IOException {
        switch (token) {
            case VALUE_STRING: {
                this.handleStringValue(context, name);
                break;
            }
            case VALUE_NUMBER: {
                this.handleNumberValue(context, name);
                break;
            }
            case VALUE_BOOLEAN: {
                DynamicFieldsBuilder.createDynamicField(context, name, XContentFieldType.BOOLEAN, (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.strategy.newDynamicBooleanField(context, name)));
                break;
            }
            case VALUE_EMBEDDED_OBJECT: {
                DynamicFieldsBuilder.createDynamicField(context, name, XContentFieldType.BINARY, (CheckedRunnable<IOException>)((CheckedRunnable)() -> CONCRETE.newDynamicBinaryField(context, name)));
                break;
            }
            default: {
                this.createDynamicStringFieldFromTemplate(context, name);
            }
        }
    }

    private void handleStringValue(ParseContext context, String name) throws IOException {
        String text = context.parser().text();
        boolean parseableAsLong = this.isParsableAsLong(text);
        boolean parseableAsDouble = this.isParsableAsDouble(text);
        if (parseableAsLong && context.root().numericDetection()) {
            DynamicFieldsBuilder.createDynamicField(context, name, XContentFieldType.LONG, (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.strategy.newDynamicLongField(context, name)));
        } else if (parseableAsDouble && context.root().numericDetection()) {
            DynamicFieldsBuilder.createDynamicField(context, name, XContentFieldType.DOUBLE, (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.strategy.newDynamicDoubleField(context, name)));
        } else if (parseableAsLong || parseableAsDouble || !context.root().dateDetection() || !this.parseDateIfValid(context, name, text)) {
            DynamicFieldsBuilder.createDynamicField(context, name, XContentFieldType.STRING, (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.strategy.newDynamicStringField(context, name)));
        }
    }

    private void handleNumberValue(ParseContext context, String name) throws IOException {
        XContentParser.NumberType numberType = context.parser().numberType();
        switch (numberType) {
            case INT: 
            case LONG: 
            case BIG_INTEGER: {
                DynamicFieldsBuilder.createDynamicField(context, name, XContentFieldType.LONG, (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.strategy.newDynamicLongField(context, name)));
                break;
            }
            case FLOAT: 
            case DOUBLE: 
            case BIG_DECIMAL: {
                DynamicFieldsBuilder.createDynamicField(context, name, XContentFieldType.DOUBLE, (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.strategy.newDynamicDoubleField(context, name)));
                break;
            }
            default: {
                throw new IllegalStateException("Unable to parse number of type [" + String.valueOf((Object)numberType) + "]");
            }
        }
    }

    private boolean parseDateIfValid(ParseContext context, String name, String text) throws IOException {
        for (DateFormatter dateFormatter : context.root().dynamicDateTimeFormatters()) {
            try {
                dateFormatter.parse(text);
                Mapper.Builder templateBuilder = DynamicFieldsBuilder.findTemplateBuilder(context, name, XContentFieldType.DATE, dateFormatter);
                if (templateBuilder == null) {
                    DynamicFieldsBuilder.createDynamicField(context, name, XContentFieldType.DATE, (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.strategy.newDynamicDateField(context, name, dateFormatter)));
                } else {
                    CONCRETE.createDynamicField(templateBuilder, context);
                }
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    private boolean isParsableAsLong(String value) {
        try {
            Long.parseLong(value);
            return true;
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }

    private boolean isParsableAsDouble(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }

    Mapper createDynamicObjectMapper(ParseContext context, String name) {
        Mapper.Builder templateBuilder = DynamicFieldsBuilder.findTemplateBuilder(context, name, XContentFieldType.OBJECT, null);
        return templateBuilder == null ? new ObjectMapper.Builder(name).enabled(true).build(context.path()) : templateBuilder.build(context.path());
    }

    Mapper createObjectMapperFromTemplate(ParseContext context, String name) {
        Mapper.Builder templateBuilder = DynamicFieldsBuilder.findTemplateBuilder(context, name, XContentFieldType.OBJECT, null);
        return templateBuilder == null ? null : templateBuilder.build(context.path());
    }

    void createDynamicStringFieldFromTemplate(ParseContext context, String name) throws IOException {
        DynamicFieldsBuilder.createDynamicField(context, name, XContentFieldType.STRING, (CheckedRunnable<IOException>)((CheckedRunnable)() -> {}));
    }

    private static void createDynamicField(ParseContext context, String name, XContentFieldType matchType, CheckedRunnable<IOException> strategy) throws IOException {
        Mapper.Builder templateBuilder = DynamicFieldsBuilder.findTemplateBuilder(context, name, matchType, null);
        if (templateBuilder == null) {
            strategy.run();
        } else {
            CONCRETE.createDynamicField(templateBuilder, context);
        }
    }

    private static Mapper.Builder findTemplateBuilder(ParseContext context, String name, XContentFieldType matchType, DateFormatter dateFormatter) {
        String mappingType;
        DynamicTemplate dynamicTemplate = context.root().findTemplate(context.path(), name, matchType);
        if (dynamicTemplate == null) {
            return null;
        }
        String dynamicType = matchType.getDefaultMappingType();
        MappingParserContext parserContext = context.dynamicTemplateParserContext(dateFormatter);
        Mapper.TypeParser typeParser = parserContext.typeParser(mappingType = dynamicTemplate.mappingType(dynamicType));
        if (typeParser == null) {
            throw new MapperParsingException("failed to find type parsed [" + mappingType + "] for [" + name + "]");
        }
        return typeParser.parse(name, dynamicTemplate.mappingForName(name, dynamicType), parserContext);
    }

    static interface Strategy {
        public void newDynamicStringField(ParseContext var1, String var2) throws IOException;

        public void newDynamicLongField(ParseContext var1, String var2) throws IOException;

        public void newDynamicDoubleField(ParseContext var1, String var2) throws IOException;

        public void newDynamicBooleanField(ParseContext var1, String var2) throws IOException;

        public void newDynamicDateField(ParseContext var1, String var2, DateFormatter var3) throws IOException;
    }

    private static final class Concrete
    implements Strategy {
        private final CheckedBiConsumer<ParseContext, Mapper, IOException> parseField;

        Concrete(CheckedBiConsumer<ParseContext, Mapper, IOException> parseField) {
            this.parseField = parseField;
        }

        void createDynamicField(Mapper.Builder builder, ParseContext context) throws IOException {
            Mapper mapper = builder.build(context.path());
            context.addDynamicMapper(mapper);
            this.parseField.accept((Object)context, (Object)mapper);
        }

        @Override
        public void newDynamicStringField(ParseContext context, String name) throws IOException {
            this.createDynamicField(new TextFieldMapper.Builder(name, context.indexAnalyzers()).addMultiField(new KeywordFieldMapper.Builder("keyword").ignoreAbove(256)), context);
        }

        @Override
        public void newDynamicLongField(ParseContext context, String name) throws IOException {
            this.createDynamicField(new NumberFieldMapper.Builder(name, NumberFieldMapper.NumberType.LONG, context.indexSettings().getSettings()), context);
        }

        @Override
        public void newDynamicDoubleField(ParseContext context, String name) throws IOException {
            this.createDynamicField(new NumberFieldMapper.Builder(name, NumberFieldMapper.NumberType.FLOAT, context.indexSettings().getSettings()), context);
        }

        @Override
        public void newDynamicBooleanField(ParseContext context, String name) throws IOException {
            this.createDynamicField(new BooleanFieldMapper.Builder(name), context);
        }

        @Override
        public void newDynamicDateField(ParseContext context, String name, DateFormatter dateTimeFormatter) throws IOException {
            this.createDynamicField(new DateFieldMapper.Builder(name, DateResolution.MILLISECONDS, dateTimeFormatter, FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings().getSettings()), context.indexSettings().getIndexVersionCreated()), context);
        }

        void newDynamicBinaryField(ParseContext context, String name) throws IOException {
            this.createDynamicField(new BinaryFieldMapper.Builder(name), context);
        }
    }

    private static final class Runtime
    implements Strategy {
        private Runtime() {
        }

        @Override
        public void newDynamicStringField(ParseContext context, String name) {
            String fullName = context.path().pathAsText(name);
            RuntimeFieldType runtimeFieldType = context.getDynamicRuntimeFieldsBuilder().newDynamicStringField(fullName);
            context.addDynamicRuntimeField(runtimeFieldType);
        }

        @Override
        public void newDynamicLongField(ParseContext context, String name) {
            String fullName = context.path().pathAsText(name);
            RuntimeFieldType runtimeFieldType = context.getDynamicRuntimeFieldsBuilder().newDynamicLongField(fullName);
            context.addDynamicRuntimeField(runtimeFieldType);
        }

        @Override
        public void newDynamicDoubleField(ParseContext context, String name) {
            String fullName = context.path().pathAsText(name);
            RuntimeFieldType runtimeFieldType = context.getDynamicRuntimeFieldsBuilder().newDynamicDoubleField(fullName);
            context.addDynamicRuntimeField(runtimeFieldType);
        }

        @Override
        public void newDynamicBooleanField(ParseContext context, String name) {
            String fullName = context.path().pathAsText(name);
            RuntimeFieldType runtimeFieldType = context.getDynamicRuntimeFieldsBuilder().newDynamicBooleanField(fullName);
            context.addDynamicRuntimeField(runtimeFieldType);
        }

        @Override
        public void newDynamicDateField(ParseContext context, String name, DateFormatter dateFormatter) {
            String fullName = context.path().pathAsText(name);
            RuntimeFieldType runtimeFieldType = context.getDynamicRuntimeFieldsBuilder().newDynamicDateField(fullName, dateFormatter);
            context.addDynamicRuntimeField(runtimeFieldType);
        }
    }
}

