/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.OpenSearchVersion;
import io.skylite.Version;
import io.skylite.common.Explicit;
import io.skylite.core.ParseField;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.mapper.ContentPath;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.MapperParsingException;
import io.skylite.core.mapper.MetadataFieldMapper;
import io.skylite.core.mapper.ParseContext;
import io.skylite.core.mapper.TermBasedFieldType;
import io.skylite.core.mapper.TextSearchInfo;
import io.skylite.core.mapper.ValueFetcher;
import io.skylite.core.search.lookup.SearchLookup;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.Query;

public class FieldNamesFieldMapper
extends MetadataFieldMapper {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(FieldNamesFieldMapper.class);
    public static final String NAME = ParseField.CommonMetaFields.FIELD_NAMES_FIELD.getPreferredName();
    public static final String CONTENT_TYPE = "_field_names";
    public static final String ENABLED_DEPRECATION_MESSAGE = "Disabling _field_names is not necessary because it no longer carries a large index overhead. Support for the `enabled` setting will be removed in a future major version. Please remove it from your mappings and templates.";
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.ConfigurableTypeParser(c -> new FieldNamesFieldMapper(Defaults.ENABLED, c.indexVersionCreated(), new FieldNamesFieldType((Boolean)Defaults.ENABLED.value())), c -> new Builder(c.indexVersionCreated()));
    private final Explicit<Boolean> enabled;
    private final Version indexVersionCreated;

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.indexVersionCreated).init(this);
    }

    private static FieldNamesFieldMapper toType(FieldMapper in) {
        return (FieldNamesFieldMapper)in;
    }

    private FieldNamesFieldMapper(Explicit<Boolean> enabled, Version indexVersionCreated, FieldNamesFieldType mappedFieldType) {
        super(mappedFieldType);
        this.enabled = enabled;
        this.indexVersionCreated = indexVersionCreated;
    }

    @Override
    public FieldNamesFieldType fieldType() {
        return (FieldNamesFieldType)super.fieldType();
    }

    static Iterable<String> extractFieldNames(final String fullPath) {
        return () -> new Iterator<String>(){
            int endIndex = this.nextEndIndex(0);

            private int nextEndIndex(int index) {
                while (index < fullPath.length() && fullPath.charAt(index) != '.') {
                    ++index;
                }
                return index;
            }

            @Override
            public boolean hasNext() {
                return this.endIndex <= fullPath.length();
            }

            @Override
            public String next() {
                String result = fullPath.substring(0, this.endIndex);
                this.endIndex = this.nextEndIndex(this.endIndex + 1);
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        if (!((Boolean)this.enabled.value()).booleanValue()) {
            return;
        }
        for (String field : context.getFieldsInFieldNamesField()) {
            assert (FieldNamesFieldMapper.noDocValues(field, context)) : "Field " + field + " should not have docvalues";
            for (String extractedFieldName : FieldNamesFieldMapper.extractFieldNames(field)) {
                context.doc().add((IndexableField)new Field(NAME, (CharSequence)extractedFieldName, (IndexableFieldType)Defaults.FIELD_TYPE));
            }
        }
    }

    private static boolean noDocValues(String field, ParseContext context) {
        MappedFieldType ft = context.mappingLookup().getFieldType(field);
        return ft == null || !ft.hasDocValues();
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    static class Builder
    extends MetadataFieldMapper.Builder {
        private final FieldMapper.Parameter<Explicit<Boolean>> enabled = MetadataFieldMapper.updateableBoolParam("enabled", m -> FieldNamesFieldMapper.toType((FieldMapper)m).enabled, (Boolean)Defaults.ENABLED.value());
        private final Version indexVersionCreated;

        Builder(Version indexVersionCreated) {
            super(Defaults.NAME);
            this.indexVersionCreated = indexVersionCreated;
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Collections.singletonList(this.enabled);
        }

        @Override
        public FieldNamesFieldMapper build(ContentPath contentPath) {
            if (this.enabled.getValue().explicit()) {
                if (this.indexVersionCreated.onOrAfter(OpenSearchVersion.V_3_0_0)) {
                    throw new MapperParsingException("The `enabled` setting for the `_field_names` field has been deprecated and removed. Please remove it from your mappings and templates.");
                }
                deprecationLogger.deprecate("field_names_enabled_parameter", FieldNamesFieldMapper.ENABLED_DEPRECATION_MESSAGE, new Object[0]);
            }
            FieldNamesFieldType fieldNamesFieldType = new FieldNamesFieldType((Boolean)this.enabled.getValue().value());
            return new FieldNamesFieldMapper(this.enabled.getValue(), this.indexVersionCreated, fieldNamesFieldType);
        }
    }

    public static final class FieldNamesFieldType
    extends TermBasedFieldType {
        private final boolean enabled;

        public FieldNamesFieldType(boolean enabled) {
            super(Defaults.NAME, true, false, false, TextSearchInfo.SIMPLE_MATCH_ONLY, Collections.emptyMap());
            this.enabled = enabled;
        }

        @Override
        public String typeName() {
            return FieldNamesFieldMapper.CONTENT_TYPE;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup lookup, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for internal field [" + this.name() + "].");
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            throw new UnsupportedOperationException("Cannot run exists query on _field_names");
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            if (!this.isEnabled()) {
                throw new IllegalStateException("Cannot run [exists] queries if the [_field_names] field is disabled");
            }
            deprecationLogger.deprecate("terms_query_on_field_names", "terms query on the _field_names field is deprecated and will be removed, use exists query instead", new Object[0]);
            return super.termQuery(value, context);
        }
    }

    public static class Defaults {
        public static final String NAME = NAME;
        public static final Explicit<Boolean> ENABLED = new Explicit((Object)true, false);
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

