/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.core.common.regex.Regex;
import io.skylite.core.mapper.BaseMappedFieldType;
import io.skylite.core.mapper.DynamicKeyFieldMapper;
import io.skylite.core.mapper.DynamicKeyFieldTypeLookup;
import io.skylite.core.mapper.FieldAliasMapper;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.RuntimeFieldType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class FieldTypeLookup {
    private final Map<String, MappedFieldType> fullNameToFieldType = new HashMap<String, MappedFieldType>();
    private final Map<String, String> aliasToConcreteName = new HashMap<String, String>();
    private final Map<String, Set<String>> fieldToCopiedFields = new HashMap<String, Set<String>>();
    private final DynamicKeyFieldTypeLookup dynamicKeyLookup;

    FieldTypeLookup() {
        this(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    FieldTypeLookup(Collection<FieldMapper> fieldMappers, Collection<FieldAliasMapper> fieldAliasMappers, Collection<RuntimeFieldType> runtimeFieldTypes) {
        HashMap<String, DynamicKeyFieldMapper> dynamicKeyMappers = new HashMap<String, DynamicKeyFieldMapper>();
        for (FieldMapper fieldMapper : fieldMappers) {
            String fieldName = fieldMapper.name();
            MappedFieldType fieldType = fieldMapper.fieldType();
            this.fullNameToFieldType.put(fieldType.name(), fieldType);
            if (fieldMapper instanceof DynamicKeyFieldMapper) {
                dynamicKeyMappers.put(fieldName, (DynamicKeyFieldMapper)fieldMapper);
            }
            for (String targetField : fieldMapper.copyTo().copyToFields()) {
                Set<String> sourcePath = this.fieldToCopiedFields.get(targetField);
                if (sourcePath == null) {
                    HashSet<String> copiedFields = new HashSet<String>();
                    copiedFields.add(targetField);
                    this.fieldToCopiedFields.put(targetField, copiedFields);
                }
                this.fieldToCopiedFields.get(targetField).add(fieldName);
            }
        }
        for (FieldAliasMapper fieldAliasMapper : fieldAliasMappers) {
            String aliasName = fieldAliasMapper.name();
            String path = fieldAliasMapper.path();
            this.aliasToConcreteName.put(aliasName, path);
        }
        for (RuntimeFieldType runtimeFieldType : runtimeFieldTypes) {
            this.fullNameToFieldType.put(runtimeFieldType.name(), runtimeFieldType);
        }
        this.dynamicKeyLookup = new DynamicKeyFieldTypeLookup(dynamicKeyMappers, this.aliasToConcreteName);
    }

    public MappedFieldType get(String field) {
        String concreteField = this.aliasToConcreteName.getOrDefault(field, field);
        MappedFieldType fieldType = this.fullNameToFieldType.get(concreteField);
        if (fieldType != null) {
            return fieldType;
        }
        return this.dynamicKeyLookup.get(field);
    }

    public Set<String> simpleMatchToFullName(String pattern) {
        if (!Regex.isSimpleMatchPattern(pattern)) {
            return Collections.singleton(pattern);
        }
        HashSet<String> fields = new HashSet<String>();
        for (String field : this.fullNameToFieldType.keySet()) {
            if (!Regex.simpleMatch(pattern, field)) continue;
            fields.add(field);
        }
        for (String aliasName : this.aliasToConcreteName.keySet()) {
            if (!Regex.simpleMatch(pattern, aliasName)) continue;
            fields.add(aliasName);
        }
        return fields;
    }

    public Set<String> sourcePaths(String field) {
        String parentField;
        if (this.fullNameToFieldType.isEmpty()) {
            return Set.of();
        }
        String resolvedField = field;
        int lastDotIndex = field.lastIndexOf(46);
        if (lastDotIndex > 0 && this.fullNameToFieldType.containsKey(parentField = field.substring(0, lastDotIndex))) {
            resolvedField = parentField;
        }
        return this.fieldToCopiedFields.containsKey(resolvedField) ? this.fieldToCopiedFields.get(resolvedField) : Set.of(resolvedField);
    }

    Iterable<BaseMappedFieldType> filter(Predicate<? super BaseMappedFieldType> predicate) {
        return () -> Stream.concat(this.fullNameToFieldType.values().stream(), this.dynamicKeyLookup.fieldTypes()).distinct().filter(predicate).iterator();
    }
}

