/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.SkyliteException;
import io.skylite.Version;
import io.skylite.common.Nullable;
import io.skylite.common.collect.Iterators;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.analysis.NamedAnalyzer;
import io.skylite.core.index.fielddata.BaseIndexFieldData;
import io.skylite.core.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.QueryShardException;
import io.skylite.core.lucene.Lucene;
import io.skylite.core.lucene.search.AutomatonQueries;
import io.skylite.core.mapper.ContentPath;
import io.skylite.core.mapper.DynamicKeyFieldMapper;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.FieldNamesFieldMapper;
import io.skylite.core.mapper.KeywordFieldMapper;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.Mapper;
import io.skylite.core.mapper.ParseContext;
import io.skylite.core.mapper.SourceValueFetcher;
import io.skylite.core.mapper.StringFieldType;
import io.skylite.core.mapper.TextSearchInfo;
import io.skylite.core.mapper.ValueFetcher;
import io.skylite.core.search.SearchServiceSettings;
import io.skylite.core.search.lookup.SearchLookup;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.JsonToStringXContentParser;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;

public final class FlatObjectFieldMapper
extends DynamicKeyFieldMapper {
    public static final String CONTENT_TYPE = "flat_object";
    private static final String VALUE_AND_PATH_SUFFIX = "._valueAndPath";
    private static final String VALUE_SUFFIX = "._value";
    private static final String DOT_SYMBOL = ".";
    private static final String EQUAL_SYMBOL = "=";
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n));
    private final Builder builder;
    private final ValueFieldMapper valueFieldMapper;
    private final ValueAndPathFieldMapper valueAndPathFieldMapper;

    @Override
    public MappedFieldType keyedFieldType(String key) {
        return new FlatObjectFieldType(this.name() + DOT_SYMBOL + key, this.name());
    }

    private static Builder builder(Mapper in) {
        return ((FlatObjectFieldMapper)in).builder;
    }

    FlatObjectFieldMapper(String simpleName, FlatObjectFieldType mappedFieldType, ValueFieldMapper valueFieldMapper, ValueAndPathFieldMapper valueAndPathFieldMapper, Builder builder) {
        super(simpleName, (MappedFieldType)mappedFieldType, mappedFieldType.normalizer, builder.copyTo.build());
        this.valueFieldMapper = valueFieldMapper;
        this.valueAndPathFieldMapper = valueAndPathFieldMapper;
        this.mappedFieldType = mappedFieldType;
        this.builder = builder;
    }

    @Override
    public FlatObjectFieldType fieldType() {
        return (FlatObjectFieldType)super.fieldType();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        String fieldName = null;
        if (context.externalValueSet()) {
            String value = context.externalValue().toString();
            this.parseValueAddFields(context, value, this.fieldType().name());
        } else {
            XContentParser.Token currentToken;
            JsonToStringXContentParser JsonToStringParser = new JsonToStringXContentParser(NamedXContentRegistry.EMPTY, DeprecationHandler.IGNORE_DEPRECATIONS, context, this.fieldType().name());
            XContentParser parser = JsonToStringParser.parseObject();
            while ((currentToken = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                switch (currentToken) {
                    case FIELD_NAME: {
                        fieldName = parser.currentName();
                        break;
                    }
                    case VALUE_STRING: {
                        String value = parser.textOrNull();
                        this.parseValueAddFields(context, value, fieldName);
                    }
                }
            }
        }
    }

    @Override
    public Iterator<Mapper> iterator() {
        ArrayList<FieldMapper> subIterators = new ArrayList<FieldMapper>();
        if (this.valueFieldMapper != null) {
            subIterators.add(this.valueFieldMapper);
        }
        if (this.valueAndPathFieldMapper != null) {
            subIterators.add(this.valueAndPathFieldMapper);
        }
        if (subIterators.size() == 0) {
            return super.iterator();
        }
        Iterator concat = Iterators.concat((Iterator[])new Iterator[]{super.iterator(), subIterators.iterator()});
        return concat;
    }

    private void parseValueAddFields(ParseContext context, String value, String fieldName) throws IOException {
        NamedAnalyzer normalizer = this.fieldType().normalizer();
        if (normalizer != null) {
            value = FlatObjectFieldMapper.normalizeValue(normalizer, this.name(), value);
        }
        String[] valueTypeList = fieldName.split("\\._");
        String valueType = "._" + valueTypeList[valueTypeList.length - 1];
        if (this.builder.indexed.get().booleanValue() || this.builder.stored.get().booleanValue()) {
            BytesRef binaryValue = new BytesRef((CharSequence)(this.fieldType().name() + DOT_SYMBOL + value));
            FlatObjectField field = new FlatObjectField(this.fieldType().name(), binaryValue, Defaults.FIELD_TYPE);
            if (!this.builder.hasDocValues.get().booleanValue() && this.builder.omitNorms.get().booleanValue()) {
                context.addFieldToFieldNamesField(this.fieldType().name());
            }
            if (fieldName.equals(this.fieldType().name())) {
                context.doc().add((IndexableField)field);
            }
            if (valueType.equals(VALUE_SUFFIX) && this.valueFieldMapper != null) {
                this.valueFieldMapper.addField(context, value);
            }
            if (valueType.equals(VALUE_AND_PATH_SUFFIX) && this.valueAndPathFieldMapper != null) {
                this.valueAndPathFieldMapper.addField(context, value);
            }
            if (this.builder.hasDocValues.get().booleanValue()) {
                if (fieldName.equals(this.fieldType().name())) {
                    context.doc().add((IndexableField)new SortedSetDocValuesField(this.fieldType().name(), binaryValue));
                }
                if (valueType.equals(VALUE_SUFFIX) && this.valueFieldMapper != null) {
                    context.doc().add((IndexableField)new SortedSetDocValuesField(this.fieldType().name() + VALUE_SUFFIX, binaryValue));
                }
                if (valueType.equals(VALUE_AND_PATH_SUFFIX) && this.valueAndPathFieldMapper != null) {
                    context.doc().add((IndexableField)new SortedSetDocValuesField(this.fieldType().name() + VALUE_AND_PATH_SUFFIX, binaryValue));
                }
            }
        }
    }

    private static String normalizeValue(NamedAnalyzer normalizer, String field, String value) throws IOException {
        String normalizerErrorMessage = "The normalization token stream is expected to produce exactly 1 token, but got 0 for analyzer " + String.valueOf((Object)normalizer) + " and input \"" + value + "\"";
        try (TokenStream ts = normalizer.tokenStream(field, value);){
            CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
            ts.reset();
            if (!ts.incrementToken()) {
                throw new IllegalStateException(normalizerErrorMessage);
            }
            String newValue = termAtt.toString();
            if (ts.incrementToken()) {
                throw new IllegalStateException(normalizerErrorMessage);
            }
            ts.end();
            String string = newValue;
            return string;
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init(this);
    }

    public static final class FlatObjectFieldType
    extends StringFieldType {
        private final int ignoreAbove;
        private final String nullValue;
        private final NamedAnalyzer normalizer = Lucene.KEYWORD_ANALYZER;
        private final String mappedFieldTypeName;
        private KeywordFieldMapper.KeywordFieldType valueFieldType;
        private KeywordFieldMapper.KeywordFieldType valueAndPathFieldType;

        public FlatObjectFieldType(String name, boolean isSearchable, boolean hasDocValues, Map<String, String> meta) {
            super(name, isSearchable, false, hasDocValues, TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, meta);
            this.ignoreAbove = Integer.MAX_VALUE;
            this.nullValue = null;
            this.mappedFieldTypeName = null;
        }

        public FlatObjectFieldType(String name, Builder builder) {
            super(name, (boolean)builder.indexed.get(), (boolean)builder.stored.get(), (boolean)builder.hasDocValues.get(), TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, Collections.emptyMap());
            this.ignoreAbove = Integer.MAX_VALUE;
            this.nullValue = null;
            this.mappedFieldTypeName = null;
        }

        public FlatObjectFieldType(String name, NamedAnalyzer analyzer) {
            super(name, true, false, true, new TextSearchInfo(Defaults.FIELD_TYPE, null, analyzer, analyzer), Collections.emptyMap());
            this.ignoreAbove = Integer.MAX_VALUE;
            this.nullValue = null;
            this.mappedFieldTypeName = null;
        }

        public FlatObjectFieldType(String name, String mappedFieldTypeName) {
            super(name, true, false, true, TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, Collections.emptyMap());
            this.ignoreAbove = Integer.MAX_VALUE;
            this.nullValue = null;
            this.mappedFieldTypeName = mappedFieldTypeName;
        }

        void setValueFieldType(KeywordFieldMapper.KeywordFieldType valueFieldType) {
            this.valueFieldType = valueFieldType;
        }

        void setValueAndPathFieldType(KeywordFieldMapper.KeywordFieldType ValueAndPathFieldType) {
            this.valueAndPathFieldType = ValueAndPathFieldType;
        }

        public KeywordFieldMapper.KeywordFieldType getValueFieldType() {
            return this.valueFieldType;
        }

        public KeywordFieldMapper.KeywordFieldType getValueAndPathFieldType() {
            return this.valueAndPathFieldType;
        }

        @Override
        public String typeName() {
            return FlatObjectFieldMapper.CONTENT_TYPE;
        }

        NamedAnalyzer normalizer() {
            return this.normalizer;
        }

        @Override
        public BaseIndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), CoreValuesSourceType.BYTES);
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this.name(), context, this.nullValue){

                @Override
                protected String parseSourceValue(Object value) {
                    String flatObjectKeywordValue = value.toString();
                    if (flatObjectKeywordValue.length() > ignoreAbove) {
                        return null;
                    }
                    NamedAnalyzer normalizer = this.normalizer();
                    if (normalizer == null) {
                        return flatObjectKeywordValue;
                    }
                    try {
                        return FlatObjectFieldMapper.normalizeValue(normalizer, this.name(), flatObjectKeywordValue);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            };
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }

        @Override
        protected BytesRef indexedValueForSearch(Object value) {
            if (this.getTextSearchInfo().getSearchAnalyzer() == Lucene.KEYWORD_ANALYZER) {
                return super.indexedValueForSearch(value);
            }
            if (value == null) {
                return null;
            }
            value = this.inputToString(value);
            return this.getTextSearchInfo().getSearchAnalyzer().normalize(this.name(), value.toString());
        }

        @Override
        public Query termQuery(Object value, @Nullable QueryShardContext context) {
            String searchValueString = this.inputToString(value);
            String directSubFieldName = this.directSubfield();
            String rewriteSearchValue = this.rewriteValue(searchValueString);
            this.failIfNotIndexed();
            return new TermQuery(new Term(directSubFieldName, this.indexedValueForSearch(rewriteSearchValue)));
        }

        @Override
        public Query termsQuery(List<?> values, QueryShardContext context) {
            this.failIfNotIndexed();
            String directedSearchFieldName = this.directSubfield();
            BytesRef[] bytesRefs = new BytesRef[values.size()];
            for (int i = 0; i < bytesRefs.length; ++i) {
                String rewriteValues = this.rewriteValue(this.inputToString(values.get(i)));
                bytesRefs[i] = this.indexedValueForSearch(new BytesRef((CharSequence)rewriteValues));
            }
            return new TermInSetQuery(directedSearchFieldName, List.of(bytesRefs));
        }

        public String directSubfield() {
            if (this.mappedFieldTypeName == null) {
                return this.name() + FlatObjectFieldMapper.VALUE_SUFFIX;
            }
            return this.mappedFieldTypeName + FlatObjectFieldMapper.VALUE_AND_PATH_SUFFIX;
        }

        public String rewriteValue(String searchValueString) {
            if (!this.hasMappedFieldTyeNameInQueryFieldName(this.name())) {
                return searchValueString;
            }
            String rewriteSearchValue = this.name() + FlatObjectFieldMapper.EQUAL_SYMBOL + searchValueString;
            return rewriteSearchValue;
        }

        private boolean hasMappedFieldTyeNameInQueryFieldName(String input) {
            String prefix = this.mappedFieldTypeName;
            if (prefix == null) {
                return false;
            }
            if (!input.startsWith(prefix)) {
                return false;
            }
            String rest = input.substring(prefix.length());
            return !rest.isEmpty();
        }

        private String inputToString(Object inputValue) {
            if (inputValue instanceof Integer) {
                String inputToString = Integer.toString((Integer)inputValue);
                return inputToString;
            }
            if (inputValue instanceof Float) {
                String inputToString = Float.toString(((Float)inputValue).floatValue());
                return inputToString;
            }
            if (inputValue instanceof Boolean) {
                String inputToString = Boolean.toString((Boolean)inputValue);
                return inputToString;
            }
            if (inputValue instanceof Short) {
                String inputToString = Short.toString((Short)inputValue);
                return inputToString;
            }
            if (inputValue instanceof Long) {
                String inputToString = Long.toString((Long)inputValue);
                return inputToString;
            }
            if (inputValue instanceof Double) {
                String inputToString = Double.toString((Double)inputValue);
                return inputToString;
            }
            if (inputValue instanceof BytesRef) {
                String inputToString = ((BytesRef)inputValue).utf8ToString();
                return inputToString;
            }
            if (inputValue instanceof String) {
                String inputToString = (String)inputValue;
                return inputToString;
            }
            if (inputValue instanceof Version) {
                String inputToString = inputValue.toString();
                return inputToString;
            }
            return inputValue.toString();
        }

        @Override
        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, QueryShardContext context) {
            String directSubfield = this.directSubfield();
            String rewriteValue = this.rewriteValue(value);
            if (!context.allowExpensiveQueries()) {
                throw new SkyliteException("[prefix] queries cannot be executed when '" + SearchServiceSettings.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false. For optimised prefix queries on text fields please enable [index_prefixes].", new Object[0]);
            }
            this.failIfNotIndexed();
            if (method == null) {
                method = MultiTermQuery.CONSTANT_SCORE_REWRITE;
            }
            if (caseInsensitive) {
                return AutomatonQueries.caseInsensitivePrefixQuery(new Term(directSubfield, this.indexedValueForSearch(rewriteValue)), method);
            }
            return new PrefixQuery(new Term(directSubfield, this.indexedValueForSearch(rewriteValue)), method);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            String directSubfield = this.directSubfield();
            String rewriteUpperTerm = this.rewriteValue(this.inputToString(upperTerm));
            String rewriteLowerTerm = this.rewriteValue(this.inputToString(lowerTerm));
            if (!context.allowExpensiveQueries()) {
                throw new SkyliteException("[range] queries on [text] or [keyword] fields cannot be executed when '" + SearchServiceSettings.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
            }
            this.failIfNotIndexed();
            return new TermRangeQuery(directSubfield, lowerTerm == null ? null : this.indexedValueForSearch(rewriteLowerTerm), upperTerm == null ? null : this.indexedValueForSearch(rewriteUpperTerm), includeLower, includeUpper);
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            String searchField;
            String searchKey;
            if (this.hasMappedFieldTyeNameInQueryFieldName(this.name())) {
                searchKey = this.mappedFieldTypeName;
                searchField = this.name();
            } else {
                searchKey = FieldNamesFieldMapper.NAME;
                searchField = this.name();
            }
            return new TermQuery(new Term(searchKey, this.indexedValueForSearch(searchField)));
        }

        @Override
        public Query wildcardQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, boolean caseInsensitve, QueryShardContext context) {
            throw new QueryShardException(context.getFullyQualifiedIndex(), "Can only use wildcard queries on keyword and text fields - not on [" + this.name() + "] which is of type [" + this.typeName() + "]", new Object[0]);
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> FlatObjectFieldMapper.builder((Mapper)m).indexed.get(), true);
        private final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> FlatObjectFieldMapper.builder((Mapper)m).stored.get(), true);
        private final FieldMapper.Parameter<Boolean> omitNorms = FieldMapper.Parameter.boolParam("omit_norms", false, m -> FlatObjectFieldMapper.builder((Mapper)m).omitNorms.get(), true);
        private final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> FlatObjectFieldMapper.builder((Mapper)m).hasDocValues.get(), true);
        private final FieldMapper.Parameter<String> nullValue = FieldMapper.Parameter.stringParam("null_value", false, m -> FlatObjectFieldMapper.builder((Mapper)m).nullValue.get(), null).acceptsNull();
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name) {
            super(name);
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return List.of(this.indexed, this.stored, this.omitNorms, this.hasDocValues, this.nullValue, this.meta);
        }

        public Builder docValues(boolean hasDocValues) {
            this.hasDocValues.setValue(hasDocValues);
            return this;
        }

        private FlatObjectFieldType buildFlatObjectFieldType(ContentPath contentPath) {
            return new FlatObjectFieldType(this.buildFullName(contentPath), this);
        }

        private ValueFieldMapper buildValueFieldMapper(ContentPath contentPath, FlatObjectFieldType fft) {
            String fullName = this.buildFullName(contentPath);
            KeywordFieldMapper.KeywordFieldType valueFieldType = new KeywordFieldMapper.KeywordFieldType(fullName + FlatObjectFieldMapper.VALUE_SUFFIX, Defaults.FIELD_TYPE);
            fft.setValueFieldType(valueFieldType);
            return new ValueFieldMapper(valueFieldType, this);
        }

        private ValueAndPathFieldMapper buildValueAndPathFieldMapper(ContentPath contentPath, FlatObjectFieldType fft) {
            String fullName = this.buildFullName(contentPath);
            KeywordFieldMapper.KeywordFieldType valueAndPathFieldType = new KeywordFieldMapper.KeywordFieldType(fullName + FlatObjectFieldMapper.VALUE_AND_PATH_SUFFIX, Defaults.FIELD_TYPE);
            fft.setValueAndPathFieldType(valueAndPathFieldType);
            return new ValueAndPathFieldMapper(valueAndPathFieldType, this);
        }

        @Override
        public FlatObjectFieldMapper build(ContentPath contentPath) {
            FlatObjectFieldType fft = this.buildFlatObjectFieldType(contentPath);
            return new FlatObjectFieldMapper(this.name, fft, this.buildValueFieldMapper(contentPath, fft), this.buildValueAndPathFieldMapper(contentPath, fft), this);
        }
    }

    private static final class ValueFieldMapper
    extends FieldMapper {
        private final Builder builder;

        protected ValueFieldMapper(KeywordFieldMapper.KeywordFieldType mappedFieldType, Builder builder) {
            super(mappedFieldType.name(), mappedFieldType, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
            this.builder = builder;
        }

        void addField(ParseContext context, String value) {
            BytesRef binaryValue = new BytesRef((CharSequence)value);
            if (this.builder.indexed.get().booleanValue() || this.builder.stored.get().booleanValue()) {
                KeywordFieldMapper.KeywordField field = new KeywordFieldMapper.KeywordField(this.fieldType().name(), binaryValue, Defaults.FIELD_TYPE);
                context.doc().add((IndexableField)field);
                if (!this.fieldType().hasDocValues() && Defaults.FIELD_TYPE.omitNorms()) {
                    context.addFieldToFieldNamesField(this.fieldType().name());
                }
            }
        }

        @Override
        protected void parseCreateField(ParseContext context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FieldMapper.Builder getMergeBuilder() {
            return null;
        }

        @Override
        protected String contentType() {
            return "value";
        }

        public String toString() {
            return this.fieldType().toString();
        }
    }

    private static final class ValueAndPathFieldMapper
    extends FieldMapper {
        Builder builder;

        protected ValueAndPathFieldMapper(KeywordFieldMapper.KeywordFieldType mappedFieldType, Builder builder) {
            super(mappedFieldType.name(), mappedFieldType, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
            this.builder = builder;
        }

        void addField(ParseContext context, String value) {
            BytesRef binaryValue = new BytesRef((CharSequence)value);
            if (this.builder.indexed.get().booleanValue() || this.builder.stored.get().booleanValue()) {
                KeywordFieldMapper.KeywordField field = new KeywordFieldMapper.KeywordField(this.fieldType().name(), binaryValue, Defaults.FIELD_TYPE);
                context.doc().add((IndexableField)field);
                if (!this.fieldType().hasDocValues() && Defaults.FIELD_TYPE.omitNorms()) {
                    context.addFieldToFieldNamesField(this.fieldType().name());
                }
            }
        }

        @Override
        protected void parseCreateField(ParseContext context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FieldMapper.Builder getMergeBuilder() {
            return null;
        }

        @Override
        protected String contentType() {
            return "valueAndPath";
        }

        public String toString() {
            return this.fieldType().toString();
        }
    }

    public static class FlatObjectField
    extends Field {
        public FlatObjectField(String field, BytesRef term, FieldType ft) {
            super(field, term, (IndexableFieldType)ft);
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.freeze();
        }
    }
}

