/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.Version;
import io.skylite.common.Assertions;
import io.skylite.core.ParseField;
import io.skylite.core.analysis.AnalysisRegistry;
import io.skylite.core.analysis.CharFilterFactory;
import io.skylite.core.analysis.NamedAnalyzer;
import io.skylite.core.analysis.ReloadableCustomAnalyzer;
import io.skylite.core.analysis.TokenFilterFactory;
import io.skylite.core.analysis.TokenizerFactory;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.MappingMetadata;
import io.skylite.core.common.Strings;
import io.skylite.core.common.time.DateFormatter;
import io.skylite.core.compress.CompressedXContent;
import io.skylite.core.index.AbstractIndexComponent;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.analysis.IndexAnalyzers;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.similarity.SimilarityService;
import io.skylite.core.mapper.BaseMappedFieldType;
import io.skylite.core.mapper.DocumentMapper;
import io.skylite.core.mapper.DocumentParser;
import io.skylite.core.mapper.InvalidTypeNameException;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.MapperParsingException;
import io.skylite.core.mapper.MapperRegistry;
import io.skylite.core.mapper.Mapping;
import io.skylite.core.mapper.MappingLookup;
import io.skylite.core.mapper.MappingParser;
import io.skylite.core.mapper.MappingParserContext;
import io.skylite.core.mapper.MergeReason;
import io.skylite.core.mapper.MetadataFieldMapper;
import io.skylite.core.mapper.ObjectMapper;
import io.skylite.core.script.ScriptService;
import io.skylite.core.settings.MapperSettings;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class MapperService
extends AbstractIndexComponent
implements Closeable {
    @Deprecated
    public static final Set<String> META_FIELDS_BEFORE_7DOT8 = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("_id", ParseField.CommonMetaFields.IGNORED_FIELD.getPreferredName(), "_index", "_routing", "_size", "_timestamp", "_ttl", "_type")));
    private final IndexAnalyzers indexAnalyzers;
    private volatile DocumentMapper mapper;
    private final MappingParser mappingParser;
    private final DocumentParser documentParser;
    private final Version<?> indexVersionCreated;
    private final MapperRegistry mapperRegistry;
    private final Supplier<MappingParserContext> parserContextSupplier;

    public MapperService(IndexSettings indexSettings, IndexAnalyzers indexAnalyzers, NamedXContentRegistry xContentRegistry, SimilarityService similarityService, MapperRegistry mapperRegistry, Supplier<? extends QueryRewriteContext> queryShardContextSupplier, BooleanSupplier idFieldDataEnabled, ScriptService scriptService) {
        super(indexSettings);
        this.indexVersionCreated = indexSettings.getIndexVersionCreated();
        this.indexAnalyzers = indexAnalyzers;
        this.mapperRegistry = mapperRegistry;
        Function<DateFormatter, MappingParserContext> parserContextFunction = dateFormatter -> new MappingParserContext(similarityService::getSimilarity, mapperRegistry.getMapperParsers()::get, mapperRegistry.getRuntimeFieldTypeParsers()::get, this.indexVersionCreated, queryShardContextSupplier, (DateFormatter)dateFormatter, scriptService, indexAnalyzers, indexSettings, idFieldDataEnabled, mapperRegistry.getDynamicRuntimeFieldsBuilder() != null);
        this.documentParser = new DocumentParser(xContentRegistry, parserContextFunction, mapperRegistry.getDynamicRuntimeFieldsBuilder(), indexSettings, indexAnalyzers);
        Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers = mapperRegistry.getMetadataMapperParsers();
        this.parserContextSupplier = () -> (MappingParserContext)parserContextFunction.apply(null);
        this.mappingParser = new MappingParser(this.parserContextSupplier, metadataMapperParsers, this::getMetadataMappers, this::resolveDocumentType);
        if (MapperSettings.INDEX_MAPPER_DYNAMIC_SETTING.exists(indexSettings.getSettings())) {
            throw new IllegalArgumentException("Setting " + MapperSettings.INDEX_MAPPER_DYNAMIC_SETTING.getKey() + " was removed after version 6.0.0");
        }
    }

    public boolean hasNested() {
        return this.mappingLookup().hasNested();
    }

    public IndexAnalyzers getIndexAnalyzers() {
        return this.indexAnalyzers;
    }

    public NamedAnalyzer getNamedAnalyzer(String analyzerName) {
        return this.indexAnalyzers.get(analyzerName);
    }

    public MappingParserContext parserContext() {
        return this.parserContextSupplier.get();
    }

    public DocumentParser documentParser() {
        return this.documentParser;
    }

    Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> getMetadataMappers() {
        DocumentMapper existingMapper = this.mapper;
        Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers = this.mapperRegistry.getMetadataMapperParsers();
        LinkedHashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> metadataMappers = new LinkedHashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>();
        if (existingMapper == null) {
            for (MetadataFieldMapper.TypeParser parser : metadataMapperParsers.values()) {
                MetadataFieldMapper metadataFieldMapper = parser.getDefault(this.parserContext());
                metadataMappers.put(metadataFieldMapper.getClass(), metadataFieldMapper);
            }
        } else {
            metadataMappers.putAll(existingMapper.mapping().getMetadataMappersMap());
        }
        return metadataMappers;
    }

    public static Map<String, Object> parseMapping(NamedXContentRegistry xContentRegistry, String mappingSource) throws IOException {
        try (XContentParser parser = MediaTypeRegistry.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, mappingSource);){
            Map<String, Object> map = parser.map();
            return map;
        }
    }

    public boolean updateMapping(IndexMetadata currentIndexMetadata, IndexMetadata newIndexMetadata) throws IOException {
        Map<String, DocumentMapper> updatedEntries;
        assert (newIndexMetadata.getIndex().equals(this.index())) : "index mismatch: expected " + String.valueOf(this.index()) + " but was " + String.valueOf(newIndexMetadata.getIndex());
        if (currentIndexMetadata != null && currentIndexMetadata.getMappingVersion() == newIndexMetadata.getMappingVersion()) {
            this.assertMappingVersion(currentIndexMetadata, newIndexMetadata, Collections.emptyMap());
            return false;
        }
        HashSet<String> existingMappers = new HashSet<String>();
        if (this.mapper != null) {
            existingMappers.add(this.mapper.type());
        }
        try {
            updatedEntries = this.internalMerge(newIndexMetadata, MergeReason.MAPPING_RECOVERY);
        }
        catch (Exception e) {
            this.logger.warn(() -> new ParameterizedMessage("[{}] failed to apply mappings", (Object)this.index()), (Throwable)e);
            throw e;
        }
        boolean requireRefresh = false;
        this.assertMappingVersion(currentIndexMetadata, newIndexMetadata, updatedEntries);
        for (DocumentMapper documentMapper : updatedEntries.values()) {
            String op;
            String mappingType = documentMapper.type();
            MappingMetadata mappingMetadata = newIndexMetadata.mapping();
            assert (mappingType.equals(mappingMetadata.type()));
            CompressedXContent incomingMappingSource = mappingMetadata.source();
            String string = op = existingMappers.contains(mappingType) ? "updated" : "added";
            if (this.logger.isDebugEnabled() && incomingMappingSource.compressed().length < 512) {
                this.logger.debug("[{}] {} mapping [{}], source [{}]", (Object)this.index(), (Object)op, (Object)mappingType, (Object)incomingMappingSource.string());
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace("[{}] {} mapping [{}], source [{}]", (Object)this.index(), (Object)op, (Object)mappingType, (Object)incomingMappingSource.string());
            } else {
                this.logger.debug("[{}] {} mapping [{}] (source suppressed due to length, use TRACE level if needed)", (Object)this.index(), (Object)op, (Object)mappingType);
            }
            if (this.documentMapper().mappingSource().equals(incomingMappingSource)) continue;
            this.logger.debug("[{}] parsed mapping [{}], and got different sources\noriginal:\n{}\nparsed:\n{}", (Object)this.index(), (Object)mappingType, (Object)incomingMappingSource, (Object)this.documentMapper().mappingSource());
            requireRefresh = true;
        }
        return requireRefresh;
    }

    private void assertMappingVersion(IndexMetadata currentIndexMetadata, IndexMetadata newIndexMetadata, Map<String, DocumentMapper> updatedEntries) throws IOException {
        if (Assertions.ENABLED && currentIndexMetadata != null) {
            if (currentIndexMetadata.getMappingVersion() == newIndexMetadata.getMappingVersion()) {
                assert (updatedEntries.isEmpty()) : updatedEntries;
                MappingMetadata mapping = newIndexMetadata.mapping();
                if (mapping != null) {
                    CompressedXContent currentSource = currentIndexMetadata.mapping().source();
                    CompressedXContent newSource = mapping.source();
                    assert (currentSource.equals(newSource)) : "expected current mapping [" + String.valueOf(currentSource) + "] for type [" + mapping.type() + "] to be the same as new mapping [" + String.valueOf(newSource) + "]";
                    CompressedXContent mapperSource = new CompressedXContent(Strings.toString(MediaTypeRegistry.JSON, this.mapper));
                    assert (currentSource.equals(mapperSource)) : "expected current mapping [" + String.valueOf(currentSource) + "] for type [" + mapping.type() + "] to be the same as new mapping [" + String.valueOf(mapperSource) + "]";
                }
            } else {
                long currentMappingVersion = currentIndexMetadata.getMappingVersion();
                long newMappingVersion = newIndexMetadata.getMappingVersion();
                assert (currentMappingVersion < newMappingVersion) : "expected current mapping version [" + currentMappingVersion + "] to be less than new mapping version [" + newMappingVersion + "]";
                assert (!updatedEntries.isEmpty());
                for (DocumentMapper documentMapper : updatedEntries.values()) {
                    MappingMetadata currentMapping = currentIndexMetadata.mapping();
                    assert (currentMapping == null || documentMapper.type().equals(currentMapping.type()));
                    if (currentMapping == null) continue;
                    CompressedXContent currentSource = currentMapping.source();
                    CompressedXContent newSource = documentMapper.mappingSource();
                    assert (!currentSource.equals(newSource)) : "expected current mapping [" + String.valueOf(currentSource) + "] for type [" + documentMapper.type() + "] to be different than new mapping";
                }
            }
        }
    }

    public void merge(Map<String, Map<String, Object>> mappings, MergeReason reason) {
        LinkedHashMap<String, CompressedXContent> mappingSourcesCompressed = new LinkedHashMap<String, CompressedXContent>(mappings.size());
        for (Map.Entry<String, Map<String, Object>> entry : mappings.entrySet()) {
            try {
                mappingSourcesCompressed.put(entry.getKey(), new CompressedXContent(MediaTypeRegistry.JSON.contentBuilder().map(entry.getValue()).toString()));
            }
            catch (Exception e) {
                throw new MapperParsingException("Failed to parse mapping [{}]: {}", (Throwable)e, entry.getKey(), e.getMessage());
            }
        }
        this.internalMerge(mappingSourcesCompressed, reason);
    }

    public void merge(String type, Map<String, Object> mappings, MergeReason reason) throws IOException {
        CompressedXContent content = new CompressedXContent(MediaTypeRegistry.JSON.contentBuilder().map(mappings).toString());
        this.internalMerge(Collections.singletonMap(type, content), reason);
    }

    public void merge(IndexMetadata indexMetadata, MergeReason reason) {
        this.internalMerge(indexMetadata, reason);
    }

    public DocumentMapper merge(String type, CompressedXContent mappingSource, MergeReason reason) {
        return this.internalMerge(Collections.singletonMap(type, mappingSource), reason).values().iterator().next();
    }

    private synchronized Map<String, DocumentMapper> internalMerge(IndexMetadata indexMetadata, MergeReason reason) {
        assert (reason != MergeReason.MAPPING_UPDATE_PREFLIGHT);
        LinkedHashMap<String, CompressedXContent> map = new LinkedHashMap<String, CompressedXContent>();
        MappingMetadata mappingMetadata = indexMetadata.mapping();
        if (mappingMetadata != null) {
            map.put(mappingMetadata.type(), mappingMetadata.source());
        }
        return this.internalMerge(map, reason);
    }

    private synchronized Map<String, DocumentMapper> internalMerge(Map<String, CompressedXContent> mappings, MergeReason reason) {
        DocumentMapper documentMapper = null;
        for (Map.Entry<String, CompressedXContent> entry : mappings.entrySet()) {
            String type = entry.getKey();
            if (documentMapper != null) {
                throw new IllegalArgumentException("Cannot put multiple mappings: " + String.valueOf(mappings.keySet()));
            }
            try {
                documentMapper = this.parse(type, entry.getValue());
            }
            catch (Exception e) {
                throw new MapperParsingException("Failed to parse mapping [{}]: {}", (Throwable)e, entry.getKey(), e.getMessage());
            }
        }
        return this.internalMerge(documentMapper, reason);
    }

    static void validateTypeName(String type) {
        if (type.length() == 0) {
            throw new InvalidTypeNameException("mapping type name is empty");
        }
        if (type.length() > 255) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] is too long; limit is length 255 but was [" + type.length() + "]");
        }
        if (type.charAt(0) == '_' && !"_doc".equals(type)) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] can't start with '_' unless it is called [_doc]");
        }
        if (type.contains("#")) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] should not include '#' in it");
        }
        if (type.contains(",")) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] should not include ',' in it");
        }
        if (type.charAt(0) == '.') {
            throw new IllegalArgumentException("mapping type name [" + type + "] must not start with a '.'");
        }
    }

    private synchronized Map<String, DocumentMapper> internalMerge(DocumentMapper mapper, MergeReason reason) {
        LinkedHashMap<String, DocumentMapper> results = new LinkedHashMap(2);
        DocumentMapper newMapper = null;
        if (mapper != null) {
            MapperService.validateTypeName(mapper.type());
            DocumentMapper oldMapper = this.mapper;
            newMapper = oldMapper != null ? oldMapper.merge(mapper.mapping(), reason) : mapper;
            newMapper.mapping().getRoot().fixRedundantIncludes();
            newMapper.validate(this.indexSettings, reason != MergeReason.MAPPING_RECOVERY);
            results.put(newMapper.type(), newMapper);
        }
        results = Collections.unmodifiableMap(results);
        if (reason == MergeReason.MAPPING_UPDATE_PREFLIGHT) {
            return results;
        }
        if (newMapper != null) {
            this.mapper = newMapper;
        }
        assert (results.values().stream().allMatch(this::assertSerialization));
        return results;
    }

    private boolean assertSerialization(DocumentMapper mapper) {
        CompressedXContent mappingSource = mapper.mappingSource();
        DocumentMapper newMapper = this.parse(mapper.type(), mappingSource);
        if (!newMapper.mappingSource().equals(mappingSource)) {
            throw new IllegalStateException("DocumentMapper serialization result is different from source. \n--> Source [" + String.valueOf(mappingSource) + "]\n--> Result [" + String.valueOf(newMapper.mappingSource()) + "]");
        }
        return true;
    }

    public DocumentMapper parse(String mappingType, CompressedXContent mappingSource) throws MapperParsingException {
        Mapping mapping = this.mappingParser.parse(mappingType, mappingSource);
        return new DocumentMapper(this.documentParser, mapping);
    }

    public DocumentMapper documentMapper() {
        return this.mapper;
    }

    public static boolean isMappingSourceTyped(String type, Map<String, Object> mapping) {
        return mapping.size() == 1 && mapping.keySet().iterator().next().equals(type);
    }

    public static boolean isMappingSourceTyped(String type, CompressedXContent mappingSource) {
        Map root = (Map)XContentHelper.convertToMap(mappingSource.compressedReference(), true, MediaTypeRegistry.JSON).v2();
        return MapperService.isMappingSourceTyped(type, root);
    }

    private String resolveDocumentType(String type) {
        if ("_doc".equals(type) && this.mapper != null) {
            return this.mapper.type();
        }
        return type;
    }

    public MappedFieldType fieldType(String fullName) {
        return this.mappingLookup().fieldTypesLookup().get(fullName);
    }

    public Set<String> simpleMatchToFullName(String pattern) {
        return this.mappingLookup().simpleMatchToFullName(pattern);
    }

    public MappingLookup mappingLookup() {
        DocumentMapper mapper = this.mapper;
        return mapper == null ? MappingLookup.EMPTY : mapper.mappers();
    }

    public Iterable<BaseMappedFieldType> getEagerGlobalOrdinalsFields() {
        Predicate<BaseMappedFieldType> predicate = fieldType -> ((MappedFieldType)MappedFieldType.class.cast(fieldType)).eagerGlobalOrdinals();
        return this.mapper == null ? Collections.emptySet() : this.mapper.mappers().fieldTypesLookup().filter(predicate);
    }

    public ObjectMapper getObjectMapper(String name) {
        return this.mapper == null ? null : this.mapper.mappers().objectMappers().get(name);
    }

    public NamedAnalyzer indexAnalyzer(String field, Function<String, NamedAnalyzer> unindexedFieldAnalyzer) {
        return this.mappingLookup().indexAnalyzer(field, unindexedFieldAnalyzer);
    }

    @Override
    public void close() throws IOException {
        this.indexAnalyzers.close();
    }

    public boolean isMetadataField(String field) {
        return this.mapperRegistry.isMetadataField(field);
    }

    public synchronized List<String> reloadSearchAnalyzers(AnalysisRegistry registry) throws IOException {
        this.logger.info("reloading search analyzers");
        Map<String, TokenizerFactory> tokenizerFactories = registry.buildTokenizerFactories(this.indexSettings);
        Map<String, CharFilterFactory> charFilterFactories = registry.buildCharFilterFactories(this.indexSettings);
        Map<String, TokenFilterFactory> tokenFilterFactories = registry.buildTokenFilterFactories(this.indexSettings);
        Map<String, Settings> settings = this.indexSettings.getSettings().getGroups("index.analysis.analyzer");
        ArrayList<String> reloadedAnalyzers = new ArrayList<String>();
        for (NamedAnalyzer namedAnalyzer : this.indexAnalyzers.getAnalyzers().values()) {
            if (!(namedAnalyzer.analyzer() instanceof ReloadableCustomAnalyzer)) continue;
            ReloadableCustomAnalyzer analyzer = (ReloadableCustomAnalyzer)namedAnalyzer.analyzer();
            String analyzerName = namedAnalyzer.name();
            Settings analyzerSettings = settings.get(analyzerName);
            analyzer.reload(analyzerName, analyzerSettings, tokenizerFactories, charFilterFactories, tokenFilterFactories);
            reloadedAnalyzers.add(analyzerName);
        }
        return reloadedAnalyzers;
    }
}

