/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.Version;
import io.skylite.core.common.time.DateFormatter;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.analysis.IndexAnalyzers;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.similarity.SimilarityProvider;
import io.skylite.core.mapper.Mapper;
import io.skylite.core.mapper.RuntimeFieldType;
import io.skylite.core.script.ScriptService;
import io.skylite.core.settings.Settings;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;

public class MappingParserContext {
    private final Function<String, SimilarityProvider> similarityLookupService;
    private final Function<String, Mapper.TypeParser> typeParsers;
    private final Function<String, RuntimeFieldType.Parser> runtimeTypeParsers;
    private final boolean supportsDynamicRuntimeMappings;
    private final Version indexVersionCreated;
    private final Supplier<? extends QueryRewriteContext> queryShardContextSupplier;
    private final DateFormatter dateFormatter;
    private final ScriptService scriptService;
    private final IndexAnalyzers indexAnalyzers;
    private final IndexSettings indexSettings;
    private final BooleanSupplier idFieldDataEnabled;

    public MappingParserContext(Function<String, SimilarityProvider> similarityLookupService, Function<String, Mapper.TypeParser> typeParsers, Function<String, RuntimeFieldType.Parser> runtimeTypeParsers, Version indexVersionCreated, Supplier<? extends QueryRewriteContext> queryShardContextSupplier, DateFormatter dateFormatter, ScriptService scriptService, IndexAnalyzers indexAnalyzers, IndexSettings indexSettings, BooleanSupplier idFieldDataEnabled, boolean supportsDynamicRuntimeMappings) {
        this.similarityLookupService = similarityLookupService;
        this.typeParsers = typeParsers;
        this.runtimeTypeParsers = runtimeTypeParsers;
        this.indexVersionCreated = indexVersionCreated;
        this.queryShardContextSupplier = queryShardContextSupplier;
        this.dateFormatter = dateFormatter;
        this.scriptService = scriptService;
        this.indexAnalyzers = indexAnalyzers;
        this.indexSettings = indexSettings;
        this.idFieldDataEnabled = idFieldDataEnabled;
        this.supportsDynamicRuntimeMappings = supportsDynamicRuntimeMappings;
    }

    public IndexAnalyzers getIndexAnalyzers() {
        return this.indexAnalyzers;
    }

    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public BooleanSupplier isIdFieldDataEnabled() {
        return this.idFieldDataEnabled;
    }

    public Settings getSettings() {
        return this.indexSettings.getSettings();
    }

    public SimilarityProvider getSimilarity(String name) {
        return this.similarityLookupService.apply(name);
    }

    public Mapper.TypeParser typeParser(String type) {
        return this.typeParsers.apply(type);
    }

    public boolean supportsDynamicRuntimeMappings() {
        return this.supportsDynamicRuntimeMappings;
    }

    public Version indexVersionCreated() {
        return this.indexVersionCreated;
    }

    public Supplier<? extends QueryRewriteContext> queryShardContextSupplier() {
        return this.queryShardContextSupplier;
    }

    public DateFormatter getDateFormatter() {
        return this.dateFormatter;
    }

    public boolean isWithinMultiField() {
        return false;
    }

    public Function<String, Mapper.TypeParser> typeParsers() {
        return this.typeParsers;
    }

    protected Function<String, RuntimeFieldType.Parser> runtimeTypeParsers() {
        return this.runtimeTypeParsers;
    }

    protected Function<String, SimilarityProvider> similarityLookupService() {
        return this.similarityLookupService;
    }

    public ScriptService scriptService() {
        return this.scriptService;
    }

    public MappingParserContext createMultiFieldContext(MappingParserContext in) {
        return new MultiFieldParserContext(in);
    }

    static class MultiFieldParserContext
    extends MappingParserContext {
        MultiFieldParserContext(MappingParserContext in) {
            super(in.similarityLookupService(), in.typeParsers(), in.runtimeTypeParsers(), in.indexVersionCreated(), in.queryShardContextSupplier(), in.getDateFormatter(), in.scriptService(), in.indexAnalyzers, in.indexSettings, in.idFieldDataEnabled, in.supportsDynamicRuntimeMappings);
        }

        @Override
        public boolean isWithinMultiField() {
            return true;
        }
    }
}

