/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.core.ParseField;
import io.skylite.core.mapper.Uid;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;

public class MetadataFieldsUtil {
    public static final FieldType DEFAULT_ID_FIELD_TYPE = new FieldType();

    public static Field idField(String id) {
        return new Field(ParseField.CommonMetaFields.ID_FIELD.getPreferredName(), Uid.encodeId(id), (IndexableFieldType)DEFAULT_ID_FIELD_TYPE);
    }

    public static Field versionField() {
        return new NumericDocValuesField(ParseField.CommonMetaFields.VERSION_FIELD.getPreferredName(), -1L);
    }

    static {
        DEFAULT_ID_FIELD_TYPE.setTokenized(false);
        DEFAULT_ID_FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
        DEFAULT_ID_FIELD_TYPE.setStored(true);
        DEFAULT_ID_FIELD_TYPE.setOmitNorms(true);
        DEFAULT_ID_FIELD_TYPE.freeze();
    }
}

