/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.core.common.time.DateFormatter;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.analysis.IndexAnalyzers;
import io.skylite.core.mapper.ContentPath;
import io.skylite.core.mapper.DynamicRuntimeFieldsBuilder;
import io.skylite.core.mapper.LuceneDocument;
import io.skylite.core.mapper.Mapper;
import io.skylite.core.mapper.MappingLookup;
import io.skylite.core.mapper.MappingParserContext;
import io.skylite.core.mapper.MetadataFieldMapper;
import io.skylite.core.mapper.ObjectMapper;
import io.skylite.core.mapper.RootObjectMapper;
import io.skylite.core.mapper.RuntimeFieldType;
import io.skylite.core.mapper.SequenceIDFields;
import io.skylite.core.mapper.SourceToParse;
import io.skylite.core.xcontent.XContentParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.document.Field;

public abstract class ParseContext {
    protected final MappingLookup mappingLookup;
    protected final IndexSettings indexSettings;
    protected final IndexAnalyzers indexAnalyzers;
    protected final Function<DateFormatter, MappingParserContext> parserContextFunction;
    protected final SourceToParse sourceToParse;
    protected final Set<String> ignoredFields;
    protected final Set<String> fieldNamesField;
    protected final Set<String> newFieldsSeen;
    protected final List<Mapper> dynamicMappers;
    protected final Map<String, ObjectMapper> dynamicObjectMappers;
    protected final List<RuntimeFieldType> dynamicRuntimeFields;
    protected final DynamicRuntimeFieldsBuilder dynamicRuntimeFieldsBuilder;
    protected Field version;
    protected SequenceIDFields seqID;

    private ParseContext(ParseContext in) {
        this.mappingLookup = in.mappingLookup;
        this.indexSettings = in.indexSettings;
        this.indexAnalyzers = in.indexAnalyzers;
        this.parserContextFunction = in.parserContextFunction;
        this.sourceToParse = in.sourceToParse;
        this.ignoredFields = in.ignoredFields;
        this.fieldNamesField = in.fieldNamesField;
        this.newFieldsSeen = in.newFieldsSeen;
        this.dynamicMappers = in.dynamicMappers;
        this.dynamicObjectMappers = in.dynamicObjectMappers;
        this.dynamicRuntimeFields = in.dynamicRuntimeFields;
        this.dynamicRuntimeFieldsBuilder = in.dynamicRuntimeFieldsBuilder;
        this.version = in.version;
        this.seqID = in.seqID;
    }

    protected ParseContext(MappingLookup mappingLookup, IndexSettings indexSettings, IndexAnalyzers indexAnalyzers, Function<DateFormatter, MappingParserContext> parserContextFunction, SourceToParse source, DynamicRuntimeFieldsBuilder dynamicRuntimeFieldsBuilder) {
        this.mappingLookup = mappingLookup;
        this.indexSettings = indexSettings;
        this.indexAnalyzers = indexAnalyzers;
        this.parserContextFunction = parserContextFunction;
        this.sourceToParse = source;
        this.ignoredFields = new HashSet<String>();
        this.fieldNamesField = new HashSet<String>();
        this.newFieldsSeen = new HashSet<String>();
        this.dynamicMappers = new ArrayList<Mapper>();
        this.dynamicObjectMappers = new HashMap<String, ObjectMapper>();
        this.dynamicRuntimeFields = new ArrayList<RuntimeFieldType>();
        this.version = null;
        this.dynamicRuntimeFieldsBuilder = dynamicRuntimeFieldsBuilder;
    }

    public final void addFieldToFieldNamesField(String field) {
        this.fieldNamesField.add(field);
    }

    public final Collection<String> getFieldsInFieldNamesField() {
        return Collections.unmodifiableCollection(this.fieldNamesField);
    }

    public abstract Iterable<LuceneDocument> nonRootDocuments();

    public final void addIgnoredField(String field) {
        this.ignoredFields.add(field);
    }

    public final Collection<String> getIgnoredFields() {
        return Collections.unmodifiableCollection(this.ignoredFields);
    }

    public MappingParserContext dynamicTemplateParserContext(DateFormatter dateFormatter) {
        return this.parserContextFunction.apply(dateFormatter);
    }

    public final ParseContext createCopyToContext() {
        return new FilterParseContext(this, this){

            @Override
            public boolean isWithinCopyTo() {
                return true;
            }
        };
    }

    public boolean isWithinCopyTo() {
        return false;
    }

    public final ParseContext createMultiFieldContext() {
        return new FilterParseContext(this, this){

            @Override
            public boolean isWithinMultiFields() {
                return true;
            }
        };
    }

    public final ParseContext createNestedContext(String fullPath) {
        LuceneDocument doc = new LuceneDocument(fullPath, this.doc());
        this.addDoc(doc);
        return this.switchDoc(doc);
    }

    public final ParseContext switchDoc(final LuceneDocument document) {
        return new FilterParseContext(this, this){

            @Override
            public LuceneDocument doc() {
                return document;
            }
        };
    }

    public final ParseContext overridePath(final ContentPath path) {
        return new FilterParseContext(this, this){

            @Override
            public ContentPath path() {
                return path;
            }
        };
    }

    public boolean isWithinMultiFields() {
        return false;
    }

    public final IndexSettings indexSettings() {
        return this.indexSettings;
    }

    public final SourceToParse sourceToParse() {
        return this.sourceToParse;
    }

    public abstract ContentPath path();

    public abstract XContentParser parser();

    public abstract LuceneDocument rootDoc();

    public abstract LuceneDocument doc();

    protected abstract void addDoc(LuceneDocument var1);

    public RootObjectMapper root() {
        return this.mappingLookup.getMapping().getRoot();
    }

    public final MappingLookup mappingLookup() {
        return this.mappingLookup;
    }

    public final MetadataFieldMapper getMetadataMapper(String mapperName) {
        return this.mappingLookup.getMapping().getMetadataMapperByName(mapperName);
    }

    public final IndexAnalyzers indexAnalyzers() {
        return this.indexAnalyzers;
    }

    public final Field version() {
        return this.version;
    }

    public final void version(Field version) {
        this.version = version;
    }

    public final SequenceIDFields seqID() {
        return this.seqID;
    }

    public final void seqID(SequenceIDFields seqID) {
        this.seqID = seqID;
    }

    public final ParseContext createExternalValueContext(final Object externalValue) {
        return new FilterParseContext(this, this){

            @Override
            public boolean externalValueSet() {
                return true;
            }

            @Override
            public Object externalValue() {
                return externalValue;
            }
        };
    }

    public boolean externalValueSet() {
        return false;
    }

    public Object externalValue() {
        throw new IllegalStateException("External value is not set");
    }

    public final <T> T parseExternalValue(Class<T> clazz) {
        if (!this.externalValueSet() || this.externalValue() == null) {
            return null;
        }
        if (!clazz.isInstance(this.externalValue())) {
            throw new IllegalArgumentException("illegal external value class [" + this.externalValue().getClass().getName() + "]. Should be " + clazz.getName());
        }
        return clazz.cast(this.externalValue());
    }

    public final void addDynamicMapper(Mapper mapper) {
        if (this.mappingLookup.getMapper(mapper.name()) == null && !this.mappingLookup.objectMappers().containsKey(mapper.name()) && this.newFieldsSeen.add(mapper.name())) {
            this.mappingLookup.checkFieldLimit(this.indexSettings.getMappingTotalFieldsLimit(), this.newFieldsSeen.size());
        }
        if (mapper instanceof ObjectMapper) {
            this.dynamicObjectMappers.put(mapper.name(), (ObjectMapper)mapper);
        }
        this.dynamicMappers.add(mapper);
    }

    public final ObjectMapper getObjectMapper(String name) {
        return this.dynamicObjectMappers.get(name);
    }

    public final List<Mapper> getDynamicMappers() {
        return this.dynamicMappers;
    }

    public abstract void incrementFieldCurrentDepth();

    public abstract void decrementFieldCurrentDepth();

    public abstract void checkFieldDepthLimit();

    public abstract void incrementFieldArrayDepth();

    public abstract void decrementFieldArrayDepth();

    public abstract void checkFieldArrayDepthLimit();

    public final void addDynamicRuntimeField(RuntimeFieldType runtimeField) {
        this.dynamicRuntimeFields.add(runtimeField);
    }

    public final List<RuntimeFieldType> getDynamicRuntimeFields() {
        return Collections.unmodifiableList(this.dynamicRuntimeFields);
    }

    public abstract DynamicRuntimeFieldsBuilder getDynamicRuntimeFieldsBuilder();

    private static class FilterParseContext
    extends ParseContext {
        private final ParseContext in;

        private FilterParseContext(ParseContext in) {
            super(in);
            this.in = in;
        }

        @Override
        public Iterable<LuceneDocument> nonRootDocuments() {
            return this.in.nonRootDocuments();
        }

        @Override
        public boolean isWithinCopyTo() {
            return this.in.isWithinCopyTo();
        }

        @Override
        public boolean isWithinMultiFields() {
            return this.in.isWithinMultiFields();
        }

        @Override
        public ContentPath path() {
            return this.in.path();
        }

        @Override
        public XContentParser parser() {
            return this.in.parser();
        }

        @Override
        public LuceneDocument rootDoc() {
            return this.in.rootDoc();
        }

        @Override
        public LuceneDocument doc() {
            return this.in.doc();
        }

        @Override
        protected void addDoc(LuceneDocument doc) {
            this.in.addDoc(doc);
        }

        @Override
        public boolean externalValueSet() {
            return this.in.externalValueSet();
        }

        @Override
        public Object externalValue() {
            return this.in.externalValue();
        }

        @Override
        public DynamicRuntimeFieldsBuilder getDynamicRuntimeFieldsBuilder() {
            return this.in.getDynamicRuntimeFieldsBuilder();
        }

        @Override
        public void incrementFieldCurrentDepth() {
            this.in.incrementFieldCurrentDepth();
        }

        @Override
        public void decrementFieldCurrentDepth() {
            this.in.decrementFieldCurrentDepth();
        }

        @Override
        public void checkFieldDepthLimit() {
            this.in.checkFieldDepthLimit();
        }

        @Override
        public void incrementFieldArrayDepth() {
            this.in.incrementFieldArrayDepth();
        }

        @Override
        public void decrementFieldArrayDepth() {
            this.in.decrementFieldArrayDepth();
        }

        @Override
        public void checkFieldArrayDepthLimit() {
            this.in.checkFieldArrayDepthLimit();
        }
    }
}

