/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.core.ParseField;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.lucene.Lucene;
import io.skylite.core.mapper.ContentPath;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.MetadataFieldMapper;
import io.skylite.core.mapper.ParseContext;
import io.skylite.core.mapper.StringFieldType;
import io.skylite.core.mapper.TextSearchInfo;
import io.skylite.core.mapper.ValueFetcher;
import io.skylite.core.search.lookup.SearchLookup;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;

public class RoutingFieldMapper
extends MetadataFieldMapper {
    public static final String CONTENT_TYPE = ParseField.CommonMetaFields.ROUTING_FIELD.getPreferredName();
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.ConfigurableTypeParser(c -> new RoutingFieldMapper(false), c -> new Builder());
    private final boolean required;

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder().init(this);
    }

    private static RoutingFieldMapper toType(FieldMapper in) {
        return (RoutingFieldMapper)in;
    }

    private RoutingFieldMapper(boolean required) {
        super(RoutingFieldType.INSTANCE, Lucene.KEYWORD_ANALYZER);
        this.required = required;
    }

    public boolean required() {
        return this.required;
    }

    @Override
    public void preParse(ParseContext context) {
        String routing = context.sourceToParse().routing();
        if (routing != null) {
            context.doc().add((IndexableField)new Field(this.fieldType().name(), (CharSequence)routing, (IndexableFieldType)Defaults.FIELD_TYPE));
            context.addFieldToFieldNamesField(this.fieldType().name());
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static class Builder
    extends MetadataFieldMapper.Builder {
        final FieldMapper.Parameter<Boolean> required = FieldMapper.Parameter.boolParam("required", false, m -> RoutingFieldMapper.toType((FieldMapper)m).required, false);

        protected Builder() {
            super(ParseField.CommonMetaFields.ROUTING_FIELD.getPreferredName());
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Collections.singletonList(this.required);
        }

        @Override
        public RoutingFieldMapper build(ContentPath contentPath) {
            return new RoutingFieldMapper(this.required.getValue());
        }
    }

    static final class RoutingFieldType
    extends StringFieldType {
        static RoutingFieldType INSTANCE = new RoutingFieldType();

        private RoutingFieldType() {
            super(ParseField.CommonMetaFields.ROUTING_FIELD.getPreferredName(), true, true, false, TextSearchInfo.SIMPLE_MATCH_ONLY, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return CONTENT_TYPE;
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup lookup, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for internal field [" + this.name() + "].");
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();
        public static final boolean REQUIRED = false;

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

