/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.core.ParseField;
import io.skylite.core.mapper.LuceneDocument;
import java.util.Objects;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.IndexableField;

public class SequenceIDFields {
    public final Field seqNo;
    public final Field seqNoDocValue;
    public final Field primaryTerm;
    public final Field tombstoneField;

    public SequenceIDFields(Field seqNo, Field seqNoDocValue, Field primaryTerm, Field tombstoneField) {
        Objects.requireNonNull(seqNo, "sequence number field cannot be null");
        Objects.requireNonNull(seqNoDocValue, "sequence number dv field cannot be null");
        Objects.requireNonNull(primaryTerm, "primary term field cannot be null");
        this.seqNo = seqNo;
        this.seqNoDocValue = seqNoDocValue;
        this.primaryTerm = primaryTerm;
        this.tombstoneField = tombstoneField;
    }

    public void addFields(LuceneDocument document) {
        document.add((IndexableField)this.seqNo);
        document.add((IndexableField)this.seqNoDocValue);
        document.add((IndexableField)this.primaryTerm);
        if (this.tombstoneField != null) {
            document.add((IndexableField)this.tombstoneField);
        }
    }

    public static SequenceIDFields emptySeqID() {
        return new SequenceIDFields((Field)new LongPoint(ParseField.CommonMetaFields.SEQ_NO_FIELD.getPreferredName(), new long[]{-2L}), (Field)new NumericDocValuesField(ParseField.CommonMetaFields.SEQ_NO_FIELD.getPreferredName(), -2L), (Field)new NumericDocValuesField(ParseField.CommonMetaFields.PRIMARY_TERM_FIELD.getPreferredName(), 0L), null);
    }

    public static SequenceIDFields tombstone() {
        return new SequenceIDFields((Field)new LongPoint(ParseField.CommonMetaFields.SEQ_NO_FIELD.getPreferredName(), new long[]{-2L}), (Field)new NumericDocValuesField(ParseField.CommonMetaFields.SEQ_NO_FIELD.getPreferredName(), -2L), (Field)new NumericDocValuesField(ParseField.CommonMetaFields.PRIMARY_TERM_FIELD.getPreferredName(), 0L), (Field)new NumericDocValuesField(ParseField.CommonMetaFields.TOMBSTONE_FIELD.getPreferredName(), 1L));
    }
}

