/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.common.Nullable;
import io.skylite.common.collect.Tuple;
import io.skylite.core.ParseField;
import io.skylite.core.common.Strings;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.BytesStreamOutput;
import io.skylite.core.common.util.CollectionUtils;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.QueryShardException;
import io.skylite.core.mapper.ContentPath;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.MetadataFieldMapper;
import io.skylite.core.mapper.ParseContext;
import io.skylite.core.mapper.TextSearchInfo;
import io.skylite.core.mapper.ValueFetcher;
import io.skylite.core.search.lookup.SearchLookup;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.util.XContentMapValuesUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;

public class SourceFieldMapper
extends MetadataFieldMapper {
    public static final String RECOVERY_SOURCE_NAME = "_recovery_source";
    public static final String CONTENT_TYPE = "_source";
    private final Function<Map<String, ?>, Map<String, Object>> filter;
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.ConfigurableTypeParser(c -> new SourceFieldMapper(), c -> new Builder());
    private final boolean enabled;
    private final boolean complete;
    private final String[] includes;
    private final String[] excludes;

    private static SourceFieldMapper toType(FieldMapper in) {
        return (SourceFieldMapper)in;
    }

    private SourceFieldMapper() {
        this(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
    }

    private SourceFieldMapper(boolean enabled, String[] includes, String[] excludes) {
        super(new SourceFieldType(enabled));
        this.enabled = enabled;
        this.includes = includes;
        this.excludes = excludes;
        boolean filtered = !CollectionUtils.isEmpty(includes) || !CollectionUtils.isEmpty(excludes);
        this.filter = enabled && filtered ? XContentMapValuesUtil.filter(includes, excludes) : null;
        this.complete = enabled && CollectionUtils.isEmpty(includes) && CollectionUtils.isEmpty(excludes);
    }

    public boolean enabled() {
        return this.enabled;
    }

    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        BytesRef ref;
        MediaType contentType;
        BytesReference originalSource = context.sourceToParse().source();
        BytesReference adaptedSource = this.applyFilters(originalSource, contentType = context.sourceToParse().getMediaType());
        if (adaptedSource != null) {
            ref = adaptedSource.toBytesRef();
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), ref.bytes, ref.offset, ref.length));
        }
        if (originalSource != null && adaptedSource != originalSource) {
            ref = originalSource.toBytesRef();
            context.doc().add((IndexableField)new StoredField(RECOVERY_SOURCE_NAME, ref.bytes, ref.offset, ref.length));
            context.doc().add((IndexableField)new NumericDocValuesField(RECOVERY_SOURCE_NAME, 1L));
        }
    }

    @Nullable
    public BytesReference applyFilters(@Nullable BytesReference originalSource, @Nullable MediaType contentType) throws IOException {
        if (this.enabled && originalSource != null) {
            if (this.filter != null) {
                Tuple<? extends MediaType, Map<String, Object>> mapTuple = XContentHelper.convertToMap(originalSource, true, contentType);
                Map<String, Object> filteredSource = this.filter.apply((Map)mapTuple.v2());
                BytesStreamOutput bStream = new BytesStreamOutput();
                MediaType actualContentType = (MediaType)mapTuple.v1();
                XContentBuilder builder = MediaTypeRegistry.contentBuilder(actualContentType, bStream).map(filteredSource);
                builder.close();
                return bStream.bytes();
            }
            return originalSource;
        }
        return null;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder().init(this);
    }

    public static class Defaults {
        public static final String NAME = ParseField.CommonMetaFields.SOURCE_FIELD.getPreferredName();
        public static final boolean ENABLED = true;
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }

    static final class SourceFieldType
    extends MappedFieldType {
        private SourceFieldType(boolean enabled) {
            super(ParseField.CommonMetaFields.SOURCE_FIELD.getPreferredName(), false, enabled, false, TextSearchInfo.NONE, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return SourceFieldMapper.CONTENT_TYPE;
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup lookup, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for internal field [" + this.name() + "].");
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            throw new QueryShardException(context.getFullyQualifiedIndex(), "The _source field is not searchable", new Object[0]);
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context.getFullyQualifiedIndex(), "The _source field is not searchable", new Object[0]);
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> enabled = FieldMapper.Parameter.boolParam("enabled", false, m -> SourceFieldMapper.toType((FieldMapper)m).enabled, true);
        private final FieldMapper.Parameter<List<String>> includes = FieldMapper.Parameter.stringArrayParam("includes", false, m -> Arrays.asList(SourceFieldMapper.toType((FieldMapper)m).includes), Collections.emptyList());
        private final FieldMapper.Parameter<List<String>> excludes = FieldMapper.Parameter.stringArrayParam("excludes", false, m -> Arrays.asList(SourceFieldMapper.toType((FieldMapper)m).excludes), Collections.emptyList());

        public Builder() {
            super(Defaults.NAME);
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.enabled, this.includes, this.excludes);
        }

        @Override
        public SourceFieldMapper build(ContentPath contentPath) {
            return new SourceFieldMapper(this.enabled.getValue(), this.includes.getValue().toArray(new String[0]), this.excludes.getValue().toArray(new String[0]));
        }
    }
}

