/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.common.Nullable;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.mapper.ValueFetcher;
import io.skylite.core.search.lookup.SourceLookup;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class SourceValueFetcher
implements ValueFetcher {
    private final Set<String> sourcePaths;
    @Nullable
    private final Object nullValue;

    public SourceValueFetcher(String fieldName, QueryShardContext context) {
        this(fieldName, context, null);
    }

    public SourceValueFetcher(String fieldName, QueryShardContext context, Object nullValue) {
        this.sourcePaths = context.sourcePath(fieldName);
        this.nullValue = nullValue;
    }

    @Override
    public List<Object> fetchValues(SourceLookup lookup) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String path : this.sourcePaths) {
            Object sourceValue = lookup.extractValue(path, this.nullValue);
            if (sourceValue == null) {
                return List.of();
            }
            ArrayDeque<Object> queue = new ArrayDeque<Object>();
            queue.add(sourceValue);
            while (!queue.isEmpty()) {
                Object value = queue.poll();
                if (value instanceof List) {
                    queue.addAll((List)value);
                    continue;
                }
                Object parsedValue = this.parseSourceValue(value);
                if (parsedValue == null) continue;
                values.add(parsedValue);
            }
        }
        return values;
    }

    protected abstract Object parseSourceValue(Object var1);

    public static SourceValueFetcher identity(String fieldName, QueryShardContext context, String format) {
        if (format != null) {
            throw new IllegalArgumentException("Field [" + fieldName + "] doesn't support formats.");
        }
        return new SourceValueFetcher(fieldName, context){

            @Override
            protected Object parseSourceValue(Object value) {
                return value;
            }
        };
    }

    public static SourceValueFetcher toString(String fieldName, QueryShardContext context, String format) {
        if (format != null) {
            throw new IllegalArgumentException("Field [" + fieldName + "] doesn't support formats.");
        }
        return new SourceValueFetcher(fieldName, context){

            @Override
            protected Object parseSourceValue(Object value) {
                return value.toString();
            }
        };
    }
}

