/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.lucene.BytesRefs;
import io.skylite.core.lucene.search.AutomatonQueries;
import io.skylite.core.mapper.SimpleMappedFieldType;
import io.skylite.core.mapper.TextSearchInfo;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;

public abstract class TermBasedFieldType
extends SimpleMappedFieldType {
    public TermBasedFieldType(String name, boolean isSearchable, boolean isStored, boolean hasDocValues, TextSearchInfo textSearchInfo, Map<String, String> meta) {
        super(name, isSearchable, isStored, hasDocValues, textSearchInfo, meta);
    }

    protected BytesRef indexedValueForSearch(Object value) {
        return BytesRefs.toBytesRef(value);
    }

    @Override
    public Query termQueryCaseInsensitive(Object value, QueryShardContext context) {
        this.failIfNotIndexed();
        return AutomatonQueries.caseInsensitiveTermQuery(new Term(this.name(), this.indexedValueForSearch(value)));
    }

    @Override
    public Query termQuery(Object value, QueryShardContext context) {
        this.failIfNotIndexed();
        return new TermQuery(new Term(this.name(), this.indexedValueForSearch(value)));
    }

    @Override
    public Query termsQuery(List<?> values, QueryShardContext context) {
        this.failIfNotIndexed();
        List<BytesRef> bytesRefs = values.stream().map(this::indexedValueForSearch).toList();
        return new TermInSetQuery(this.name(), bytesRefs);
    }
}

