/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper.dynamic;

import io.skylite.core.mapper.MapperParsingException;
import io.skylite.core.mapper.dynamic.DynamicTemplate;
import io.skylite.core.mapper.dynamic.MatchType;
import io.skylite.core.mapper.dynamic.XContentFieldType;
import java.util.Map;

public class TemplateParser {
    public static DynamicTemplate parse(String name, Map<String, Object> conf) throws MapperParsingException {
        String match = null;
        String pathMatch = null;
        String unmatch = null;
        String pathUnmatch = null;
        Map mapping = null;
        String matchMappingType = null;
        String matchPattern = MatchType.SIMPLE.toString();
        block18: for (Map.Entry<String, Object> entry : conf.entrySet()) {
            String propName;
            switch (propName = entry.getKey()) {
                case "match": {
                    match = entry.getValue().toString();
                    continue block18;
                }
                case "path_match": {
                    pathMatch = entry.getValue().toString();
                    continue block18;
                }
                case "unmatch": {
                    unmatch = entry.getValue().toString();
                    continue block18;
                }
                case "path_unmatch": {
                    pathUnmatch = entry.getValue().toString();
                    continue block18;
                }
                case "match_mapping_type": {
                    matchMappingType = entry.getValue().toString();
                    continue block18;
                }
                case "match_pattern": {
                    matchPattern = entry.getValue().toString();
                    continue block18;
                }
                case "mapping": {
                    mapping = (Map)entry.getValue();
                    continue block18;
                }
            }
            throw new IllegalArgumentException("Illegal dynamic template parameter: [" + propName + "]");
        }
        if (match == null && pathMatch == null && matchMappingType == null) {
            throw new MapperParsingException("template must have match, path_match, or match_mapping_type set " + conf.toString());
        }
        if (mapping == null) {
            throw new MapperParsingException("template must have mapping set");
        }
        XContentFieldType fieldType = TemplateParser.parseFieldType(matchMappingType);
        MatchType matchType = MatchType.fromString(matchPattern);
        TemplateParser.validatePatterns(name, matchType, pathMatch, match, pathUnmatch, unmatch);
        return new DynamicTemplate(name, pathMatch, pathUnmatch, match, unmatch, fieldType, matchType, mapping);
    }

    private static XContentFieldType parseFieldType(String value) {
        return value == null || "*".equals(value) ? null : XContentFieldType.fromString(value);
    }

    private static void validatePatterns(String name, MatchType matchType, String ... patterns) {
        for (String pattern : patterns) {
            if (pattern == null) continue;
            try {
                matchType.matches(pattern, "");
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Pattern [" + pattern + "] of type [" + String.valueOf((Object)matchType) + "] is invalid. Cannot create dynamic template [" + name + "].", e);
            }
        }
    }
}

