/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper.dynamic;

import io.skylite.core.ParseField;
import java.util.HashMap;
import java.util.Map;

public enum XContentFieldType {
    OBJECT("object", ParseField.CoreTypes.OBJECT_FIELD.getPreferredName()),
    STRING("string", ParseField.CoreTypes.TEXT_FIELD.getPreferredName()),
    LONG("long", ParseField.CoreTypes.LONG_FIELD.getPreferredName()),
    DOUBLE("double", ParseField.CoreTypes.FLOAT_FIELD.getPreferredName()),
    BOOLEAN("boolean", ParseField.CoreTypes.BOOLEAN_FIELD.getPreferredName()),
    DATE("date", ParseField.CoreTypes.DATE_FIELD.getPreferredName()),
    BINARY("binary", ParseField.CoreTypes.BINARY_FIELD.getPreferredName());

    private static final Map<String, XContentFieldType> NAME_TO_TYPE_MAP;
    private final String name;
    private final String defaultMappingType;

    private XContentFieldType(String name, String defaultMappingType) {
        this.name = name;
        this.defaultMappingType = defaultMappingType;
    }

    public String getDefaultMappingType() {
        return this.defaultMappingType;
    }

    public String toString() {
        return this.name;
    }

    public static XContentFieldType fromString(String value) {
        XContentFieldType type = NAME_TO_TYPE_MAP.get(value);
        if (type == null) {
            throw new IllegalArgumentException("No field type matched on [" + value + "], possible values are " + String.valueOf(NAME_TO_TYPE_MAP.keySet()));
        }
        return type;
    }

    static {
        NAME_TO_TYPE_MAP = new HashMap<String, XContentFieldType>();
        for (XContentFieldType type : XContentFieldType.values()) {
            NAME_TO_TYPE_MAP.put(type.name, type);
        }
    }
}

