/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.monitor.jvm;

import io.skylite.common.unit.TimeValue;
import io.skylite.core.monitor.JvmInfo;
import io.skylite.core.monitor.jvm.JvmStats;
import io.skylite.core.service.ReportingService;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JvmService
implements ReportingService<JvmInfo> {
    private static final Logger logger = LogManager.getLogger(JvmService.class);
    private final JvmInfo jvmInfo = JvmInfo.jvmInfo();
    private final TimeValue refreshInterval;
    private JvmStats jvmStats = JvmStats.jvmStats();
    public static final Setting<TimeValue> REFRESH_INTERVAL_SETTING = Setting.timeSetting("monitor.jvm.refresh_interval", TimeValue.timeValueSeconds((long)1L), TimeValue.timeValueSeconds((long)1L), Setting.Property.NodeScope);

    public JvmService(Settings settings) {
        this.refreshInterval = REFRESH_INTERVAL_SETTING.get(settings);
        logger.debug("using refresh_interval [{}]", (Object)this.refreshInterval);
    }

    @Override
    public JvmInfo info() {
        return this.jvmInfo;
    }

    public synchronized JvmStats stats() {
        if (System.currentTimeMillis() - this.jvmStats.getTimestamp() > this.refreshInterval.millis()) {
            this.jvmStats = JvmStats.jvmStats();
        }
        return this.jvmStats;
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(REFRESH_INTERVAL_SETTING);
        }
    }
}

