/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.monitor.os;

import io.skylite.common.SingleObjectCache;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.common.concurrent.SkyliteExecutors;
import io.skylite.core.monitor.os.OsInfo;
import io.skylite.core.monitor.os.OsProbe;
import io.skylite.core.monitor.os.OsStats;
import io.skylite.core.service.ReportingService;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OsService
implements ReportingService<OsInfo> {
    private static final Logger logger = LogManager.getLogger(OsService.class);
    private final OsProbe probe = OsProbe.getInstance();
    private final OsInfo info;
    private final SingleObjectCache<OsStats> osStatsCache;
    public static final Setting<TimeValue> REFRESH_INTERVAL_SETTING = Setting.timeSetting("monitor.os.refresh_interval", TimeValue.timeValueSeconds((long)1L), TimeValue.timeValueSeconds((long)1L), Setting.Property.NodeScope);

    public OsService(Settings settings) throws IOException {
        TimeValue refreshInterval = REFRESH_INTERVAL_SETTING.get(settings);
        this.info = this.probe.osInfo(refreshInterval.millis(), SkyliteExecutors.allocatedProcessors(settings));
        this.osStatsCache = new OsStatsCache(refreshInterval, this.probe.osStats());
        logger.debug("using refresh_interval [{}]", (Object)refreshInterval);
    }

    @Override
    public OsInfo info() {
        return this.info;
    }

    public synchronized OsStats stats() {
        return (OsStats)this.osStatsCache.getOrRefresh();
    }

    private class OsStatsCache
    extends SingleObjectCache<OsStats> {
        OsStatsCache(TimeValue interval, OsStats initValue) {
            super(interval, (Object)initValue);
        }

        protected OsStats refresh() {
            return OsService.this.probe.osStats();
        }
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(REFRESH_INTERVAL_SETTING);
        }
    }
}

