/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.node;

import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.set.Sets;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.node.ResponseCollectorService;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class AdaptiveSelectionStats
implements Writeable,
ToXContentFragment {
    private final Map<String, Long> clientOutgoingConnections;
    private final Map<String, ResponseCollectorService.ComputedNodeStats> nodeComputedStats;

    public AdaptiveSelectionStats(Map<String, Long> clientConnections, Map<String, ResponseCollectorService.ComputedNodeStats> nodeComputedStats) {
        this.clientOutgoingConnections = clientConnections;
        this.nodeComputedStats = nodeComputedStats;
    }

    public AdaptiveSelectionStats(StreamInput in) throws IOException {
        this.clientOutgoingConnections = in.readMap(StreamInput::readString, StreamInput::readLong);
        this.nodeComputedStats = in.readMap(StreamInput::readString, ResponseCollectorService.ComputedNodeStats::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.clientOutgoingConnections, StreamOutput::writeString, StreamOutput::writeLong);
        out.writeMap(this.nodeComputedStats, StreamOutput::writeString, (stream, stats) -> stats.writeTo(stream));
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("adaptive_selection");
        Set allNodeIds = Sets.union(this.clientOutgoingConnections.keySet(), this.nodeComputedStats.keySet());
        for (String nodeId : allNodeIds) {
            builder.startObject(nodeId);
            ResponseCollectorService.ComputedNodeStats stats = this.nodeComputedStats.get(nodeId);
            if (stats != null) {
                long outgoingSearches = this.clientOutgoingConnections.getOrDefault(nodeId, 0L);
                builder.field("outgoing_searches", outgoingSearches);
                builder.field("avg_queue_size", stats.queueSize);
                if (builder.humanReadable()) {
                    builder.field("avg_service_time", new TimeValue((long)stats.serviceTime, TimeUnit.NANOSECONDS).toString());
                }
                builder.field("avg_service_time_ns", (long)stats.serviceTime);
                if (builder.humanReadable()) {
                    builder.field("avg_response_time", new TimeValue((long)stats.responseTime, TimeUnit.NANOSECONDS).toString());
                }
                builder.field("avg_response_time_ns", (long)stats.responseTime);
                builder.field("rank", String.format(Locale.ROOT, "%.1f", stats.rank(outgoingSearches)));
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public Map<String, Long> getOutgoingConnections() {
        return this.clientOutgoingConnections;
    }

    public Map<String, ResponseCollectorService.ComputedNodeStats> getComputedStats() {
        return this.nodeComputedStats;
    }

    public Map<String, Double> getRanks() {
        return this.nodeComputedStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ResponseCollectorService.ComputedNodeStats)e.getValue()).rank(this.clientOutgoingConnections.getOrDefault(e.getKey(), 0L))));
    }
}

