/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.node;

import io.skylite.core.settings.Setting;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SNIHostName;

public final class NodeSettings {
    public static final Setting<Boolean> NODE_LOCAL_STORAGE_SETTING = Setting.boolSetting("node.local_storage", true, Setting.Property.Deprecated, Setting.Property.NodeScope);
    public static final Setting.AffixSetting<String> NODE_ATTRIBUTES = Setting.prefixKeySetting("node.attr.", key -> new Setting<String>((String)key, "", value -> {
        if (value.length() > 0 && (Character.isWhitespace(value.charAt(0)) || Character.isWhitespace(value.charAt(value.length() - 1)))) {
            throw new IllegalArgumentException(key + " cannot have leading or trailing whitespace [" + value + "]");
        }
        if (value.length() > 0 && "node.attr.server_name".equals(key)) {
            try {
                new SNIHostName((String)value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("invalid node.attr.server_name [" + value + "]", e);
            }
        }
        return value;
    }, Setting.Property.NodeScope));

    private NodeSettings() {
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(NODE_ATTRIBUTES, NODE_LOCAL_STORAGE_SETTING);
        }
    }
}

