/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications;

import io.skylite.common.action.ActionListener;
import io.skylite.core.client.SecureClientWrapper;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.action.BaseResponse;
import io.skylite.core.notifications.action.CreateNotificationConfigRequest;
import io.skylite.core.notifications.action.CreateNotificationConfigResponse;
import io.skylite.core.notifications.action.DeleteNotificationConfigRequest;
import io.skylite.core.notifications.action.DeleteNotificationConfigResponse;
import io.skylite.core.notifications.action.GetChannelListRequest;
import io.skylite.core.notifications.action.GetChannelListResponse;
import io.skylite.core.notifications.action.GetNotificationConfigRequest;
import io.skylite.core.notifications.action.GetNotificationConfigResponse;
import io.skylite.core.notifications.action.GetPluginFeaturesRequest;
import io.skylite.core.notifications.action.GetPluginFeaturesResponse;
import io.skylite.core.notifications.action.LegacyPublishNotificationRequest;
import io.skylite.core.notifications.action.LegacyPublishNotificationResponse;
import io.skylite.core.notifications.action.NotificationsActions;
import io.skylite.core.notifications.action.SendNotificationRequest;
import io.skylite.core.notifications.action.SendNotificationResponse;
import io.skylite.core.notifications.action.UpdateNotificationConfigRequest;
import io.skylite.core.notifications.action.UpdateNotificationConfigResponse;
import io.skylite.core.notifications.model.ChannelMessage;
import io.skylite.core.notifications.model.EventSource;
import java.util.List;
import java.util.function.Function;

public final class NotificationsPluginInterface {
    private NotificationsPluginInterface() {
    }

    public static NotificationsPluginInterface getInstance() {
        return Holder.INSTANCE;
    }

    public static void createNotificationConfig(NodeClient client, CreateNotificationConfigRequest request, ActionListener<CreateNotificationConfigResponse> listener) {
        client.execute(NotificationsActions.CREATE_NOTIFICATION_CONFIG_ACTION_TYPE, request, NotificationsPluginInterface.wrapActionListener(listener, r -> Writeable.recreateObject(r, CreateNotificationConfigResponse::new)));
    }

    public static void updateNotificationConfig(NodeClient client, UpdateNotificationConfigRequest request, ActionListener<UpdateNotificationConfigResponse> listener) {
        client.execute(NotificationsActions.UPDATE_NOTIFICATION_CONFIG_ACTION_TYPE, request, NotificationsPluginInterface.wrapActionListener(listener, r -> Writeable.recreateObject(r, UpdateNotificationConfigResponse::new)));
    }

    public static void deleteNotificationConfig(NodeClient client, DeleteNotificationConfigRequest request, ActionListener<DeleteNotificationConfigResponse> listener) {
        client.execute(NotificationsActions.DELETE_NOTIFICATION_CONFIG_ACTION_TYPE, request, NotificationsPluginInterface.wrapActionListener(listener, r -> Writeable.recreateObject(r, DeleteNotificationConfigResponse::new)));
    }

    public static void getNotificationConfig(NodeClient client, GetNotificationConfigRequest request, ActionListener<GetNotificationConfigResponse> listener) {
        client.execute(NotificationsActions.GET_NOTIFICATION_CONFIG_ACTION_TYPE, request, NotificationsPluginInterface.wrapActionListener(listener, r -> Writeable.recreateObject(r, GetNotificationConfigResponse::new)));
    }

    public static void getPluginFeatures(NodeClient client, GetPluginFeaturesRequest request, ActionListener<GetPluginFeaturesResponse> listener) {
        client.execute(NotificationsActions.GET_PLUGIN_FEATURES_ACTION_TYPE, request, NotificationsPluginInterface.wrapActionListener(listener, r -> Writeable.recreateObject(r, GetPluginFeaturesResponse::new)));
    }

    public static void getChannelList(NodeClient client, GetChannelListRequest request, ActionListener<GetChannelListResponse> listener) {
        client.execute(NotificationsActions.GET_CHANNEL_LIST_ACTION_TYPE, request, NotificationsPluginInterface.wrapActionListener(listener, r -> Writeable.recreateObject(r, GetChannelListResponse::new)));
    }

    public static void sendNotification(NodeClient client, EventSource eventSource, ChannelMessage channelMessage, List<String> channelIds, ActionListener<SendNotificationResponse> listener) {
        ThreadContext threadContext = client.threadPool().getThreadContext();
        String securityUserInfo = (String)threadContext.getTransient("_opendistro_security_user_info");
        SecureClientWrapper wrapper = new SecureClientWrapper(client);
        wrapper.execute(NotificationsActions.SEND_NOTIFICATION_ACTION_TYPE, new SendNotificationRequest(eventSource, channelMessage, channelIds, securityUserInfo), NotificationsPluginInterface.wrapActionListener(listener, r -> Writeable.recreateObject(r, SendNotificationResponse::new)));
    }

    public static void publishLegacyNotification(NodeClient client, LegacyPublishNotificationRequest request, ActionListener<LegacyPublishNotificationResponse> listener) {
        client.execute(NotificationsActions.LEGACY_PUBLISH_NOTIFICATION_ACTION_TYPE, request, NotificationsPluginInterface.wrapActionListener(listener, r -> Writeable.recreateObject(r, LegacyPublishNotificationResponse::new)));
    }

    private static <T extends BaseResponse> ActionListener<T> wrapActionListener(final ActionListener<T> listener, final Function<Writeable, T> recreate) {
        return new ActionListener(){

            public void onResponse(Object response) {
                BaseResponse out;
                try {
                    out = (BaseResponse)response;
                }
                catch (ClassCastException e) {
                    out = (BaseResponse)recreate.apply((Writeable)response);
                }
                listener.onResponse((Object)out);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        };
    }

    private static class Holder {
        private static final NotificationsPluginInterface INSTANCE = new NotificationsPluginInterface();

        private Holder() {
        }
    }
}

