/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.action;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.util.ValidationUtils;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.action.CreateNotificationConfigResponse;
import io.skylite.core.notifications.model.NotificationConfig;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.core.xcontent.util.XContentUtils;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreateNotificationConfigRequest
extends ActionRequest
implements ToXContentObject {
    private static final Logger log = LogManager.getLogger(CreateNotificationConfigResponse.class);
    public static final Writeable.Reader<CreateNotificationConfigRequest> READER = CreateNotificationConfigRequest::new;
    private final String configId;
    private final NotificationConfig notificationConfig;

    public CreateNotificationConfigRequest(NotificationConfig notificationConfig) {
        this(notificationConfig, null);
    }

    public CreateNotificationConfigRequest(NotificationConfig notificationConfig, String configId) {
        this.configId = configId;
        this.notificationConfig = notificationConfig;
    }

    public CreateNotificationConfigRequest(StreamInput in) throws IOException {
        super(in);
        this.configId = in.readOptionalString();
        this.notificationConfig = NotificationConfig.READER.read(in);
    }

    public String getConfigId() {
        return this.configId;
    }

    public NotificationConfig getNotificationConfig() {
        return this.notificationConfig;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        XContentUtils.fieldIfNotNull(builder, "config_id", this.configId);
        builder.field("config", this.notificationConfig);
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.configId);
        this.notificationConfig.writeTo(out);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public static CreateNotificationConfigRequest parse(XContentParser parser) throws IOException {
        return CreateNotificationConfigRequest.parse(parser, null);
    }

    public static CreateNotificationConfigRequest parse(XContentParser parser, String id) throws IOException {
        String configId = id;
        NotificationConfig notificationConfig = null;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "config_id": {
                    configId = parser.textOrNull();
                    continue block8;
                }
                case "config": {
                    notificationConfig = NotificationConfig.parse(parser);
                    continue block8;
                }
            }
            parser.skipChildren();
            log.info("Unexpected field: {}, while parsing CreateNotificationConfigRequest", (Object)fieldName);
        }
        if (notificationConfig == null) {
            throw new IllegalArgumentException("config field absent");
        }
        if (configId != null) {
            ValidationUtils.validateId((String)configId);
        }
        return new CreateNotificationConfigRequest(notificationConfig, configId);
    }
}

