/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.action;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.action.BaseResponse;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreateNotificationConfigResponse
extends BaseResponse {
    private static final Logger log = LogManager.getLogger(CreateNotificationConfigResponse.class);
    public static final Writeable.Reader<CreateNotificationConfigResponse> READER = CreateNotificationConfigResponse::new;
    private final String configId;

    public CreateNotificationConfigResponse(String configId) {
        this.configId = configId;
    }

    public CreateNotificationConfigResponse(StreamInput in) throws IOException {
        super(in);
        this.configId = in.readString();
    }

    public String getConfigId() {
        return this.configId;
    }

    public static CreateNotificationConfigResponse parse(XContentParser parser) throws IOException {
        String configId = null;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            if ("config_id".equals(fieldName)) {
                configId = parser.text();
                continue;
            }
            parser.skipChildren();
            log.info("Unexpected field: {}, while parsing CreateNotificationConfigResponse", (Object)fieldName);
        }
        if (configId == null) {
            throw new IllegalArgumentException("config_id field absent");
        }
        return new CreateNotificationConfigResponse(configId);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.configId);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("config_id", this.configId);
        builder.endObject();
        return builder;
    }
}

