/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.action;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.core.xcontent.util.XContentUtils;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeleteNotificationConfigRequest
extends ActionRequest
implements ToXContentObject {
    private static final Logger log = LogManager.getLogger(DeleteNotificationConfigRequest.class);
    private final Set<String> configIds;
    public static final Writeable.Reader<DeleteNotificationConfigRequest> READER = DeleteNotificationConfigRequest::new;

    public static DeleteNotificationConfigRequest parse(XContentParser parser) throws IOException {
        Set<String> configIds = null;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            if ("config_id_list".equals(fieldName)) {
                List<String> idList = XContentUtils.stringList(parser);
                configIds = Set.copyOf(idList);
                continue;
            }
            parser.skipChildren();
            log.info("Unexpected field: {} while parsing DeleteNotificationConfigRequest", (Object)fieldName);
        }
        if (configIds == null) {
            throw new IllegalArgumentException("config_id_list field absent");
        }
        return new DeleteNotificationConfigRequest(configIds);
    }

    public DeleteNotificationConfigRequest(Set<String> configIds) {
        this.configIds = configIds == null ? Set.of() : Set.copyOf(configIds);
    }

    public DeleteNotificationConfigRequest(StreamInput input) throws IOException {
        super(input);
        List<String> ids = input.readStringList();
        this.configIds = ids == null ? Set.of() : Set.copyOf(ids);
    }

    public Set<String> getConfigIds() {
        return this.configIds;
    }

    @Override
    public void writeTo(StreamOutput output) throws IOException {
        super.writeTo(output);
        output.writeStringCollection(this.configIds);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field("config_id_list", this.configIds).endObject();
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.configIds == null || this.configIds.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"configIds is null or empty", validationException);
        }
        return validationException;
    }
}

