/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.action;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.action.BaseResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeleteNotificationConfigResponse
extends BaseResponse {
    private static final Logger log = LogManager.getLogger(DeleteNotificationConfigResponse.class);
    private final Map<String, RestStatus> configIdToStatus;
    public static final Writeable.Reader<DeleteNotificationConfigResponse> READER = DeleteNotificationConfigResponse::new;

    public static DeleteNotificationConfigResponse parse(XContentParser parser) throws IOException {
        Map<String, RestStatus> configIdToStatus = null;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            if ("delete_response_list".equals(fieldName)) {
                Map<String, String> rawMap = parser.mapStrings();
                configIdToStatus = DeleteNotificationConfigResponse.convertMapStrings(rawMap);
                continue;
            }
            parser.skipChildren();
            log.info("Unexpected field: {} while parsing DeleteNotificationConfigResponse", (Object)fieldName);
        }
        if (configIdToStatus == null) {
            throw new IllegalArgumentException("delete_response_list field absent");
        }
        return new DeleteNotificationConfigResponse(configIdToStatus);
    }

    private static Map<String, RestStatus> convertMapStrings(Map<String, String> inputMap) {
        if (inputMap == null || inputMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, RestStatus> result = new HashMap<String, RestStatus>(inputMap.size());
        for (Map.Entry<String, String> entry : inputMap.entrySet()) {
            result.put(entry.getKey(), RestStatus.valueOf(entry.getValue()));
        }
        return result;
    }

    public DeleteNotificationConfigResponse(Map<String, RestStatus> configIdToStatus) {
        this.configIdToStatus = configIdToStatus == null ? Collections.emptyMap() : Map.copyOf(configIdToStatus);
    }

    public DeleteNotificationConfigResponse(StreamInput input) throws IOException {
        super(input);
        this.configIdToStatus = input.readMap(StreamInput::readString, in -> in.readEnum(RestStatus.class));
    }

    public Map<String, RestStatus> getConfigIdToStatus() {
        return this.configIdToStatus;
    }

    @Override
    public void writeTo(StreamOutput output) throws IOException {
        output.writeMap(this.configIdToStatus, StreamOutput::writeString, (out, status) -> out.writeEnum(status));
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field("delete_response_list", (Object)this.configIdToStatus).endObject();
    }

    @Override
    public RestStatus getStatus() {
        if (this.configIdToStatus == null || this.configIdToStatus.isEmpty()) {
            return RestStatus.NOT_MODIFIED;
        }
        HashSet<RestStatus> distinct = new HashSet<RestStatus>(this.configIdToStatus.values());
        if (distinct.size() > 1) {
            return RestStatus.MULTI_STATUS;
        }
        return (RestStatus)((Object)distinct.iterator().next());
    }
}

