/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.action;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.search.sort.SortOrder;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.core.xcontent.util.XContentUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GetNotificationConfigRequest
extends ActionRequest
implements ToXContentObject {
    private static final Logger log = LogManager.getLogger(GetNotificationConfigRequest.class);
    private final Set<String> configIds;
    private final int fromIndex;
    private final int maxItems;
    private final String sortField;
    private final SortOrder sortOrder;
    private final Map<String, String> filterParams;
    public static final Writeable.Reader<GetNotificationConfigRequest> READER = GetNotificationConfigRequest::new;

    public static GetNotificationConfigRequest parse(XContentParser parser) throws IOException {
        Set<String> configIdList = Collections.emptySet();
        int fromIndex = 0;
        int maxItems = 1000;
        String sortField = null;
        SortOrder sortOrder = null;
        Map<String, String> filterParams = Collections.emptyMap();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        block16: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "config_id_list": {
                    List<String> ids = XContentUtils.stringList(parser);
                    configIdList = Set.copyOf(ids);
                    continue block16;
                }
                case "from_index": {
                    fromIndex = parser.intValue();
                    continue block16;
                }
                case "max_items": {
                    maxItems = parser.intValue();
                    continue block16;
                }
                case "sort_field": {
                    sortField = parser.textOrNull();
                    continue block16;
                }
                case "sort_order": {
                    sortOrder = SortOrder.fromString(parser.text());
                    continue block16;
                }
                case "filter_param_list": {
                    filterParams = parser.mapStrings();
                    continue block16;
                }
            }
            parser.skipChildren();
            log.info("Unexpected field: {} while parsing GetNotificationConfigRequest", (Object)fieldName);
        }
        return new GetNotificationConfigRequest(configIdList, fromIndex, maxItems, sortField, sortOrder, filterParams);
    }

    public GetNotificationConfigRequest() {
        this(Collections.emptySet(), 0, 1000, null, null, Collections.emptyMap());
    }

    public GetNotificationConfigRequest(Set<String> configIds, int fromIndex, int maxItems, String sortField, SortOrder sortOrder, Map<String, String> filterParams) {
        this.configIds = configIds == null ? Collections.emptySet() : Set.copyOf(configIds);
        this.fromIndex = fromIndex;
        this.maxItems = maxItems;
        this.sortField = sortField;
        this.sortOrder = sortOrder;
        this.filterParams = filterParams == null ? Collections.emptyMap() : Map.copyOf(filterParams);
    }

    public GetNotificationConfigRequest(StreamInput input) throws IOException {
        super(input);
        List<String> ids = input.readStringList();
        this.configIds = ids == null ? Collections.emptySet() : Set.copyOf(ids);
        this.fromIndex = input.readInt();
        this.maxItems = input.readInt();
        this.sortField = input.readOptionalString();
        this.sortOrder = input.readOptionalWriteable(in -> in.readEnum(SortOrder.class));
        this.filterParams = input.readMap(StreamInput::readString, StreamInput::readString);
    }

    public Set<String> getConfigIds() {
        return this.configIds;
    }

    public int getFromIndex() {
        return this.fromIndex;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public String getSortField() {
        return this.sortField;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Map<String, String> getFilterParams() {
        return this.filterParams;
    }

    @Override
    public void writeTo(StreamOutput output) throws IOException {
        super.writeTo(output);
        output.writeStringCollection(this.configIds);
        output.writeInt(this.fromIndex);
        output.writeInt(this.maxItems);
        output.writeOptionalString(this.sortField);
        output.writeOptionalWriteable(this.sortOrder);
        output.writeMap(this.filterParams, StreamOutput::writeString, StreamOutput::writeString);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("config_id_list", this.configIds).field("from_index", this.fromIndex).field("max_items", this.maxItems);
        XContentUtils.fieldIfNotNull(builder, "sort_field", this.sortField);
        XContentUtils.fieldIfNotNull(builder, "sort_order", this.sortOrder);
        builder.field("filter_param_list", (Object)this.filterParams);
        return builder.endObject();
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.fromIndex < 0) {
            validationException = ValidateActions.addValidationError((String)"fromIndex is -ve", validationException);
        }
        if (this.maxItems <= 0) {
            validationException = ValidateActions.addValidationError((String)"maxItems is not +ve", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }
}

