/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.action;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.action.BaseResponse;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GetPluginFeaturesResponse
extends BaseResponse {
    private static final Logger log = LogManager.getLogger(GetPluginFeaturesResponse.class);
    private final List<String> allowedConfigTypeList;
    private final Map<String, String> pluginFeatures;
    public static final Writeable.Reader<GetPluginFeaturesResponse> READER = GetPluginFeaturesResponse::new;

    public static GetPluginFeaturesResponse parse(XContentParser parser) throws IOException {
        List<String> allowedConfigTypeList = null;
        Map<String, String> pluginFeatures = null;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "allowed_config_type_list": {
                    allowedConfigTypeList = GetPluginFeaturesResponse.parseStringList(parser);
                    continue block8;
                }
                case "plugin_features": {
                    pluginFeatures = parser.mapStrings();
                    continue block8;
                }
            }
            parser.skipChildren();
            log.info("Unexpected field: {}, while parsing DeleteNotificationConfigResponse", (Object)fieldName);
        }
        if (allowedConfigTypeList == null) {
            throw new IllegalArgumentException("allowed_config_type_list field absent");
        }
        if (pluginFeatures == null) {
            throw new IllegalArgumentException("plugin_features field absent");
        }
        return new GetPluginFeaturesResponse(allowedConfigTypeList, pluginFeatures);
    }

    private static List<String> parseStringList(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.currentToken(), parser);
        ArrayList<String> list = new ArrayList<String>();
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            list.add(parser.text());
        }
        return list;
    }

    public GetPluginFeaturesResponse(List<String> allowedConfigTypeList, Map<String, String> pluginFeatures) {
        this.allowedConfigTypeList = allowedConfigTypeList;
        this.pluginFeatures = pluginFeatures;
    }

    public GetPluginFeaturesResponse(StreamInput in) throws IOException {
        super(in);
        this.allowedConfigTypeList = in.readStringList();
        this.pluginFeatures = in.readMap(StreamInput::readString, StreamInput::readString);
    }

    public List<String> getAllowedConfigTypeList() {
        return this.allowedConfigTypeList;
    }

    public Map<String, String> getPluginFeatures() {
        return this.pluginFeatures;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.allowedConfigTypeList);
        out.writeMap(this.pluginFeatures, (o, key) -> o.writeString((String)key), (o, value) -> o.writeString((String)value));
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field("allowed_config_type_list", this.allowedConfigTypeList).field("plugin_features", (Object)this.pluginFeatures).endObject();
    }
}

