/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.action;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.legacy.destination.message.LegacyBaseMessage;
import io.skylite.core.notifications.legacy.destination.message.LegacyChimeMessage;
import io.skylite.core.notifications.legacy.destination.message.LegacyCustomWebhookMessage;
import io.skylite.core.notifications.legacy.destination.message.LegacyDestinationType;
import io.skylite.core.notifications.legacy.destination.message.LegacyEmailMessage;
import io.skylite.core.notifications.legacy.destination.message.LegacySNSMessage;
import io.skylite.core.notifications.legacy.destination.message.LegacySlackMessage;
import java.io.IOException;

public class LegacyPublishNotificationRequest
extends ActionRequest {
    private final LegacyBaseMessage baseMessage;
    public static final Writeable.Reader<LegacyPublishNotificationRequest> READER = LegacyPublishNotificationRequest::new;

    public LegacyPublishNotificationRequest(LegacyBaseMessage baseMessage) {
        this.baseMessage = baseMessage;
    }

    public LegacyPublishNotificationRequest(StreamInput in) throws IOException {
        super(in);
        LegacyDestinationType destinationType = in.readEnum(LegacyDestinationType.class);
        if (destinationType == null) {
            throw new IllegalArgumentException("Destination type cannot be null");
        }
        switch (destinationType) {
            case LEGACY_CHIME: {
                this.baseMessage = new LegacyChimeMessage(in);
                break;
            }
            case LEGACY_CUSTOM_WEBHOOK: {
                this.baseMessage = new LegacyCustomWebhookMessage(in);
                break;
            }
            case LEGACY_SLACK: {
                this.baseMessage = new LegacySlackMessage(in);
                break;
            }
            case LEGACY_EMAIL: {
                this.baseMessage = new LegacyEmailMessage(in);
                break;
            }
            case LEGACY_SNS: {
                this.baseMessage = new LegacySNSMessage(in);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported destination type: " + String.valueOf((Object)destinationType));
            }
        }
    }

    public LegacyBaseMessage getBaseMessage() {
        return this.baseMessage;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeEnum(this.baseMessage.getChannelType());
        this.baseMessage.writeTo(out);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }
}

