/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.action;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.model.ChannelMessage;
import io.skylite.core.notifications.model.EventSource;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SendNotificationRequest
extends ActionRequest
implements ToXContentObject {
    private static final Logger log = LogManager.getLogger(SendNotificationRequest.class);
    private final EventSource eventSource;
    private final ChannelMessage channelMessage;
    private final List<String> channelIds;
    private final String threadContext;
    public static final Writeable.Reader<SendNotificationRequest> READER = SendNotificationRequest::new;

    public static SendNotificationRequest parse(XContentParser parser) throws IOException {
        EventSource eventSource = null;
        ChannelMessage channelMessage = null;
        List<String> channelIds = null;
        String threadContext = null;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "event_source": {
                    eventSource = EventSource.parse(parser);
                    continue block12;
                }
                case "channel_message": {
                    channelMessage = ChannelMessage.parse(parser);
                    continue block12;
                }
                case "channel_id_list": {
                    channelIds = SendNotificationRequest.parseStringList(parser);
                    continue block12;
                }
                case "context": {
                    threadContext = parser.textOrNull();
                    continue block12;
                }
            }
            parser.skipChildren();
            log.info("Unexpected field: {}, while parsing SendNotificationRequest", (Object)fieldName);
        }
        if (eventSource == null) {
            throw new IllegalArgumentException("event_source field absent");
        }
        if (channelMessage == null) {
            throw new IllegalArgumentException("channel_message field absent");
        }
        if (channelIds == null) {
            throw new IllegalArgumentException("channel_id_list field absent");
        }
        return new SendNotificationRequest(eventSource, channelMessage, channelIds, threadContext);
    }

    private static List<String> parseStringList(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.currentToken(), parser);
        ArrayList<String> list = new ArrayList<String>();
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            list.add(parser.text());
        }
        return list;
    }

    public SendNotificationRequest(EventSource eventSource, ChannelMessage channelMessage, List<String> channelIds, String threadContext) {
        this.eventSource = eventSource;
        this.channelMessage = channelMessage;
        this.channelIds = channelIds;
        this.threadContext = threadContext;
    }

    public SendNotificationRequest(StreamInput in) throws IOException {
        super(in);
        this.eventSource = EventSource.READER.read(in);
        this.channelMessage = ChannelMessage.READER.read(in);
        this.channelIds = in.readStringList();
        this.threadContext = in.readOptionalString();
    }

    public EventSource getEventSource() {
        return this.eventSource;
    }

    public ChannelMessage getChannelMessage() {
        return this.channelMessage;
    }

    public List<String> getChannelIds() {
        return this.channelIds;
    }

    public String getThreadContext() {
        return this.threadContext;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.eventSource.writeTo(out);
        this.channelMessage.writeTo(out);
        out.writeStringCollection(this.channelIds);
        out.writeOptionalString(this.threadContext);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("event_source", this.eventSource);
        builder.field("channel_message", this.channelMessage);
        builder.field("channel_id_list", this.channelIds);
        if (this.threadContext != null) {
            builder.field("context", this.threadContext);
        }
        return builder.endObject();
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.channelIds.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"channelIds is empty", validationException);
        }
        return validationException;
    }
}

